/*
 * Decompiled with CFR 0.152.
 */
package net.miauczel.legendary_monsters.entity.custom;

import com.google.common.collect.ImmutableList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Stream;
import net.miauczel.legendary_monsters.config.ModConfig;
import net.miauczel.legendary_monsters.effect.ModEffects;
import net.miauczel.legendary_monsters.entity.CameraShakeEntity;
import net.miauczel.legendary_monsters.entity.IAnimatedMonster;
import net.miauczel.legendary_monsters.entity.ai.goal.IAttackGoal;
import net.miauczel.legendary_monsters.entity.ai.goal.IMoveGoal;
import net.miauczel.legendary_monsters.entity.ai.goal.IStateGoal;
import net.miauczel.legendary_monsters.entity.ai.navigation.EntityRotationPatcher;
import net.miauczel.legendary_monsters.entity.ai.navigation.ModPathNavigation;
import net.miauczel.legendary_monsters.entity.custom.IceSpikeEntity;
import net.miauczel.legendary_monsters.entity.custom.Lava_eaterEntity;
import net.miauczel.legendary_monsters.entity.custom.MossyGolemEntity;
import net.miauczel.legendary_monsters.item.ModItems;
import net.miauczel.legendary_monsters.sound.ModSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.SnowGolem;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class Frostbitten_GolemEntity
extends IAnimatedMonster {
    private static final EntityDataAccessor<Boolean> DROPPEDICE1 = SynchedEntityData.m_135353_(Frostbitten_GolemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DROPPEDICE2 = SynchedEntityData.m_135353_(Frostbitten_GolemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> LASERED = SynchedEntityData.m_135353_(Frostbitten_GolemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int cooldown = 0;
    private static final int COOLDOWN_DURATION = 40;
    private static final float MAX_ROTATION = 0.0f;
    private static final float ROTATION_SPEED = 0.2f;
    private static final int TELEPORT_COOLDOWN_DURATION = 140;
    private int teleportCooldown = 0;
    private int smashCooldown = 0;
    private final int SMASH_COOLDOWN = 160;
    public int bigsmashCooldown = 0;
    public final int SMASH_ANCHOR_COOLDOWN = 160;
    public final int SMASH_ANCHOR2_COOLDOWN = 100;
    public int bigsmash2Cooldown = 0;
    public AnimationState idleAnimationState = new AnimationState();
    public AnimationState awakeAnimationState = new AnimationState();
    public AnimationState sleepAnimationState = new AnimationState();
    public AnimationState attackarm1AnimationState = new AnimationState();
    public AnimationState attackarm2AnimationState = new AnimationState();
    public AnimationState attackarmsAnimationState = new AnimationState();
    public AnimationState iceSpikeSummonAnimationState = new AnimationState();
    public AnimationState aggresiveIceSpikeSummonAnimationState = new AnimationState();
    public AnimationState deathAnimationState = new AnimationState();
    public AnimationState laserAnimationState = new AnimationState();
    public int golemDeathTIme;

    public Frostbitten_GolemEntity(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_21364_ = 100;
        this.m_6210_();
        this.m_21557_(false);
        this.m_21530_();
        this.m_21530_();
    }

    protected PathNavigation m_6037_(Level worldIn) {
        return new ModPathNavigation((Mob)this, worldIn);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("is_Sleep", this.isSleep());
        compound.m_128379_("DroppedIce1", ((Boolean)this.f_19804_.m_135370_(DROPPEDICE1)).booleanValue());
        compound.m_128379_("DroppedIce2", ((Boolean)this.f_19804_.m_135370_(DROPPEDICE2)).booleanValue());
        compound.m_128379_("lasered", ((Boolean)this.f_19804_.m_135370_(LASERED)).booleanValue());
    }

    public void attackTargets(Entity entity1) {
        DamageSource damageSource = new DamageSource((Holder)this.m_9236_().m_9598_().m_175515_(Registries.f_268580_).m_246971_(DamageTypes.f_268566_), (Entity)this);
        double damage = 14.0 * (Double)ModConfig.MOB_CONFIG.FrostbittenGolemDamageMutliplier.get();
        if (entity1 instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity1;
            if (this.m_9236_().m_46791_() == Difficulty.HARD) {
                livingEntity.m_6469_(damageSource, (float)(damage - 4.0));
            } else if (this.m_9236_().m_46791_() == Difficulty.NORMAL) {
                livingEntity.m_6469_(damageSource, (float)damage);
            } else if (this.m_9236_().m_46791_() == Difficulty.EASY) {
                livingEntity.m_6469_(damageSource, (float)(damage + 13.0));
            }
        }
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setSleep(compound.m_128471_("is_Sleep"));
        this.f_19804_.m_135381_(DROPPEDICE1, (Object)compound.m_128471_("DroppedIce1"));
        this.f_19804_.m_135381_(DROPPEDICE2, (Object)compound.m_128471_("DroppedIce2"));
        this.f_19804_.m_135381_(LASERED, (Object)compound.m_128471_("lasered"));
        if (this.m_21223_() == this.m_21233_()) {
            this.updateAttributes();
        }
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DROPPEDICE1, (Object)false);
        this.f_19804_.m_135372_(DROPPEDICE2, (Object)false);
        this.f_19804_.m_135372_(LASERED, (Object)false);
    }

    public void resetSmashAnchorCooldown() {
        if (this.bigsmashCooldown <= 0) {
            this.bigsmashCooldown = 160;
        }
    }

    public void resetSmash2Cooldown() {
        if (this.bigsmash2Cooldown <= 0) {
            this.bigsmash2Cooldown = 100;
        }
    }

    public void resetSmashCooldown() {
        if (this.smashCooldown <= 0) {
            this.smashCooldown = 160;
        }
    }

    public boolean HasAttackedWithLaser() {
        return (Boolean)this.f_19804_.m_135370_(LASERED);
    }

    @Override
    public void m_8119_() {
        ItemStack primalIceShard;
        Crackiness crackiness;
        super.m_8119_();
        this.updateWithAttack();
        if (this.smashCooldown > 0) {
            --this.smashCooldown;
        }
        if (this.teleportCooldown > 0) {
            --this.teleportCooldown;
        }
        if (this.bigsmashCooldown > 0) {
            --this.bigsmashCooldown;
        }
        if (this.bigsmash2Cooldown > 0) {
            --this.bigsmash2Cooldown;
        }
        if ((crackiness = this.getCrackiness()) == Crackiness.MEDIUM && !((Boolean)this.f_19804_.m_135370_(DROPPEDICE1)).booleanValue()) {
            this.playCrackSound();
            this.f_19804_.m_135381_(DROPPEDICE1, (Object)true);
            primalIceShard = new ItemStack((ItemLike)ModItems.PRIMAL_ICE_SHARD.get(), 1);
            this.LGspawnatlocation(primalIceShard);
        }
        if (crackiness == Crackiness.HIGH && !((Boolean)this.f_19804_.m_135370_(DROPPEDICE2)).booleanValue()) {
            this.playCrackSound();
            this.f_19804_.m_135381_(DROPPEDICE2, (Object)true);
            primalIceShard = new ItemStack((ItemLike)ModItems.PRIMAL_ICE_SHARD.get(), 1);
            this.LGspawnatlocation(primalIceShard);
        }
        this.updateAttributes();
        if (this.m_9236_().m_5776_()) {
            // empty if block
        }
    }

    private void playCrackSound() {
        this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_144242_, SoundSource.NEUTRAL, 3.0f, 1.0f);
        this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_11983_, SoundSource.NEUTRAL, 2.0f, 1.0f);
        this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_12019_, SoundSource.NEUTRAL, 15.0f, 1.0f);
    }

    public Crackiness getCrackiness() {
        return Crackiness.byFraction(this.m_21223_() / this.m_21233_());
    }

    public void performAreaAttack() {
        double attackRadius = 4.0;
        double attackHeight = 3.0;
        AABB attackBox = new AABB(this.m_20185_() - attackRadius, this.m_20186_(), this.m_20189_() - attackRadius, this.m_20185_() + attackRadius, this.m_20186_() + attackHeight, this.m_20189_() + attackRadius);
        List entities = this.m_9236_().m_45933_((Entity)this, attackBox);
        for (Entity entity : entities) {
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity livingEntity = (LivingEntity)entity;
            if (entity == this || entity == this.m_5448_() || entity instanceof CameraShakeEntity) continue;
            this.m_7327_((Entity)livingEntity);
        }
    }

    @Nullable
    public ItemEntity LGspawnatlocation(ItemStack pStack) {
        pStack.m_41700_("Enchantments", (Tag)new ListTag());
        ItemEntity itemEntity = this.m_5552_(pStack, 3.0f);
        if (itemEntity != null) {
            itemEntity.m_146915_(true);
        }
        return itemEntity;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, SnowGolem.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Lava_eaterEntity.class, true));
        this.f_21345_.m_25352_(2, (Goal)new IMoveGoal(this, false, 3.0));
        this.f_21345_.m_25352_(1, (Goal)new IAttackGoal(this, 0, 7, 0, 35, 10, 5.0f){

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && Frostbitten_GolemEntity.this.m_217043_().m_188501_() * 45.0f < 16.0f && Frostbitten_GolemEntity.this.bigsmashCooldown <= 0 && Frostbitten_GolemEntity.this.m_5448_() != null && Frostbitten_GolemEntity.this.getAttackState() != 9;
            }

            @Override
            public void m_8041_() {
                super.m_8041_();
                Frostbitten_GolemEntity.this.resetSmashAnchorCooldown();
            }
        });
        this.f_21345_.m_25352_(1, (Goal)new IAttackGoal(this, 0, 3, 0, 46, 10, 5.0f){

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && Frostbitten_GolemEntity.this.m_217043_().m_188501_() * 25.0f < 16.0f && Frostbitten_GolemEntity.this.bigsmash2Cooldown <= 0 && Frostbitten_GolemEntity.this.m_5448_() != null && Frostbitten_GolemEntity.this.getAttackState() != 9;
            }

            @Override
            public void m_8041_() {
                super.m_8041_();
                Frostbitten_GolemEntity.this.resetSmash2Cooldown();
            }
        });
        this.f_21345_.m_25352_(1, (Goal)new IAttackGoal(this, 0, 4, 0, 46, 15, 5.0f){

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && Frostbitten_GolemEntity.this.m_217043_().m_188501_() * 35.0f < 16.0f && Frostbitten_GolemEntity.this.smashCooldown <= 0 && Frostbitten_GolemEntity.this.m_5448_() != null && Frostbitten_GolemEntity.this.getAttackState() != 9;
            }

            @Override
            public void m_8041_() {
                super.m_8041_();
                Frostbitten_GolemEntity.this.resetSmashCooldown();
            }
        });
        this.f_21345_.m_25352_(1, (Goal)new IAttackGoal(this, 0, 6, 0, 46, 75, 5.0f));
        this.f_21345_.m_25352_(1, (Goal)new IAttackGoal(this, 0, 5, 0, 46, 30, 12.0f){

            @Override
            public void m_8056_() {
                super.m_8056_();
            }

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && Frostbitten_GolemEntity.this.m_217043_().m_188501_() * 20.0f < 9.0f && Frostbitten_GolemEntity.this.teleportCooldown <= 0 && Frostbitten_GolemEntity.this.getAttackState() != 9;
            }

            @Override
            public void m_8041_() {
                super.m_8041_();
                Frostbitten_GolemEntity.this.m_20331_(false);
                Frostbitten_GolemEntity.this.teleportCooldown = 60;
            }
        });
        this.f_21345_.m_25352_(1, (Goal)new IStateGoal(this, 1, 1, 0, 0, 0){

            @Override
            public void m_8037_() {
                this.entity.m_20334_(0.0, this.entity.m_20184_().f_82480_, 0.0);
            }
        });
        this.f_21345_.m_25352_(0, (Goal)new IAttackGoal(this, 1, 2, 0, 20, 0, 15.0f){

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && Frostbitten_GolemEntity.this.getAttackState() != 9;
            }
        });
    }

    public void m_8107_() {
        LivingEntity target;
        super.m_8107_();
        if (this.m_21224_()) {
            this.m_146922_(0.0f);
            this.m_146926_(0.0f);
            this.f_20883_ = 90.0f;
            this.f_20885_ = 0.0f;
            this.m_20256_(this.m_20184_().m_82542_(1.0, 1.0, 1.0));
        }
        if ((target = this.m_5448_()) != null) {
            double targetX = target.m_20185_() - this.m_20185_();
            double targetY = target.m_20188_() - this.m_20188_();
            double targetZ = target.m_20189_() - this.m_20189_();
            double horizontalDistance = Math.sqrt(targetX * targetX + targetZ * targetZ);
            float yaw = (float)(Math.atan2(targetZ, targetX) * 57.29577951308232) - 90.0f;
            float pitch = (float)(-(Math.atan2(targetY, horizontalDistance) * 57.29577951308232));
            this.f_20885_ = this.f_20883_ = yaw;
            this.f_20883_ = pitch;
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_21183_().m_22268_(Attributes.f_22276_, 220.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22277_, 30.0).m_22268_(Attributes.f_22284_, 10.0).m_22268_(Attributes.f_22279_, (double)0.1f).m_22268_(Attributes.f_22282_, 1.0).m_22268_(Attributes.f_22281_, 16.0);
    }

    public void updateAttributes() {
        double healthMultiplier = (Double)ModConfig.MOB_CONFIG.FrostbittenGolemHealthMultiplier.get();
        double damageMultiplier = (Double)ModConfig.MOB_CONFIG.FrostbittenGolemDamageMutliplier.get();
        AttributeInstance healthAttribute = this.m_21051_(Attributes.f_22276_);
        AttributeInstance attackDamageAttribute = this.m_21051_(Attributes.f_22281_);
        double baseHealth = 180.0;
        double baseAttackDamage = 16.0;
        double newHealth = baseHealth * healthMultiplier;
        double newAttackDamage = baseAttackDamage * damageMultiplier;
        if (healthAttribute != null && healthAttribute.m_22115_() != newHealth) {
            healthAttribute.m_22100_(newHealth);
            this.m_21153_((float)newHealth);
        }
        if (attackDamageAttribute != null && attackDamageAttribute.m_22115_() != newAttackDamage) {
            attackDamageAttribute.m_22100_(newAttackDamage);
        }
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return (SoundEvent)ModSounds.OVERGROWN_COLOSSUS_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.OVERGROWN_COLOSSUS_DEATH.get();
    }

    protected boolean canDespawn() {
        this.m_21530_();
        return true;
    }

    public void m_6667_(DamageSource source) {
        super.m_6667_(source);
        this.golemDeathTIme = 0;
        this.setAttackState(8);
        this.f_20883_ = 0.0f;
        this.f_20885_ = 0.0f;
        this.m_146922_(0.0f);
        this.m_146926_(0.0f);
        ItemStack diamond = new ItemStack((ItemLike)ModItems.FROZEN_RUNE.get(), 1);
        ItemStack emerald = new ItemStack((ItemLike)Items.f_41852_, 1);
        emerald = this.getItemWithLootingEnchant(emerald, source.m_7639_());
        this.m_19983_(emerald);
    }

    private ItemStack getItemWithLootingEnchant(ItemStack stack, Entity killer) {
        int lootingLevel;
        if (killer instanceof Player && (lootingLevel = EnchantmentHelper.m_44836_((Enchantment)Enchantments.f_44982_, (LivingEntity)((LivingEntity)killer))) > 0) {
            stack.m_41769_(lootingLevel);
        }
        return stack;
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        this.m_21530_();
    }

    public boolean m_6094_() {
        return true;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.isSleep() && !source.m_269533_(DamageTypeTags.f_268738_)) {
            return false;
        }
        if (((Boolean)ModConfig.MOB_CONFIG.Frostbittenprojectile.get()).booleanValue() && source.m_7640_() instanceof AbstractArrow) {
            return false;
        }
        if (source.m_7640_() instanceof ThrownPotion || source.m_7640_() instanceof AreaEffectCloud) {
            return false;
        }
        if (source.m_276093_(DamageTypes.f_268671_)) {
            return false;
        }
        return super.m_6469_(source, amount);
    }

    public void m_6457_(ServerPlayer player) {
        super.m_6457_(player);
    }

    public void m_6452_(ServerPlayer player) {
        super.m_6452_(player);
    }

    public AnimationState getAnimationState(String input) {
        if (input == "sleep") {
            return this.sleepAnimationState;
        }
        if (input == "awake") {
            return this.awakeAnimationState;
        }
        if (input == "idle") {
            return this.idleAnimationState;
        }
        if (input == "attackarmright") {
            return this.attackarm1AnimationState;
        }
        if (input == "attackarmleft") {
            return this.attackarm2AnimationState;
        }
        if (input == "attackarms") {
            return this.attackarmsAnimationState;
        }
        if (input == "attackicespike") {
            return this.iceSpikeSummonAnimationState;
        }
        if (input == "attackaggresive") {
            return this.aggresiveIceSpikeSummonAnimationState;
        }
        if (input == "death") {
            return this.deathAnimationState;
        }
        if (input == "laser") {
            return this.laserAnimationState;
        }
        return new AnimationState();
    }

    public int deathtimer() {
        return 60;
    }

    public boolean isSleep() {
        return this.getAttackState() == 1 || this.getAttackState() == 2;
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor p_29678_, DifficultyInstance p_29679_, MobSpawnType p_29680_, @javax.annotation.Nullable SpawnGroupData p_29681_, @javax.annotation.Nullable CompoundTag p_29682_) {
        this.setSleep(true);
        return super.m_6518_(p_29678_, p_29679_, p_29680_, p_29681_, p_29682_);
    }

    public void setSleep(boolean sleep) {
        this.setAttackState(sleep ? 1 : 0);
    }

    public void m_7350_(EntityDataAccessor<?> p_21104_) {
        if (ATTACK_STATE.equals(p_21104_) && this.m_9236_().f_46443_) {
            switch (this.getAttackState()) {
                case 0: {
                    this.stopAllAnimationStates();
                    break;
                }
                case 1: {
                    this.stopAllAnimationStates();
                    this.sleepAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 2: {
                    this.stopAllAnimationStates();
                    this.awakeAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 3: {
                    this.stopAllAnimationStates();
                    this.attackarm1AnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 4: {
                    this.stopAllAnimationStates();
                    this.attackarm2AnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 5: {
                    this.stopAllAnimationStates();
                    this.iceSpikeSummonAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 6: {
                    this.stopAllAnimationStates();
                    this.attackarmsAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 7: {
                    this.stopAllAnimationStates();
                    this.aggresiveIceSpikeSummonAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 8: {
                    this.stopAllAnimationStates();
                    this.deathAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 9: {
                    this.stopAllAnimationStates();
                    this.laserAnimationState.m_216982_(this.f_19797_);
                }
            }
        }
        super.m_7350_(p_21104_);
    }

    public void stopAllAnimationStates() {
        this.sleepAnimationState.m_216973_();
        this.awakeAnimationState.m_216973_();
        this.attackarmsAnimationState.m_216973_();
        this.iceSpikeSummonAnimationState.m_216973_();
        this.aggresiveIceSpikeSummonAnimationState.m_216973_();
        this.attackarm1AnimationState.m_216973_();
        this.attackarm2AnimationState.m_216973_();
        this.deathAnimationState.m_216973_();
        this.laserAnimationState.m_216973_();
    }

    private void launch(LivingEntity entity, boolean huge) {
        double deltaX = entity.m_20185_() - this.m_20185_();
        double deltaZ = entity.m_20189_() - this.m_20189_();
        double distanceSquared = Math.max(deltaX * deltaX + deltaZ * deltaZ, 0.001);
        float multiplier = huge ? 2.0f : 0.5f;
        entity.m_5997_(deltaX / distanceSquared * (double)multiplier, huge ? 0.5 : 0.2, deltaZ / distanceSquared * (double)multiplier);
    }

    private void launchMini(LivingEntity entity, boolean huge) {
        double deltaX = entity.m_20185_() - this.m_20185_();
        double deltaZ = entity.m_20189_() - this.m_20189_();
        double distanceSquared = Math.max(deltaX * deltaX + deltaZ * deltaZ, 0.001);
        float multiplier = huge ? 1.2f : 0.5f;
        entity.m_5997_(deltaX / distanceSquared * (double)multiplier, huge ? 0.3 : 0.2, deltaZ / distanceSquared * (double)multiplier);
    }

    private void AreaAttack(float range, float height, float arc, float damage, int shieldbreakticks, boolean stun, float knockback, boolean BNknockback, float Lstrenght, boolean launch) {
        List<LivingEntity> entitiesHit = this.getEntityLivingBaseNearby(range, height, range, range);
        for (LivingEntity entityHit : entitiesHit) {
            float entityHitAngle = (float)((Math.atan2(entityHit.m_20189_() - this.m_20189_(), entityHit.m_20185_() - this.m_20185_()) * 57.29577951308232 - 90.0) % 360.0);
            float entityAttackingAngle = this.f_20883_ % 360.0f;
            if (entityHitAngle < 0.0f) {
                entityHitAngle += 360.0f;
            }
            if (entityAttackingAngle < 0.0f) {
                entityAttackingAngle += 360.0f;
            }
            float entityRelativeAngle = entityHitAngle - entityAttackingAngle;
            float entityHitDistance = (float)Math.sqrt((entityHit.m_20189_() - this.m_20189_()) * (entityHit.m_20189_() - this.m_20189_()) + (entityHit.m_20185_() - this.m_20185_()) * (entityHit.m_20185_() - this.m_20185_()));
            if (!(entityHitDistance <= range && entityRelativeAngle <= arc / 2.0f && entityRelativeAngle >= -arc / 2.0f || entityRelativeAngle >= 360.0f - arc / 2.0f) && !(entityRelativeAngle <= -360.0f + arc / 2.0f) || this.m_7307_((Entity)entityHit) || entityHit instanceof Frostbitten_GolemEntity || entityHit instanceof MossyGolemEntity || entityHit == this) continue;
            if (!stun && !entityHit.m_21254_() && Math.random() > 0.5) {
                entityHit.m_7292_(new MobEffectInstance((MobEffect)ModEffects.FREEZE.get(), 40, 5));
            }
            entityHit.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), (float)((double)damage * (Double)ModConfig.MOB_CONFIG.FrostbittenGolemDamageMutliplier.get()));
            if ((this.getAttackState() == 4 || this.getAttackState() == 3) && this.attackTicks == 20) {
                if (BNknockback && !entityHit.m_21254_()) {
                    double knockbackRadius = 5.0;
                    double dx = entityHit.m_20185_() - this.m_20185_();
                    double dz = entityHit.m_20189_() - this.m_20189_();
                    double distance = Math.sqrt(dx * dx + dz * dz);
                    double knockbackStrength = (double)knockback + 0.5 * (knockbackRadius - distance);
                    entityHit.m_5997_(dx / distance * knockbackStrength, 0.4, dz / distance * knockbackStrength);
                }
                Vec3 entityPosition = this.m_20182_();
                CameraShakeEntity.cameraShake(this.m_9236_(), entityPosition, 20.0f, 0.15f, 0, 20);
            }
            if (launch) {
                if (this.getAttackState() == 6 || this.getAttackState() == 7) {
                    this.launch(entityHit, true);
                }
                if (this.getAttackState() == 4) {
                    this.launchMini(entityHit, true);
                }
                if (this.getAttackState() == 3) {
                    this.launchMini(entityHit, true);
                }
            }
            if (!entityHit.m_21254_()) {
                // empty if block
            }
            if (!(entityHit instanceof Player) || !entityHit.m_21254_() || shieldbreakticks <= 0) continue;
            Frostbitten_GolemEntity.disableShield(entityHit, shieldbreakticks);
        }
    }

    protected BodyRotationControl m_7560_() {
        return new EntityRotationPatcher((Mob)this);
    }

    public void updateWithAttack() {
        Vec3 entityPosition;
        if (this.getAttackState() == 3 && this.attackTicks == 16) {
            this.m_5496_((SoundEvent)ModSounds.ENDERSENT_ATTACK.get(), 1.0f, 1.0f);
            this.AreaAttack(6.0f, 5.0f, 150.0f, 12.0f, 40, false, 0.5f, true, 0.25f, true);
            entityPosition = this.m_20182_();
            CameraShakeEntity.cameraShake(this.m_9236_(), entityPosition, 20.0f, 0.15f, 0, 20);
        }
        if (this.getAttackState() == 4 && this.attackTicks == 16) {
            this.m_5496_((SoundEvent)ModSounds.ENDERSENT_ATTACK.get(), 1.0f, 1.0f);
            this.AreaAttack(6.0f, 5.0f, 150.0f, 12.0f, 40, false, 0.5f, true, 0.25f, true);
            entityPosition = this.m_20182_();
            CameraShakeEntity.cameraShake(this.m_9236_(), entityPosition, 20.0f, 0.15f, 0, 20);
        }
        if (this.getAttackState() == 6) {
            if (this.attackTicks == 18) {
                this.m_5496_((SoundEvent)ModSounds.ENDERSENT_ATTACK.get(), 1.0f, 1.0f);
                this.AreaAttack(7.0f, 6.0f, 170.0f, 13.0f, 100, false, 0.5f, true, 0.25f, true);
                entityPosition = this.m_20182_();
                CameraShakeEntity.cameraShake(this.m_9236_(), entityPosition, 20.0f, 0.15f, 0, 20);
            }
            if (this.attackTicks == 28) {
                float f3;
                float f2;
                int k;
                int standingOnY;
                Crackiness crackiness = this.getCrackiness();
                if (crackiness == Crackiness.MEDIUM && this.m_5448_() != null) {
                    standingOnY = Mth.m_14107_((double)this.m_20186_());
                    for (k = 0; k < 6; ++k) {
                        f2 = (float)k * (float)Math.PI * 2.0f / 6.0f + 1.2566371f;
                        this.spawnIceSpikesAdvanced(this.m_5448_().m_20185_() + (double)Mth.m_14089_((float)f2) * 2.5, this.m_5448_().m_20189_() + (double)Mth.m_14031_((float)f2) * 2.5, standingOnY, this.m_5448_().m_20186_() + 1.0, f2, 0);
                    }
                    for (k = 0; k < 11; ++k) {
                        f3 = (float)k * (float)Math.PI * 2.0f / 11.0f + 0.62831855f;
                        this.spawnIceSpikesAdvanced(this.m_5448_().m_20185_() + (double)Mth.m_14089_((float)f3) * 3.5, this.m_5448_().m_20189_() + (double)Mth.m_14031_((float)f3) * 3.5, standingOnY, this.m_5448_().m_20186_() + 1.0, f3, 2);
                    }
                }
                if (crackiness == Crackiness.HIGH && this.m_5448_() != null) {
                    standingOnY = Mth.m_14107_((double)this.m_20186_());
                    for (k = 0; k < 6; ++k) {
                        f2 = (float)k * (float)Math.PI * 2.0f / 6.0f + 1.2566371f;
                        this.spawnIceSpikesAdvanced(this.m_5448_().m_20185_() + (double)Mth.m_14089_((float)f2) * 2.5, this.m_5448_().m_20189_() + (double)Mth.m_14031_((float)f2) * 2.5, standingOnY, this.m_5448_().m_20186_() + 1.0, f2, 0);
                    }
                    for (k = 0; k < 11; ++k) {
                        f3 = (float)k * (float)Math.PI * 2.0f / 11.0f + 0.62831855f;
                        this.spawnIceSpikesAdvanced(this.m_5448_().m_20185_() + (double)Mth.m_14089_((float)f3) * 3.5, this.m_5448_().m_20189_() + (double)Mth.m_14031_((float)f3) * 3.5, standingOnY, this.m_5448_().m_20186_() + 1.0, f3, 2);
                    }
                    for (k = 0; k < 14; ++k) {
                        float f4 = (float)k * (float)Math.PI * 2.0f / 14.0f + 0.31415927f;
                        this.spawnIceSpikesAdvanced(this.m_5448_().m_20185_() + (double)Mth.m_14089_((float)f4) * 4.5, this.m_5448_().m_20189_() + (double)Mth.m_14031_((float)f4) * 4.5, standingOnY, this.m_5448_().m_20186_() + 1.0, f4, 4);
                    }
                }
            }
        }
        if (this.getAttackState() == 7 && this.attackTicks == 12) {
            int standingOnY = Mth.m_14107_((double)this.m_20186_());
            this.m_5496_((SoundEvent)ModSounds.ENDERSENT_ATTACK.get(), 1.0f, 1.0f);
            this.AreaAttack(6.0f, 4.0f, 100.0f, 13.0f, 80, false, 0.5f, true, 0.25f, true);
            Vec3 entityPosition2 = this.m_20182_();
            CameraShakeEntity.cameraShake(this.m_9236_(), entityPosition2, 20.0f, 0.15f, 0, 20);
            Crackiness crackiness = this.getCrackiness();
            this.getCrackiness();
            if (crackiness == Crackiness.LOW || crackiness == Crackiness.MEDIUM || crackiness == Crackiness.NONE || crackiness == Crackiness.HIGH) {
                float f5;
                int k;
                for (k = 0; k < 6; ++k) {
                    float f2 = (float)k * (float)Math.PI * 2.0f / 6.0f + 1.2566371f;
                    this.spawnIceSpikesAdvanced(this.m_20185_() + (double)Mth.m_14089_((float)f2) * 2.5, this.m_20189_() + (double)Mth.m_14031_((float)f2) * 2.5, standingOnY, this.m_20186_() + 1.0, f2, 0);
                }
                for (k = 0; k < 11; ++k) {
                    float f3 = (float)k * (float)Math.PI * 2.0f / 11.0f + 0.62831855f;
                    this.spawnIceSpikesAdvanced(this.m_20185_() + (double)Mth.m_14089_((float)f3) * 3.5, this.m_20189_() + (double)Mth.m_14031_((float)f3) * 3.5, standingOnY, this.m_20186_() + 1.0, f3, 2);
                }
                for (k = 0; k < 14; ++k) {
                    float f4 = (float)k * (float)Math.PI * 2.0f / 14.0f + 0.31415927f;
                    this.spawnIceSpikesAdvanced(this.m_20185_() + (double)Mth.m_14089_((float)f4) * 4.5, this.m_20189_() + (double)Mth.m_14031_((float)f4) * 4.5, standingOnY, this.m_20186_() + 1.0, f4, 4);
                }
                for (k = 0; k < 19; ++k) {
                    f5 = (float)k * (float)Math.PI * 2.0f / 19.0f + 0.25132743f;
                    this.spawnIceSpikesAdvanced(this.m_20185_() + (double)Mth.m_14089_((float)f5) * 5.5, this.m_20189_() + (double)Mth.m_14031_((float)f5) * 5.5, standingOnY, this.m_20186_() + 1.0, f5, 6);
                }
                for (k = 0; k < 26; ++k) {
                    f5 = (float)k * (float)Math.PI * 2.0f / 26.0f + 0.17951958f;
                    this.spawnIceSpikesAdvanced(this.m_20185_() + (double)Mth.m_14089_((float)f5) * 6.5, this.m_20189_() + (double)Mth.m_14031_((float)f5) * 6.5, standingOnY, this.m_20186_() + 1.0, f5, 8);
                }
            }
        }
        if (this.getAttackState() == 5 && this.attackTicks == 14 && this.m_5448_() != null) {
            this.spawnIceSpikes();
            Crackiness crackiness = this.getCrackiness();
            this.getCrackiness();
            if (crackiness == Crackiness.HIGH) {
                int k;
                int standingOnY = Mth.m_14107_((double)this.m_20186_());
                for (k = 0; k < 6; ++k) {
                    float f2 = (float)k * (float)Math.PI * 2.0f / 6.0f + 1.2566371f;
                    this.spawnIceSpikesAdvanced(this.m_20185_() + (double)Mth.m_14089_((float)f2) * 2.5, this.m_20189_() + (double)Mth.m_14031_((float)f2) * 2.5, standingOnY, this.m_20186_() + 1.0, f2, 0);
                }
                for (k = 0; k < 11; ++k) {
                    float f3 = (float)k * (float)Math.PI * 2.0f / 11.0f + 0.62831855f;
                    this.spawnIceSpikesAdvanced(this.m_20185_() + (double)Mth.m_14089_((float)f3) * 3.5, this.m_20189_() + (double)Mth.m_14031_((float)f3) * 3.5, standingOnY, this.m_20186_() + 1.0, f3, 2);
                }
                for (k = 0; k < 14; ++k) {
                    float f4 = (float)k * (float)Math.PI * 2.0f / 14.0f + 0.31415927f;
                    this.spawnIceSpikesAdvanced(this.m_20185_() + (double)Mth.m_14089_((float)f4) * 4.5, this.m_20189_() + (double)Mth.m_14031_((float)f4) * 4.5, standingOnY, this.m_20186_() + 1.0, f4, 4);
                }
                for (k = 0; k < 19; ++k) {
                    float f5 = (float)k * (float)Math.PI * 2.0f / 19.0f + 0.25132743f;
                    this.spawnIceSpikesAdvanced(this.m_20185_() + (double)Mth.m_14089_((float)f5) * 5.5, this.m_20189_() + (double)Mth.m_14031_((float)f5) * 5.5, standingOnY, this.m_20186_() + 1.0, f5, 6);
                }
                for (k = 0; k < 26; ++k) {
                    float f5 = (float)k * (float)Math.PI * 2.0f / 26.0f + 0.17951958f;
                    this.spawnIceSpikesAdvanced(this.m_20185_() + (double)Mth.m_14089_((float)f5) * 6.5, this.m_20189_() + (double)Mth.m_14031_((float)f5) * 6.5, standingOnY, this.m_20186_() + 1.0, f5, 8);
                }
            }
        }
    }

    private void spawnIceSpikesAdv2(double x, double z, double minY, double maxY, float rotation, int delay) {
        BlockPos blockpos = new BlockPos((int)x, (int)maxY, (int)z);
        boolean flag = false;
        double d0 = 0.0;
        do {
            BlockState blockstate1;
            VoxelShape voxelshape;
            BlockPos blockpos1 = blockpos.m_7495_();
            BlockState blockstate = this.m_5448_().m_9236_().m_8055_(blockpos1);
            if (!blockstate.m_60783_((BlockGetter)this.m_5448_().m_9236_(), blockpos1, Direction.UP)) continue;
            if (!this.m_5448_().m_9236_().m_46859_(blockpos) && !(voxelshape = (blockstate1 = this.m_5448_().m_9236_().m_8055_(blockpos)).m_60812_((BlockGetter)this.m_5448_().m_9236_(), blockpos)).m_83281_()) {
                d0 = voxelshape.m_83297_(Direction.Axis.Y);
            }
            flag = true;
            break;
        } while ((blockpos = blockpos.m_7495_()).m_123342_() >= Mth.m_14107_((double)minY) - 1);
        if (flag) {
            Frostbitten_GolemEntity entity1 = this;
            this.m_5448_().m_9236_().m_7967_((Entity)new IceSpikeEntity(this.m_5448_().m_9236_(), x, (double)blockpos.m_123342_() + d0, z, rotation, delay, (LivingEntity)entity1));
        }
    }

    private void createSpellEntity(double pX, double pZ, double pMinY, double pMaxY, float pYRot, int pWarmupDelay) {
        BlockPos blockpos = BlockPos.m_274561_((double)pX, (double)pMaxY, (double)pZ);
        boolean flag = false;
        double d0 = 0.0;
        do {
            BlockState blockstate1;
            VoxelShape voxelshape;
            BlockPos blockpos1 = blockpos.m_7495_();
            BlockState blockstate = this.m_9236_().m_8055_(blockpos1);
            if (!blockstate.m_60783_((BlockGetter)this.m_9236_(), blockpos1, Direction.UP)) continue;
            if (!this.m_9236_().m_46859_(blockpos) && !(voxelshape = (blockstate1 = this.m_9236_().m_8055_(blockpos)).m_60812_((BlockGetter)this.m_9236_(), blockpos)).m_83281_()) {
                d0 = voxelshape.m_83297_(Direction.Axis.Y);
            }
            flag = true;
            break;
        } while ((blockpos = blockpos.m_7495_()).m_123342_() >= Mth.m_14107_((double)pMinY) - 1);
        if (flag) {
            this.m_9236_().m_7967_((Entity)new IceSpikeEntity(this.m_9236_(), pX, (double)blockpos.m_123342_() + d0, pZ, pYRot, pWarmupDelay, (LivingEntity)this));
        }
    }

    private void spawnLowIceSpikes() {
        LivingEntity target = this.m_5448_();
        if (target != null) {
            int k;
            double d0 = Math.min(target.m_20186_(), this.m_20186_());
            double d1 = Math.max(target.m_20186_(), this.m_20186_()) + 2.0;
            float f = (float)Mth.m_14136_((double)(target.m_20189_() - this.m_20189_()), (double)(target.m_20185_() - this.m_20185_()));
            float f2 = Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180))) * 1.1f;
            float f3 = Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180))) * 1.1f;
            for (k = 0; k < 8; ++k) {
                this.createSpellEntity(this.m_20185_() + this.f_19796_.m_188583_() * 4.5, this.m_20189_() + this.f_19796_.m_188583_() * 4.5, d0, d1, f3, 10);
            }
            for (k = 0; k < 8; ++k) {
                this.createSpellEntity(this.m_20185_() + this.f_19796_.m_188583_() * 4.5, this.m_20189_() + this.f_19796_.m_188583_() * 4.5, d0, d1, f3, 5);
            }
        }
    }

    private void spawnIceSpikes() {
        LivingEntity target = this.m_5448_();
        if (target != null) {
            double d0 = Math.min(target.m_20186_(), this.m_20186_());
            double d1 = Math.max(target.m_20186_(), this.m_20186_()) + 2.0;
            float f = (float)Mth.m_14136_((double)(target.m_20189_() - this.m_20189_()), (double)(target.m_20185_() - this.m_20185_()));
            float f2 = Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180))) * 1.1f;
            float f4 = Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180))) * -0.5f;
            float f3 = Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180))) * 1.1f;
            float f5 = Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180))) * -1.1f;
            for (int l = 0; l < 10; ++l) {
                double d2 = 1.25 * (double)(l + 1);
                double d3 = -1.25 * (double)(l + 1);
                int j = (int)(1.25f * (float)l);
                this.createSpellEntity(this.m_20185_() + (double)f2 + (double)Mth.m_14089_((float)f) * d2, this.m_20189_() + (double)f3 + (double)Mth.m_14031_((float)f) * d2, d0, d1, f, j);
                this.createSpellEntity(this.m_20185_() - (double)f2 + (double)Mth.m_14089_((float)f) * d2, this.m_20189_() - (double)f3 + (double)Mth.m_14031_((float)f) * d2, d0, d1, f, j);
            }
        }
    }

    private void spawnIceSpikesAdvanced(double x, double z, double minY, double maxY, float rotation, int delay) {
        BlockPos blockpos = new BlockPos((int)x, (int)maxY, (int)z);
        boolean flag = false;
        double d0 = 0.0;
        do {
            BlockState blockstate1;
            VoxelShape voxelshape;
            BlockPos blockpos1 = blockpos.m_7495_();
            BlockState blockstate = this.m_9236_().m_8055_(blockpos1);
            if (!blockstate.m_60783_((BlockGetter)this.m_9236_(), blockpos1, Direction.UP)) continue;
            if (!this.m_9236_().m_46859_(blockpos) && !(voxelshape = (blockstate1 = this.m_9236_().m_8055_(blockpos)).m_60812_((BlockGetter)this.m_9236_(), blockpos)).m_83281_()) {
                d0 = voxelshape.m_83297_(Direction.Axis.Y);
            }
            flag = true;
            break;
        } while ((blockpos = blockpos.m_7495_()).m_123342_() >= Mth.m_14107_((double)minY) - 1);
        if (flag) {
            Frostbitten_GolemEntity entity1 = this;
            this.m_9236_().m_7967_((Entity)new IceSpikeEntity(this.m_9236_(), x, (double)blockpos.m_123342_() + d0, z, rotation, delay, (LivingEntity)entity1));
        }
    }

    protected void m_6153_() {
        ++this.golemDeathTIme;
        boolean flag = this.m_9236_().m_46469_().m_46207_(GameRules.f_46135_);
        if (this.m_9236_() instanceof ServerLevel && this.golemDeathTIme > 1 && !this.m_20067_()) {
            this.m_21557_(true);
        }
        if (this.golemDeathTIme == 25) {
            Vec3 entityPosition = this.m_20182_();
            CameraShakeEntity.cameraShake(this.m_9236_(), entityPosition, 40.0f, 0.1f, 0, 20);
        }
        if (this.golemDeathTIme == 60 && this.m_9236_() instanceof ServerLevel) {
            ItemStack diamond = new ItemStack((ItemLike)ModItems.FROZEN_RUNE.get(), 1);
            ItemStack emerald = new ItemStack((ItemLike)Items.f_41852_, 1);
            this.LGspawnatlocation(diamond);
            this.m_142687_(Entity.RemovalReason.KILLED);
            this.m_146850_(GameEvent.f_223707_);
        }
    }

    public static enum Crackiness {
        NONE(1.0f),
        LOW(0.75f),
        MEDIUM(0.5f),
        HIGH(0.25f);

        private static final List<Crackiness> BY_DAMAGE;
        public final float fraction;

        private Crackiness(float pFraction) {
            this.fraction = pFraction;
        }

        public static Crackiness byFraction(float pFraction) {
            for (Crackiness crackiness : BY_DAMAGE) {
                if (!(pFraction < crackiness.fraction)) continue;
                return crackiness;
            }
            return NONE;
        }

        static {
            BY_DAMAGE = (List)Stream.of(Crackiness.values()).sorted(Comparator.comparingDouble(p_28904_ -> p_28904_.fraction)).collect(ImmutableList.toImmutableList());
        }
    }
}

