/*
 * Decompiled with CFR 0.152.
 */
package net.miauczel.legendary_monsters.item.custom;

import java.util.List;
import net.miauczel.legendary_monsters.LegendaryMonsters;
import net.miauczel.legendary_monsters.entity.ShockspawnerEntity2;
import net.miauczel.legendary_monsters.entity.custom.ModArmorItem;
import net.miauczel.legendary_monsters.item.ModItems;
import net.miauczel.legendary_monsters.item.custom.KeybindArmor;
import net.miauczel.legendary_monsters.item.custom.ModArmorMaterials;
import net.miauczel.legendary_monsters.util.MessageArmorKey;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod.EventBusSubscriber(modid="legendary_monsters", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class MossyChestplateItem
extends ArmorItem
implements KeybindArmor {
    private static final MobEffectInstance MOSSY_ARMOR_EFFECT = new MobEffectInstance(MobEffects.f_19611_, 200, 1, false, false, true);
    private int g;

    public MossyChestplateItem(ArmorMaterial pMaterial, ArmorItem.Type pType, Item.Properties pProperties) {
        super(pMaterial, pType, pProperties);
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void setup(FMLCommonSetupEvent event) {
    }

    @Override
    public void onKeyPacket(Player player, ItemStack itemStack, int Type2) {
        int standingOnY = Mth.m_14107_((double)player.m_20186_());
        if (player != null && !player.m_36335_().m_41519_((Item)this)) {
            this.spawnShockwaves(player.m_20185_(), player.m_20189_(), standingOnY, player.m_20186_(), 0.0f, 0, player);
            player.m_36335_().m_41524_((Item)ModItems.MOSSY_CHESTPLATE.get(), 240);
        }
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int i, boolean held) {
        Player living;
        super.m_6883_(stack, level, entity, i, held);
        if (entity instanceof Player && (living = (Player)entity).m_6844_(EquipmentSlot.CHEST).m_41720_() == ModItems.MOSSY_CHESTPLATE.get() && level.f_46443_ && LegendaryMonsters.PROXY.getClientSidePlayer() == entity && LegendaryMonsters.PROXY.isKeyDown(4)) {
            LegendaryMonsters.sendMSGToServer(new MessageArmorKey(EquipmentSlot.CHEST.ordinal(), living.m_19879_(), 4));
            this.onKeyPacket(living, stack, 4);
        }
    }

    private void spawnShockwaves(double x, double z, double minY, double maxY, float rotation, int delay, Player player) {
        BlockPos blockpos = new BlockPos((int)x, (int)maxY, (int)z);
        boolean flag = false;
        double d0 = 0.0;
        do {
            BlockState blockstate1;
            VoxelShape voxelshape;
            BlockPos blockpos1 = blockpos.m_7495_();
            BlockState blockstate = player.m_9236_().m_8055_(blockpos1);
            if (!blockstate.m_60783_((BlockGetter)player.m_9236_(), blockpos1, Direction.UP)) continue;
            if (!player.m_9236_().m_46859_(blockpos) && !(voxelshape = (blockstate1 = player.m_9236_().m_8055_(blockpos)).m_60812_((BlockGetter)player.m_9236_(), blockpos)).m_83281_()) {
                d0 = voxelshape.m_83297_(Direction.Axis.Y);
            }
            flag = true;
            break;
        } while ((blockpos = blockpos.m_7495_()).m_123342_() >= Mth.m_14107_((double)minY) - 1);
        if (flag) {
            Player entity1 = player;
            player.m_9236_().m_7967_((Entity)new ShockspawnerEntity2(player.m_9236_(), x, (double)blockpos.m_123342_() + d0, z, rotation, delay, (LivingEntity)entity1, false));
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        ItemStack chestplateItemStack;
        Player player;
        if (event.phase == TickEvent.Phase.START && !(player = event.player).m_9236_().m_5776_() && !(chestplateItemStack = (ItemStack)player.m_150109_().f_35975_.get(EquipmentSlot.CHEST.m_20749_())).m_41619_() && chestplateItemStack.m_41720_() instanceof MossyChestplateItem) {
            if (MossyChestplateItem.hasMossyChestplate(player)) {
                MossyChestplateItem.addMossyArmorEffect(player);
            } else {
                MossyChestplateItem.removePoisonEffect(player);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingDamage(LivingDamageEvent event) {
        Player player;
        if (event.getEntity() instanceof Player && !event.getEntity().m_9236_().m_5776_() && MossyChestplateItem.hasMossyChestplate(player = (Player)event.getEntity())) {
            MossyChestplateItem.removePoisonEffect(player);
        }
    }

    private static boolean hasMossyChestplate(Player player) {
        ItemStack chestplateStack = (ItemStack)player.m_150109_().f_35975_.get(2);
        return !chestplateStack.m_41619_() && chestplateStack.m_41720_() instanceof ModArmorItem && ((ModArmorItem)chestplateStack.m_41720_()).m_40401_() == ModArmorMaterials.MOSSY;
    }

    private static void addMossyArmorEffect(Player player) {
        boolean hasPlayerEffect = player.m_21023_(MOSSY_ARMOR_EFFECT.m_19544_());
        if (!hasPlayerEffect) {
            player.m_7292_(new MobEffectInstance(MOSSY_ARMOR_EFFECT));
        }
    }

    private static void removePoisonEffect(Player player) {
        MobEffectInstance poisonEffect = new MobEffectInstance(MobEffects.f_19614_);
        if (player.m_21023_(poisonEffect.m_19544_())) {
            player.m_21195_(poisonEffect.m_19544_());
        }
    }

    public void m_7373_(ItemStack itemstack, Level world, List<Component> list, TooltipFlag flag) {
        super.m_7373_(itemstack, world, list, flag);
        list.add((Component)Component.m_237113_((String)"\u00a76Special Ability: \u00a77 Use 'R' key to spawn poison clouds around you, "));
        list.add((Component)Component.m_237113_((String)"\u00a77that damage mobs and heal you."));
    }
}

