/*
 * Decompiled with CFR 0.152.
 */
package net.miauczel.legendary_monsters.item.custom;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;

public class WitheredScytheItem
extends Item {
    private final Multimap<Attribute, AttributeModifier> defaultModifiers;
    public static final UUID ATTACK_RANGE_MODIFIER_UUID = UUID.fromString("CB3F55D3-645C-4F38-A497-9C13A33DB5CF");
    private Float initialYRot = null;
    private Float initialXRot = null;
    private int aTime = 30;
    private int g;

    public WitheredScytheItem(Item.Properties pProperties) {
        super(pProperties);
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Tool modifier", 7.0, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Tool modifier", (double)-2.8f, AttributeModifier.Operation.ADDITION));
        this.defaultModifiers = builder.build();
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot pEquipmentSlot) {
        return pEquipmentSlot == EquipmentSlot.MAINHAND ? this.defaultModifiers : super.m_7167_(pEquipmentSlot);
    }

    public boolean m_7579_(ItemStack pStack, LivingEntity pTarget, LivingEntity pAttacker) {
        pStack.m_41622_(1, pAttacker, p_43414_ -> p_43414_.m_21166_(EquipmentSlot.MAINHAND));
        return true;
    }

    public boolean m_6813_(ItemStack pStack, Level pLevel, BlockState pState, BlockPos pPos, LivingEntity pEntityLiving) {
        if ((double)pState.m_60800_((BlockGetter)pLevel, pPos) != 0.0) {
            pStack.m_41622_(2, pEntityLiving, p_43385_ -> p_43385_.m_21166_(EquipmentSlot.MAINHAND));
        }
        return true;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        player.m_6672_(hand);
        if (!player.m_36335_().m_41519_((Item)this)) {
            this.initialYRot = Float.valueOf(player.m_146908_());
            this.initialXRot = Float.valueOf(player.m_146909_());
            this.aTime = 20;
        }
        return InteractionResultHolder.m_19096_((Object)itemstack);
    }

    public void m_7373_(ItemStack itemstack, Level world, List<Component> list, TooltipFlag flag) {
        super.m_7373_(itemstack, world, list, flag);
        list.add((Component)Component.m_237115_((String)"item.legendary_monsters.withered_scythe1"));
        list.add((Component)Component.m_237115_((String)"item.legendary_monsters.withered_scythe2"));
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment.f_44672_ == EnchantmentCategory.WEAPON || enchantment.f_44672_ == EnchantmentCategory.DIGGER || enchantment == Enchantments.f_44962_;
    }

    public void m_6883_(ItemStack pStack, Level pLevel, Entity pEntity, int pSlotId, boolean pIsSelected) {
        Player player;
        ItemStack stack;
        super.m_6883_(pStack, pLevel, pEntity, pSlotId, pIsSelected);
        if (pEntity instanceof Player && (stack = (player = (Player)pEntity).m_21205_()).m_41720_() == this) {
            this.g = this.m_8105_(this.m_7968_());
        }
    }

    public void m_5551_(ItemStack stack, Level level, LivingEntity entityLiving, int timeLeft) {
        Player player;
        if (entityLiving instanceof Player && !(player = (Player)entityLiving).m_36335_().m_41519_((Item)this)) {
            player.m_36335_().m_41524_((Item)this, 120);
        }
        this.initialYRot = null;
        this.initialXRot = null;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.TOOT_HORN;
    }

    public void m_5929_(Level pLevel, LivingEntity pLivingEntity, ItemStack pStack, int pRemainingUseDuration) {
        Player player;
        if (pLivingEntity instanceof Player) {
            player = (Player)pLivingEntity;
            if (this.aTime > 0 && this.initialYRot != null && this.initialXRot != null) {
                player.m_146922_(this.initialYRot.floatValue());
                player.m_146926_(this.initialXRot.floatValue());
            }
        }
        if (this.aTime > 0) {
            --this.aTime;
        }
        if (this.aTime <= 0 && pLivingEntity instanceof Player && !(player = (Player)pLivingEntity).m_36335_().m_41519_((Item)this)) {
            player.m_36335_().m_41524_((Item)this, 100);
        }
        System.out.println("Czas" + this.aTime);
        if (this.aTime != 0 && pLivingEntity instanceof Player) {
            player = (Player)pLivingEntity;
            int i = this.m_8105_(pStack) - pRemainingUseDuration;
            int t = Mth.m_14045_((int)i, (int)1, (int)4);
            float f7 = pLivingEntity.m_146908_();
            float f = pLivingEntity.m_146909_();
            float f1 = -Mth.m_14031_((float)(f7 * ((float)Math.PI / 180))) * Mth.m_14089_((float)(f * ((float)Math.PI / 180)));
            float f2 = -Mth.m_14031_((float)(f * ((float)Math.PI / 180)));
            float f3 = Mth.m_14089_((float)(f7 * ((float)Math.PI / 180))) * Mth.m_14089_((float)(f * ((float)Math.PI / 180)));
            float f4 = Mth.m_14116_((float)(f1 * f1 + f2 * f2 + f3 * f3));
            float f5 = 0.4f * ((float)t / 6.0f);
            pLivingEntity.m_5997_((double)(f1 *= f5 / f4), 0.0, (double)(f3 *= f5 / f4));
            if (pLivingEntity.m_20096_()) {
                float f6 = 1.1999999f;
                pLivingEntity.m_6478_(MoverType.SELF, new Vec3(0.0, 0.0, 0.0));
            }
            double dashRadius = 1.25;
            AABB areaOfEffect = pLivingEntity.m_20191_().m_82400_(dashRadius);
            List entities = pLevel.m_45976_(LivingEntity.class, areaOfEffect);
            for (LivingEntity target : entities) {
                if (target == pLivingEntity || target == null) continue;
                DamageSource damageSource = new DamageSource((Holder)player.m_9236_().m_9598_().m_175515_(Registries.f_268580_).m_246971_(DamageTypes.f_268566_), (Entity)player);
                target.m_6469_(damageSource, 7.0f);
                this.launch((LivingEntity)player, target, false);
                target.m_147207_(new MobEffectInstance(MobEffects.f_19615_, 100, 1), (Entity)player);
            }
        }
    }

    private void launch(LivingEntity pl, LivingEntity entity, boolean huge) {
        double deltaX = entity.m_20185_() - pl.m_20185_();
        double deltaZ = entity.m_20189_() - pl.m_20189_();
        double distanceSquared = Math.max(deltaX * deltaX + deltaZ * deltaZ, 1.0E-4);
        float multiplier = huge ? 1.0f : 0.5f;
        entity.m_5997_(deltaX / distanceSquared * (double)multiplier, huge ? 0.5 : 0.2, deltaZ / distanceSquared * (double)multiplier);
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        return ToolActions.DEFAULT_SWORD_ACTIONS.contains(toolAction) || ToolActions.DEFAULT_HOE_ACTIONS.contains(toolAction);
    }
}

