/*
 * Decompiled with CFR 0.152.
 */
package me.villagerunknown.platform;

import java.util.ArrayList;
import java.util.List;
import me.shedaniel.autoconfig.ConfigData;
import me.villagerunknown.platform.PlatformConfigData;
import me.villagerunknown.platform.PlatformMod;
import me.villagerunknown.platform.PlatformPayloads;
import me.villagerunknown.platform.feature.commandsFeature;
import me.villagerunknown.platform.feature.deathCoordinateNoticeFeature;
import me.villagerunknown.platform.feature.sleepNoticeFeature;
import me.villagerunknown.platform.feature.welcomeMessageFeature;
import me.villagerunknown.platform.manager.featureManager;
import net.fabricmc.api.ModInitializer;
import org.slf4j.Logger;

public class Platform
implements ModInitializer {
    public static final String PLATFORM_ID = "villagerunknown";
    public static final String PLATFORM_PREFIX = "villagerunknown-";
    public static PlatformMod<PlatformConfigData> MOD = null;
    public static String MOD_ID = null;
    public static Logger LOGGER = null;
    public static PlatformConfigData CONFIG = null;
    public static List<Runnable> LOAD = new ArrayList<Runnable>();
    public static List<Runnable> UNLOAD = new ArrayList<Runnable>();

    public void onInitialize() {
        Platform.init_platform();
    }

    public static void init_platform() {
        if (null != MOD) {
            return;
        }
        MOD = new PlatformMod<PlatformConfigData>("platform", Platform.class, PlatformConfigData.class);
        MOD_ID = MOD.getModId();
        LOGGER = MOD.getLogger();
        CONFIG = MOD.getConfig();
        Platform.init();
    }

    public static <T extends ConfigData> void init_mod(PlatformMod<T> mod) {
        if (null == MOD) {
            Platform.init_platform();
        }
        LOGGER.info("Initializing {} ({})", (Object)mod.getName(), (Object)mod.getModIdVersion());
    }

    private static void init() {
        Platform.init_mod(MOD);
        LOGGER.info("For support visit: {}", (Object)MOD.getHomepage());
        PlatformPayloads.registerPayloads();
        featureManager.addFeature("commands", commandsFeature::execute);
        featureManager.addFeature("welcomeMessage", welcomeMessageFeature::execute);
        featureManager.addFeature("sleepNotice", sleepNoticeFeature::execute);
        featureManager.addFeature("deathCoordinateNotice", deathCoordinateNoticeFeature::execute);
    }

    public static <T extends ConfigData> PlatformMod<T> register(String modId, Class<?> loggerClass, Class<T> configClass) {
        if (null == MOD) {
            Platform.init_platform();
        }
        PlatformMod<T> mod = new PlatformMod<T>(modId, loggerClass, configClass);
        mod.getLogger().info("Registering: {}", (Object)mod.getModIdVersion());
        return mod;
    }

    public static void load() {
        LOGGER.info("Loading {} operations", (Object)LOAD.size());
        if (!LOAD.isEmpty()) {
            for (Runnable runnable : LOAD) {
                runnable.run();
            }
        }
        LOGGER.info("Loading complete.");
    }

    public static void unload() {
        LOGGER.info("Unloading {} operations", (Object)UNLOAD.size());
        if (!UNLOAD.isEmpty()) {
            for (Runnable runnable : UNLOAD) {
                runnable.run();
            }
        }
        LOGGER.info("Unloading complete.");
    }

    public static void reload() {
        LOGGER.info("Reloading {} operations", (Object)(LOAD.size() + UNLOAD.size()));
        Platform.unload();
        Platform.load();
        LOGGER.info("Reloading complete.");
    }
}

