/*
 * Decompiled with CFR 0.152.
 */
package me.villagerunknown.platform.list;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import me.villagerunknown.platform.Platform;
import me.villagerunknown.platform.util.FileUtil;
import me.villagerunknown.platform.util.GsonUtil;
import me.villagerunknown.platform.util.ListUtil;

public class StringsList {
    private static String fileName;
    private static List<String> defaultList;
    private static List<String> STRINGS;

    public StringsList(List<String> strings) {
        defaultList = strings;
        this.load();
    }

    public StringsList(String fileName, List<String> defaultList) {
        StringsList.fileName = fileName;
        StringsList.defaultList = defaultList;
        this.load();
    }

    public void load() {
        if (!fileName.isEmpty()) {
            this.loadStringsFromFile(fileName, defaultList);
        } else {
            STRINGS = defaultList;
        }
    }

    private List<?> loadStringsFromFile(String fileName, List<String> defaultList) {
        Path filePath = FileUtil.getConfigPath(fileName);
        File file = filePath.toFile();
        if (file.exists()) {
            try (FileReader reader = new FileReader(file);){
                Gson gson = GsonUtil.gsonForFiles();
                STRINGS = (List)gson.fromJson((Reader)reader, new TypeToken<List<String>>(this){}.getType());
                if (STRINGS == null || STRINGS.isEmpty()) {
                    Platform.LOGGER.info(Platform.MOD_ID + " no strings found in: " + fileName);
                } else {
                    Platform.LOGGER.info(STRINGS.size() + " strings found in: " + fileName);
                }
            }
            catch (Exception e) {
                Platform.LOGGER.error(Platform.MOD_ID + " Error: " + e.getMessage(), (Throwable)e);
            }
        } else {
            Platform.LOGGER.info(Platform.MOD_ID + " failed to load file: " + fileName);
            STRINGS = defaultList;
            JsonArray jsonArray = new JsonArray();
            for (String str : defaultList) {
                jsonArray.add(str);
            }
            Gson gson = new Gson();
            String json = gson.toJson((JsonElement)jsonArray);
            try {
                Files.write(filePath, json.getBytes(), new OpenOption[0]);
                Platform.LOGGER.info(Platform.MOD_ID + " created file: " + fileName);
            }
            catch (IOException e) {
                Platform.LOGGER.error(Platform.MOD_ID + " Error: " + e.getMessage(), (Throwable)e);
            }
        }
        return STRINGS;
    }

    public String getRandomString() {
        return ListUtil.chooseRandomFromList(STRINGS);
    }
}

