/*
 * Decompiled with CFR 0.152.
 */
package me.villagerunknown.platform.timer;

import java.util.HashMap;
import java.util.Map;

public class TickTimer {
    private boolean ALARM_ACTIVATED = false;
    private int ALARM_INTERVAL_TICKS = 72000;
    private int tickCounter = 0;
    private Map<String, Object> dataset = new HashMap<String, Object>();

    public TickTimer(int minutes, int seconds) {
        minutes = minutes * 60 * 20;
        this.ALARM_INTERVAL_TICKS = minutes + (seconds *= 20);
    }

    public TickTimer(int minutes) {
        this.ALARM_INTERVAL_TICKS = minutes * 60 * 20;
    }

    public void tick() {
        ++this.tickCounter;
        if (this.tickCounter >= this.ALARM_INTERVAL_TICKS) {
            this.tickCounter = 0;
            this.ALARM_ACTIVATED = true;
        }
    }

    public boolean isAlarmActivated() {
        return this.ALARM_ACTIVATED;
    }

    public void resetAlarmActivation() {
        this.ALARM_ACTIVATED = false;
    }

    public int getDuration() {
        return this.ALARM_INTERVAL_TICKS;
    }

    public int getTicksUntilAlarm() {
        return this.ALARM_INTERVAL_TICKS - this.tickCounter;
    }

    public int getMinutesUntilAlarm() {
        return this.getTicksUntilAlarm() / 1200 + 1;
    }

    public boolean hasData() {
        return !this.dataset.isEmpty();
    }

    public void putData(String key, Object data) {
        this.dataset.put(key, data);
    }

    public Object getData(String key) {
        return this.dataset.get(key);
    }
}

