/*
 * Decompiled with CFR 0.152.
 */
package me.villagerunknown.platform.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import me.villagerunknown.platform.util.BoxUtil;
import me.villagerunknown.platform.util.ListUtil;
import net.minecraft.class_1297;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.server.MinecraftServer;

public class PositionUtil {
    private static final Random rand = new Random();

    public static class_2338 findSafeSpawnPosition(class_1937 world, class_2338 startPos, int range) {
        ArrayList<class_2338> safePositions = new ArrayList<class_2338>();
        for (int dx = -range; dx <= range; ++dx) {
            for (int dy = -range; dy <= range; ++dy) {
                for (int dz = -range; dz <= range; ++dz) {
                    class_2338 safeBlockPos;
                    class_2338 checkPos = startPos.method_10069(dx, dy, dz);
                    if (!PositionUtil.isSafeSpawnLocation(world, checkPos) || safePositions.contains(safeBlockPos = PositionUtil.findSafeBlockBelow(world, checkPos, world.method_31607()))) continue;
                    safePositions.add(safeBlockPos);
                }
            }
        }
        if (!safePositions.isEmpty()) {
            return (class_2338)safePositions.get(rand.nextInt(safePositions.size()));
        }
        return startPos;
    }

    private static boolean isSafeSpawnLocation(class_1937 world, class_2338 pos) {
        return PositionUtil.isClearSpace(world, pos) && !PositionUtil.isDangerousPosition(world, pos);
    }

    private static boolean isClearSpace(class_1937 world, class_2338 pos) {
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dy = 0; dy <= 1; ++dy) {
                for (int dz = -1; dz <= 1; ++dz) {
                    class_2338 checkPos = pos.method_10069(dx, dy, dz);
                    if (world.method_8320(checkPos).method_26215()) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private static boolean isDangerousPosition(class_1937 world, class_2338 pos) {
        return world.method_8320(pos).method_27852(class_2246.field_10164) || world.method_8320(pos).method_27852(class_2246.field_10036);
    }

    public static class_2338 findSolidBlockBelow(class_1937 world, class_2338 startPos, int bottomYLimit) {
        class_2338 currentPos = startPos.method_10074();
        for (int y = startPos.method_10264(); y > bottomYLimit; --y) {
            if (PositionUtil.hasSolidBlockBelow(world, currentPos)) {
                return currentPos.method_10084();
            }
            currentPos = currentPos.method_10074();
        }
        return startPos;
    }

    public static boolean hasSolidBlockBelow(class_1937 world, class_2338 pos) {
        return world.method_8320(pos.method_10074()).method_26212((class_1922)world, pos.method_10074());
    }

    public static class_2338 findSafeBlockBelow(class_1937 world, class_2338 startPos, int bottomYLimit) {
        class_2338 currentPos = startPos.method_10074();
        for (int y = startPos.method_10264(); y > bottomYLimit; --y) {
            if (PositionUtil.hasSafeBlockBelow(world, currentPos)) {
                return currentPos.method_10084();
            }
            currentPos = currentPos.method_10074();
        }
        return startPos;
    }

    public static boolean hasSafeBlockBelow(class_1937 world, class_2338 pos) {
        return (PositionUtil.hasSolidBlockBelow(world, pos) || !world.method_8320(pos.method_10074()).method_26215()) && world.method_8320(pos.method_10074()).method_26204() != class_2246.field_10164;
    }

    public static class_2338 findNearestBlock(class_1297 entity, class_2248 block, int radius) {
        class_2338 entityPos = entity.method_24515();
        MinecraftServer server = entity.method_5682();
        if (null == server) {
            return entity.method_24515();
        }
        class_3218 world = server.method_3847(entity.method_37908().method_27983());
        if (null == world) {
            return entity.method_24515();
        }
        class_2338 closestBlockPos = null;
        double closestDistance = Double.MAX_VALUE;
        for (int x = entityPos.method_10263() - radius; x <= entityPos.method_10263() + radius; ++x) {
            for (int z = entityPos.method_10260() - radius; z <= entityPos.method_10260() + radius; ++z) {
                for (int y = entityPos.method_10264() - 2; y <= entityPos.method_10264() + 2; ++y) {
                    double distance;
                    class_2338 pos = new class_2338(x, y, z);
                    if (world.method_8320(pos).method_26204() != block || !((distance = entityPos.method_10262((class_2382)pos)) < closestDistance)) continue;
                    closestDistance = distance;
                    closestBlockPos = pos;
                }
            }
        }
        return closestBlockPos;
    }

    public static class_2338 findNearestBed(class_1297 entity, int radius) {
        class_2338 entityPos = entity.method_24515();
        MinecraftServer server = entity.method_5682();
        if (null == server) {
            return entity.method_24515();
        }
        class_3218 world = server.method_3847(entity.method_37908().method_27983());
        if (null == world) {
            return entity.method_24515();
        }
        class_2338 closestBedPos = null;
        double closestDistance = Double.MAX_VALUE;
        for (int x = entityPos.method_10263() - radius; x <= entityPos.method_10263() + radius; ++x) {
            for (int z = entityPos.method_10260() - radius; z <= entityPos.method_10260() + radius; ++z) {
                for (int y = entityPos.method_10264() - 2; y <= entityPos.method_10264() + 2; ++y) {
                    double distance;
                    class_2338 pos = new class_2338(x, y, z);
                    if (!ListUtil.BEDS.contains(world.method_8320(pos).method_26204()) || !((distance = entityPos.method_10262((class_2382)pos)) < closestDistance)) continue;
                    closestDistance = distance;
                    closestBedPos = pos;
                }
            }
        }
        return closestBedPos;
    }

    public static List<class_2248> getNearbyBlocks(class_1937 world, class_2338 pos, int proximity) {
        class_238 nearbySearchArea = BoxUtil.createBox(pos, proximity);
        ArrayList<class_2248> nearbyBlocks = new ArrayList<class_2248>();
        int x = (int)nearbySearchArea.field_1323;
        while ((double)x <= nearbySearchArea.field_1320) {
            int y = (int)nearbySearchArea.field_1322;
            while ((double)y <= nearbySearchArea.field_1325) {
                int z = (int)nearbySearchArea.field_1321;
                while ((double)z <= nearbySearchArea.field_1324) {
                    class_2338 blockPos = new class_2338(x, y, z);
                    class_2680 state = world.method_8320(blockPos);
                    nearbyBlocks.add(state.method_26204());
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return nearbyBlocks;
    }

    public static boolean isNearFlameSource(List<class_2248> nearbyBlocks) {
        for (class_2248 nearbyBlock : nearbyBlocks) {
            if (!ListUtil.FLAME_SOURCE_BLOCKS.contains(nearbyBlock)) continue;
            return true;
        }
        return false;
    }
}

