/*
 * Decompiled with CFR 0.152.
 */
package me.villagerunknown.graveyardsandghosts.block.entity;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import me.villagerunknown.graveyardsandghosts.Graveyardsandghosts;
import me.villagerunknown.graveyardsandghosts.GraveyardsandghostsPersistentData;
import me.villagerunknown.graveyardsandghosts.GraveyardsandghostsPersistentPlayerData;
import me.villagerunknown.graveyardsandghosts.feature.ghostRespawnFeature;
import me.villagerunknown.graveyardsandghosts.feature.graveyardBlocksFeature;
import me.villagerunknown.platform.timer.TickTimer;
import me.villagerunknown.platform.util.GsonUtil;
import me.villagerunknown.platform.util.MathUtil;
import me.villagerunknown.platform.util.MessageUtil;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2754;
import net.minecraft.class_2756;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.server.MinecraftServer;

public class ResurrectionBlockEntity
extends class_2586 {
    private static int blockTimerFrequencyInSeconds = 3;
    private static int blockActivationDistance = 64;
    public static TickTimer resurrectionBlockTimer = new TickTimer(0, blockTimerFrequencyInSeconds);
    public static final class_2754<class_2756> HALF = class_2741.field_12533;
    private static final Gson gson = GsonUtil.gsonWithAdapters();

    public ResurrectionBlockEntity(class_2338 pos, class_2680 state) {
        super(graveyardBlocksFeature.BLOCK_ENTITY_TYPES.get("resurrection_block"), pos, state);
    }

    public ResurrectionBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, ResurrectionBlockEntity blockEntity) {
        if (null == world.method_8503() || world.method_8608()) {
            return;
        }
        if (state.method_11654(HALF) == class_2756.field_12609) {
            ResurrectionBlockEntity.tickUpper(world, pos, state, blockEntity);
        } else {
            ResurrectionBlockEntity.tickLower(world, pos, state, blockEntity);
        }
    }

    private static void tickUpper(class_1937 world, class_2338 pos, class_2680 state, ResurrectionBlockEntity blockEntity) {
        MinecraftServer minecraftServer = world.method_8503();
        class_3218 serverWorld = minecraftServer.method_3847(world.method_27983());
        resurrectionBlockTimer.tick();
        if (resurrectionBlockTimer.isAlarmActivated()) {
            if (Graveyardsandghosts.CONFIG.enableSounds && Graveyardsandghosts.CONFIG.enableGraveyardBlockSounds) {
                assert (serverWorld != null);
                if (MathUtil.hasChance((float)0.001f)) {
                    world.method_8396(null, pos, (class_3414)class_3417.field_22457.comp_349(), class_3419.field_15256, Graveyardsandghosts.CONFIG.soundVolume, 1.0f);
                }
                world.method_8396(null, pos, (class_3414)class_3417.field_22458.comp_349(), class_3419.field_15256, Graveyardsandghosts.CONFIG.soundVolume, 1.0f);
            }
            resurrectionBlockTimer.resetAlarmActivation();
        }
        ghostRespawnFeature.resurrectionCorpseTimers.forEach((playerUUID, corpseTimer) -> {
            class_3222 player = minecraftServer.method_3760().method_14602(playerUUID);
            if (corpseTimer.isAlarmActivated() && pos.method_19769((class_2374)player.method_19538(), (double)blockActivationDistance) && Graveyardsandghosts.CONFIG.enableParticles && Graveyardsandghosts.CONFIG.enableGraveyardBlockParticles) {
                assert (serverWorld != null);
                serverWorld.method_14166(player, (class_2394)class_2398.field_11201, true, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 1.5, (double)pos.method_10260() + 0.5, 3, 0.25, 0.25, 0.25, (double)0.005f);
            }
        });
    }

    private static void tickLower(class_1937 world, class_2338 pos, class_2680 state, ResurrectionBlockEntity blockEntity) {
        if (world.method_8608() || world.method_27983().toString().contains("null")) {
            return;
        }
        int radius = Graveyardsandghosts.CONFIG.graveyardDiscoveryRadius;
        List playersWithinRange = world.method_18467(class_3222.class, new class_238(new class_243((double)(pos.method_10263() - radius), (double)(pos.method_10264() - radius), (double)(pos.method_10260() - radius)), new class_243((double)(pos.method_10263() + radius), (double)(pos.method_10264() + radius), (double)(pos.method_10260() + radius))));
        if (null != playersWithinRange) {
            for (class_3222 serverPlayerEntity : playersWithinRange) {
                GraveyardsandghostsPersistentPlayerData playerData = GraveyardsandghostsPersistentData.getPlayerState((class_1309)serverPlayerEntity);
                HashMap<String, Set<class_2338>> playerRespawnPositions = (HashMap<String, Set<class_2338>>)gson.fromJson(playerData.respawnPositions, new TypeToken<Map<String, Set<class_2338>>>(){}.getType());
                Set<class_2338> dimensionPositions = Set.of();
                if (null == playerRespawnPositions) {
                    playerRespawnPositions = new HashMap<String, Set<class_2338>>();
                }
                if (!playerRespawnPositions.containsKey(world.method_27983().method_29177().toString())) {
                    playerRespawnPositions.put(world.method_27983().method_29177().toString(), dimensionPositions);
                }
                if ((dimensionPositions = new HashSet((Collection)playerRespawnPositions.get(world.method_27983().method_29177().toString()))).contains(pos)) continue;
                dimensionPositions.add(pos);
                playerRespawnPositions.put(world.method_27983().method_29177().toString(), dimensionPositions);
                playerData.respawnPositions = gson.toJson(playerRespawnPositions, new TypeToken<Map<String, Set<class_2338>>>(){}.getType());
                serverPlayerEntity.method_7281(ghostRespawnFeature.DISCOVERED_GRAVEYARDS_ID);
                MessageUtil.sendChatMessage((class_3222)serverPlayerEntity, (String)("Graveyard discovered! [" + pos.method_10263() + " " + pos.method_10264() + " " + pos.method_10260() + "]"));
            }
        }
    }
}

