/*
 * Decompiled with CFR 0.152.
 */
package me.villagerunknown.graveyardsandghosts.feature;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import me.villagerunknown.graveyardsandghosts.Graveyardsandghosts;
import me.villagerunknown.graveyardsandghosts.GraveyardsandghostsPersistentData;
import me.villagerunknown.graveyardsandghosts.GraveyardsandghostsPersistentPlayerData;
import me.villagerunknown.graveyardsandghosts.feature.graveyardBlocksFeature;
import me.villagerunknown.graveyardsandghosts.feature.playerGhostFeature;
import me.villagerunknown.graveyardsandghosts.network.ConfirmResurrectionPayload;
import me.villagerunknown.graveyardsandghosts.network.DeclineResurrectionPayload;
import me.villagerunknown.platform.timer.TickTimer;
import me.villagerunknown.platform.util.EntityUtil;
import me.villagerunknown.platform.util.GsonUtil;
import me.villagerunknown.platform.util.MessageUtil;
import me.villagerunknown.platform.util.PlayerStatUtil;
import me.villagerunknown.platform.util.PositionUtil;
import me.villagerunknown.platform.util.RegistryUtil;
import net.fabricmc.fabric.api.entity.event.v1.ServerPlayerEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerEntityEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3446;
import net.minecraft.class_3468;
import net.minecraft.class_4208;
import net.minecraft.class_4969;
import net.minecraft.class_5321;
import net.minecraft.class_8710;

public class ghostRespawnFeature {
    private static final int corpseTimerFrequencyInSeconds = 3;
    public static Map<UUID, TickTimer> resurrectionCorpseTimers = new HashMap<UUID, TickTimer>();
    public static Map<UUID, TickTimer> resurrectionPromptTimers = new HashMap<UUID, TickTimer>();
    public static Map<UUID, TickTimer> resurrectionPromptDelayTimers = new HashMap<UUID, TickTimer>();
    public static Map<class_2338, class_5321<class_1937>> respawnPositions = new HashMap<class_2338, class_5321<class_1937>>();
    private static double closestRespawnDistance = Double.MAX_VALUE;
    private static class_2338 respawnPosition = null;
    private static final Gson gson = GsonUtil.gsonWithAdapters();
    public static final class_2960 CONFIRM_RESURRECTION_PACKET_ID = class_2960.method_60655((String)Graveyardsandghosts.MOD_ID, (String)"confirm_resurrection");
    public static final class_2960 DECLINE_RESURRECTION_PACKET_ID = class_2960.method_60655((String)Graveyardsandghosts.MOD_ID, (String)"decline_resurrection");
    public static final class_2960 DISCOVERED_GRAVEYARDS_ID = RegistryUtil.registerStat((String)"discovered_graveyards", (String)Graveyardsandghosts.MOD_ID, (class_3446)class_3446.field_16975);
    public static final class_2960 TOTAL_RESURRECTIONS_ID = RegistryUtil.registerStat((String)"total_resurrections", (String)Graveyardsandghosts.MOD_ID, (class_3446)class_3446.field_16975);

    public static void execute() {
        ghostRespawnFeature.init();
        ServerEntityEvents.ENTITY_UNLOAD.register((entity, serverWorld) -> {
            String dimension;
            if (entity.method_31747() && "minecraft:overworld".equals(dimension = serverWorld.method_40134().method_55840())) {
                GraveyardsandghostsPersistentPlayerData playerData = GraveyardsandghostsPersistentData.getPlayerState((class_1309)entity);
                playerData.lastOverworldPos = gson.toJson((Object)entity.method_24515(), class_2338.class);
            }
        });
        ServerPlayerEvents.ALLOW_DEATH.register((serverPlayerEntity, damageSource, v) -> {
            if (serverPlayerEntity.method_6059(playerGhostFeature.GHOST_EFFECT_REGISTRY)) {
                return false;
            }
            if (Graveyardsandghosts.CONFIG.enablePlayerGhostOnDeath) {
                GraveyardsandghostsPersistentPlayerData playerData = GraveyardsandghostsPersistentData.getPlayerState((class_1309)serverPlayerEntity);
                Map playerRespawnPositions = (Map)gson.fromJson(playerData.respawnPositions, new TypeToken<Map<String, Set<class_2338>>>(){}.getType());
                closestRespawnDistance = Double.MAX_VALUE;
                respawnPosition = null;
                if (null != playerRespawnPositions) {
                    Set dimensionPositions = playerRespawnPositions.getOrDefault(serverPlayerEntity.method_51469().method_27983().method_29177().toString(), new HashSet());
                    class_3218 dimWorld = serverPlayerEntity.method_5682().method_3847(serverPlayerEntity.method_51469().method_27983());
                    class_2338 lastPlayerPosition = serverPlayerEntity.method_24515();
                    Graveyardsandghosts.LOGGER.info("Trying to set respawn point for " + serverPlayerEntity.method_5820() + " in " + dimWorld.method_40134().method_55840() + " from " + dimensionPositions.size() + " possible points.");
                    if (dimensionPositions.isEmpty()) {
                        dimensionPositions = playerRespawnPositions.getOrDefault(serverPlayerEntity.method_5682().method_30002().method_27983().method_29177().toString(), new HashSet());
                        dimWorld = serverPlayerEntity.method_5682().method_3847(serverPlayerEntity.method_5682().method_30002().method_27983());
                        lastPlayerPosition = (class_2338)gson.fromJson(playerData.lastOverworldPos, class_2338.class);
                        Graveyardsandghosts.LOGGER.info("Trying to set respawn point for " + serverPlayerEntity.method_5820() + " in " + dimWorld.method_40134().method_55840() + " from " + dimensionPositions.size() + " possible points.");
                        if (dimensionPositions.isEmpty()) {
                            Graveyardsandghosts.LOGGER.info("No respawn points. Using default mechanics.");
                            return false;
                        }
                    }
                    for (class_2338 pos : dimensionPositions) {
                        class_2586 blockentity = dimWorld.method_8321(pos);
                        class_2680 blockstate = dimWorld.method_8320(pos);
                        if (blockentity == null && blockstate == null || blockentity != null && !blockentity.method_11017().equals(graveyardBlocksFeature.BLOCK_ENTITY_TYPES.get("resurrection_block")) && blockstate != null && blockstate.method_26204() != class_2246.field_23152 || blockstate != null && blockstate.method_26204() == class_2246.field_23152 && (Integer)blockstate.method_11654((class_2769)class_4969.field_23153) <= 0) {
                            Graveyardsandghosts.LOGGER.info("Removing respawn position that no longer exists in " + dimWorld.method_40134().method_55840() + ": " + String.valueOf(pos));
                            dimensionPositions.remove(pos);
                            playerRespawnPositions.put(dimWorld.method_27983().method_29177().toString(), dimensionPositions);
                            playerData.respawnPositions = gson.toJson((Object)playerRespawnPositions, new TypeToken<Map<String, Set<class_2338>>>(){}.getType());
                            continue;
                        }
                        double distance = pos.method_10262((class_2382)lastPlayerPosition);
                        if (!(distance < closestRespawnDistance)) continue;
                        closestRespawnDistance = distance;
                        respawnPosition = pos;
                    }
                    Graveyardsandghosts.LOGGER.info("Respawn point set at: " + String.valueOf(respawnPosition) + " in " + dimWorld.method_40134().method_55840() + "; distance: " + closestRespawnDistance);
                    if (null != respawnPosition) {
                        class_2338 safeSpawnPos = respawnPosition.method_10086(3);
                        if (!dimWorld.method_8320(safeSpawnPos).method_26215() || !dimWorld.method_8320(safeSpawnPos.method_10084()).method_26215()) {
                            safeSpawnPos = PositionUtil.findSafeSpawnPosition((class_1937)dimWorld, (class_2338)respawnPosition, (int)Graveyardsandghosts.CONFIG.resurrectionSafeRespawnSearchRadius);
                        }
                        serverPlayerEntity.method_26284(dimWorld.method_27983(), safeSpawnPos, serverPlayerEntity.method_30631(), true, false);
                    }
                }
            }
            return true;
        });
        ServerPlayerEvents.AFTER_RESPAWN.register((serverPlayerEntity, serverPlayerEntity1, b) -> {
            if (Graveyardsandghosts.CONFIG.enablePlayerGhostOnDeath && !serverPlayerEntity1.method_7337() && !serverPlayerEntity1.method_7325()) {
                MessageUtil.sendChatMessage((class_3222)serverPlayerEntity1, (String)"You respawned as a ghost!");
                MessageUtil.sendChatMessage((class_3222)serverPlayerEntity1, (String)"Go to your corpse or a graveyard to return to normal.");
                playerGhostFeature.applyGhostEffect(serverPlayerEntity1);
                GraveyardsandghostsPersistentPlayerData playerData = GraveyardsandghostsPersistentData.getPlayerState((class_1309)serverPlayerEntity1);
                playerData.lastCorpsePos = gson.toJson((Object)serverPlayerEntity.method_43122(), new TypeToken<Optional<class_4208>>(){}.getType());
                resurrectionCorpseTimers.put(serverPlayerEntity1.method_5667(), new TickTimer(0, 3));
                resurrectionPromptTimers.put(serverPlayerEntity1.method_5667(), new TickTimer(0, Graveyardsandghosts.CONFIG.resurrectionPromptFrequencyInSeconds));
            }
        });
        ServerPlayConnectionEvents.JOIN.register((serverPlayNetworkHandler, packetSender, minecraftServer) -> {
            class_3222 player = serverPlayNetworkHandler.field_14140;
            GraveyardsandghostsPersistentPlayerData playerData = GraveyardsandghostsPersistentData.getPlayerState((class_1309)player);
            Map playerRespawnPositions = (Map)gson.fromJson(playerData.respawnPositions, new TypeToken<Map<String, Set<class_2338>>>(){}.getType());
            class_2338 lastOverworldPos = (class_2338)gson.fromJson(playerData.lastOverworldPos, class_2338.class);
            if (null == playerRespawnPositions) {
                Graveyardsandghosts.LOGGER.info(player.method_5820() + " has discovered 0 graveyards.");
            } else {
                AtomicInteger totalGraveyards = new AtomicInteger();
                playerRespawnPositions.forEach((dimension, graveyards) -> totalGraveyards.addAndGet(graveyards.size()));
                Graveyardsandghosts.LOGGER.info(player.method_5820() + " has discovered " + String.valueOf(totalGraveyards) + " graveyards.");
            }
            if (null == lastOverworldPos) {
                Graveyardsandghosts.LOGGER.info(player.method_5820() + " has not used a portal to leave the Overworld");
            } else {
                Graveyardsandghosts.LOGGER.info(player.method_5820() + " last took a portal out of the Overworld at " + String.valueOf(lastOverworldPos));
            }
            if (Graveyardsandghosts.CONFIG.playersStartWorldsAsGhosts && !player.method_7337() && !player.method_7325() && PlayerStatUtil.getStatFromIdentifier((class_3222)player, (class_2960)class_3468.field_33558) <= 0 && !player.method_6059(playerGhostFeature.GHOST_EFFECT_REGISTRY)) {
                MessageUtil.sendChatMessage((class_3222)player, (String)"You're a ghost!");
                MessageUtil.sendChatMessage((class_3222)player, (String)"Go to a graveyard to start your adventure.");
                playerGhostFeature.applyGhostEffect(player);
            }
            if (player.method_6059(playerGhostFeature.GHOST_EFFECT_REGISTRY) && !resurrectionCorpseTimers.containsKey(player.method_5667())) {
                MessageUtil.sendChatMessage((class_3222)player, (String)"You're a ghost!");
                MessageUtil.sendChatMessage((class_3222)player, (String)"Resurrect at a grave or your corpse.");
                resurrectionCorpseTimers.put(player.method_5667(), new TickTimer(0, 3));
                resurrectionPromptTimers.put(player.method_5667(), new TickTimer(0, Graveyardsandghosts.CONFIG.resurrectionPromptFrequencyInSeconds));
                resurrectionPromptDelayTimers.put(player.method_5667(), new TickTimer(0, Graveyardsandghosts.CONFIG.resurrectionPromptFrequencyInSeconds));
            }
        });
        ServerPlayConnectionEvents.DISCONNECT.register((serverPlayNetworkHandler, minecraftServer) -> {
            resurrectionCorpseTimers.remove(serverPlayNetworkHandler.field_14140.method_5667());
            resurrectionPromptTimers.remove(serverPlayNetworkHandler.field_14140.method_5667());
            resurrectionPromptDelayTimers.remove(serverPlayNetworkHandler.field_14140.method_5667());
        });
        ServerTickEvents.END_WORLD_TICK.register(serverWorld -> {
            if (serverWorld.method_8608()) {
                return;
            }
            for (class_3222 player : serverWorld.method_8503().method_3760().method_14571()) {
                if (!player.method_6059(playerGhostFeature.GHOST_EFFECT_REGISTRY) || !player.method_5805()) continue;
                TickTimer corpseTimer = resurrectionCorpseTimers.get(player.method_5667());
                TickTimer promptTimer = resurrectionPromptTimers.get(player.method_5667());
                if (null == corpseTimer) {
                    corpseTimer = new TickTimer(0, 3);
                } else {
                    corpseTimer.tick();
                }
                if (!resurrectionPromptDelayTimers.containsKey(player.method_5667())) {
                    if (null == promptTimer) {
                        promptTimer = new TickTimer(0, Graveyardsandghosts.CONFIG.resurrectionPromptFrequencyInSeconds);
                    } else {
                        promptTimer.tick();
                    }
                } else {
                    TickTimer promptDelayTimer = resurrectionPromptDelayTimers.get(player.method_5667());
                    promptDelayTimer.tick();
                    if (promptDelayTimer.isAlarmActivated()) {
                        resurrectionPromptDelayTimers.remove(player.method_5667());
                    }
                }
                GraveyardsandghostsPersistentPlayerData playerData = GraveyardsandghostsPersistentData.getPlayerState((class_1309)player);
                Optional lastDeathPos = (Optional)gson.fromJson(playerData.lastCorpsePos, new TypeToken<Optional<class_4208>>(){}.getType());
                if (null == lastDeathPos || lastDeathPos.isEmpty()) {
                    lastDeathPos = player.method_43122();
                }
                if (null == lastDeathPos || !lastDeathPos.isPresent() || !Objects.equals(((class_4208)lastDeathPos.get()).comp_2207().toString(), serverWorld.method_27983().toString())) continue;
                class_2338 safeSpawnPos = ((class_4208)lastDeathPos.get()).comp_2208();
                if (!PositionUtil.hasSafeBlockBelow((class_1937)serverWorld, (class_2338)((class_4208)lastDeathPos.get()).comp_2208())) {
                    class_3218 lastDeathDimension = serverWorld.method_8503().method_3847(((class_4208)lastDeathPos.get()).comp_2207());
                    if (null == lastDeathDimension) {
                        lastDeathDimension = serverWorld;
                    }
                    if (null != lastDeathDimension && !PositionUtil.hasSafeBlockBelow((class_1937)serverWorld, (class_2338)(safeSpawnPos = PositionUtil.findSafeBlockBelow((class_1937)lastDeathDimension, (class_2338)((class_4208)lastDeathPos.get()).comp_2208(), (int)lastDeathDimension.method_31607())))) {
                        safeSpawnPos = PositionUtil.findSafeSpawnPosition((class_1937)lastDeathDimension, (class_2338)((class_4208)lastDeathPos.get()).comp_2208(), (int)Graveyardsandghosts.CONFIG.resurrectionSafeRespawnSearchRadius);
                    }
                }
                if (player.method_5649((double)safeSpawnPos.method_10263(), (double)safeSpawnPos.method_10264(), (double)safeSpawnPos.method_10260()) < (double)Graveyardsandghosts.CONFIG.resurrectionPromptRangeInBlocks && null != promptTimer && promptTimer.isAlarmActivated()) {
                    if (Graveyardsandghosts.CONFIG.resurrectionRequiresSolidBlockBelow && Graveyardsandghosts.CONFIG.preventGhostCollisions) {
                        if (PositionUtil.hasSafeBlockBelow((class_1937)serverWorld, (class_2338)player.method_24515())) {
                            ghostRespawnFeature.promptPlayerResurrection(player);
                        } else {
                            MessageUtil.showActionBarMessage((class_3222)player, (String)"Stand on a solid block to resurrect.");
                        }
                    } else {
                        ghostRespawnFeature.promptPlayerResurrection(player);
                    }
                    promptTimer.resetAlarmActivation();
                }
                if (!corpseTimer.isAlarmActivated()) continue;
                if (Graveyardsandghosts.CONFIG.enableParticles) {
                    serverWorld.method_14166(player, (class_2394)class_2398.field_23114, true, (double)safeSpawnPos.method_10263() + 0.5, (double)safeSpawnPos.method_10264() + 1.5, (double)safeSpawnPos.method_10260() + 0.5, 1, 0.25, 0.25, 0.25, (double)0.005f);
                    serverWorld.method_14166(player, (class_2394)class_2398.field_11201, true, (double)safeSpawnPos.method_10263() + 0.5, (double)safeSpawnPos.method_10264() + 2.5, (double)safeSpawnPos.method_10260() + 0.5, 3, 0.25, 0.25, 0.25, 1.0);
                }
                corpseTimer.resetAlarmActivation();
            }
        });
        UseBlockCallback.EVENT.register((playerEntity, world, hand, blockHitResult) -> {
            if (playerEntity.method_7325() || world.method_8608()) {
                return class_1269.field_5811;
            }
            if (playerEntity.method_6059(playerGhostFeature.GHOST_EFFECT_REGISTRY)) {
                class_3222 serverPlayerEntity;
                class_2248 block = world.method_8320(blockHitResult.method_17777()).method_26204();
                class_2586 blockEntity = world.method_8321(blockHitResult.method_17777());
                if ((null != blockEntity && blockEntity.method_11017().equals(graveyardBlocksFeature.BLOCK_ENTITY_TYPES.get("resurrection_block")) || block.equals(class_2246.field_23152)) && null != (serverPlayerEntity = world.method_8503().method_3760().method_14602(playerEntity.method_5667()))) {
                    if (Graveyardsandghosts.CONFIG.resurrectionRequiresSolidBlockBelow && Graveyardsandghosts.CONFIG.preventGhostCollisions) {
                        if (PositionUtil.hasSafeBlockBelow((class_1937)world, (class_2338)serverPlayerEntity.method_24515())) {
                            ghostRespawnFeature.promptPlayerResurrection(serverPlayerEntity);
                        } else {
                            MessageUtil.showActionBarMessage((class_3222)serverPlayerEntity, (String)"Stand on a solid block to resurrect.");
                        }
                    } else {
                        ghostRespawnFeature.promptPlayerResurrection(serverPlayerEntity);
                    }
                    return class_1269.field_5814;
                }
            }
            return class_1269.field_5811;
        });
    }

    private static void init() {
        PayloadTypeRegistry.playS2C().register(ConfirmResurrectionPayload.ID, ConfirmResurrectionPayload.CODEC);
        PayloadTypeRegistry.playC2S().register(ConfirmResurrectionPayload.ID, ConfirmResurrectionPayload.CODEC);
        PayloadTypeRegistry.playC2S().register(DeclineResurrectionPayload.ID, DeclineResurrectionPayload.CODEC);
        ServerPlayNetworking.registerGlobalReceiver(ConfirmResurrectionPayload.ID, (payload, context) -> context.server().execute(() -> ghostRespawnFeature.resurrectPlayer(context.player())));
        ServerPlayNetworking.registerGlobalReceiver(DeclineResurrectionPayload.ID, (payload, context) -> context.server().execute(() -> resurrectionPromptDelayTimers.put(context.player().method_5667(), new TickTimer(0, Graveyardsandghosts.CONFIG.resurrectionPromptFrequencyInSeconds))));
    }

    public static void resurrectPlayer(class_3222 player) {
        if (Graveyardsandghosts.CONFIG.enableSounds) {
            EntityUtil.playSound((class_1297)player, (class_3414)((class_3414)class_3417.field_14725.comp_349()), (class_3419)class_3419.field_15256, (float)Graveyardsandghosts.CONFIG.soundVolume, (float)1.0f, (boolean)true);
            EntityUtil.playSound((class_1297)player, (class_3414)((class_3414)class_3417.field_22459.comp_349()), (class_3419)class_3419.field_15256, (float)Graveyardsandghosts.CONFIG.soundVolume, (float)1.0f, (boolean)true);
        }
        if (Graveyardsandghosts.CONFIG.enableParticles) {
            if (Graveyardsandghosts.CONFIG.enableFlashParticles) {
                EntityUtil.spawnParticles((class_1297)player, (float)1.0f, (class_2394)class_2398.field_17909, (int)1, (double)0.0, (double)0.0, (double)0.0, (double)1.0);
            }
            EntityUtil.spawnParticles((class_1297)player, (float)1.0f, (class_2394)class_2398.field_11220, (int)10, (double)0.25, (double)0.25, (double)0.25, (double)0.005f);
            EntityUtil.spawnParticles((class_1297)player, (float)1.0f, (class_2394)class_2398.field_23114, (int)1, (double)0.25, (double)0.25, (double)0.25, (double)0.005f);
        }
        player.method_7281(TOTAL_RESURRECTIONS_ID);
        playerGhostFeature.clearGhostEffect(player);
        playerGhostFeature.applyHumanAbilities((class_1309)player);
        resurrectionCorpseTimers.remove(player.method_5667());
        resurrectionPromptTimers.remove(player.method_5667());
    }

    public static void promptPlayerResurrection(class_3222 serverPlayerEntity) {
        ServerPlayNetworking.send((class_3222)serverPlayerEntity, (class_8710)new ConfirmResurrectionPayload());
    }
}

