/*
 * Decompiled with CFR 0.152.
 */
package me.villagerunknown.graveyardsandghosts.feature;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.util.List;
import java.util.Optional;
import me.villagerunknown.graveyardsandghosts.Graveyardsandghosts;
import me.villagerunknown.graveyardsandghosts.GraveyardsandghostsPersistentData;
import me.villagerunknown.graveyardsandghosts.GraveyardsandghostsPersistentPlayerData;
import me.villagerunknown.graveyardsandghosts.feature.graveyardBlocksFeature;
import me.villagerunknown.graveyardsandghosts.statuseffect.GhostEffect;
import me.villagerunknown.platform.timer.TickTimer;
import me.villagerunknown.platform.util.EntityUtil;
import me.villagerunknown.platform.util.GsonUtil;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.player.AttackBlockCallback;
import net.fabricmc.fabric.api.event.player.AttackEntityCallback;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.fabric.api.event.player.UseEntityCallback;
import net.fabricmc.fabric.api.event.player.UseItemCallback;
import net.fabricmc.fabric.api.networking.v1.EntityTrackingEvents;
import net.fabricmc.fabric.api.registry.FabricBrewingRecipeRegistryBuilder;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1656;
import net.minecraft.class_1702;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1842;
import net.minecraft.class_1847;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_4208;
import net.minecraft.class_6880;
import net.minecraft.class_7923;

public class playerGhostFeature {
    public static List<class_2248> allowedGhostAttackBlocks = List.of(class_2246.field_10336, class_2246.field_10099, class_2246.field_22092, class_2246.field_22093);
    public static List<class_2248> allowedGhostInteractionBlocks = List.of(class_2246.field_23152, class_2246.field_10232, class_2246.field_10403, class_2246.field_40291, class_2246.field_10352, class_2246.field_42748, class_2246.field_47040, class_2246.field_22102, class_2246.field_47041, class_2246.field_9973, class_2246.field_10627, class_2246.field_37566, class_2246.field_10149, class_2246.field_47042, class_2246.field_10521, class_2246.field_47044, class_2246.field_47045, class_2246.field_47046, class_2246.field_47043, class_2246.field_10608, class_2246.field_40285, class_2246.field_10486, class_2246.field_42740, class_2246.field_47048, class_2246.field_10608, class_2246.field_22094, class_2246.field_10246, class_2246.field_47049, class_2246.field_10453, class_2246.field_10017, class_2246.field_37555, class_2246.field_10137, class_2246.field_47050, class_2246.field_10323, class_2246.field_22095, class_2246.field_47052, class_2246.field_47053, class_2246.field_47062, class_2246.field_47063, class_2246.field_47051, class_2246.field_10457, class_2246.field_40289, class_2246.field_10513, class_2246.field_42745, class_2246.field_22096, class_2246.field_10196, class_2246.field_10041, class_2246.field_37563, class_2246.field_10188, class_2246.field_10291, class_2246.field_22097, class_2246.field_10278, class_2246.field_40286, class_2246.field_10417, class_2246.field_42743, class_2246.field_22100, class_2246.field_10493, class_2246.field_10553, class_2246.field_37559, class_2246.field_10057, class_2246.field_23864, class_2246.field_10066, class_2246.field_10494, class_2246.field_22101, class_2246.field_27099, class_2246.field_27140, class_2246.field_27113, class_2246.field_27111, class_2246.field_27101, class_2246.field_27109, class_2246.field_27110, class_2246.field_27106, class_2246.field_27112, class_2246.field_27103, class_2246.field_27108, class_2246.field_27107, class_2246.field_27141, class_2246.field_27105, class_2246.field_27102, class_2246.field_27104, class_2246.field_27100, class_2246.field_10363, class_2246.field_10179, class_2246.field_16330, class_2246.field_16332, class_2246.field_40276);
    public static List<class_1299> allowedGhostInteractionEntities = List.of(class_1299.field_6097, class_1299.field_6139, class_1299.field_6075, class_1299.field_6048, class_1299.field_6067, class_1299.field_6057, class_1299.field_6074, class_1299.field_17714, class_1299.field_6093, class_1299.field_23214, class_1299.field_40116, class_1299.field_6096, class_1299.field_6121);
    public static List<class_1792> allowedGhostUseItems = List.of(class_1802.field_8634, class_1802.field_8378);
    public static List<class_1299> allowedGhostAttackEntities = List.of(class_1299.field_6097);
    public static List<class_1792> allowedGhostPickupItems = List.of(class_1802.field_8634);
    public static final class_1291 GHOST_EFFECT = new GhostEffect();
    public static class_6880<class_1291> GHOST_EFFECT_REGISTRY;
    public static class_1842 GHOST_POTION;
    public static class_6880<class_1842> GHOST_POTION_REGISTRY;
    private static final Gson gson;
    private static TickTimer soundLoopTimer;
    private static TickTimer soundAdditionsTimer;

    public static void execute() {
        playerGhostFeature.init();
        playerGhostFeature.tickGhostEffect();
        playerGhostFeature.preventPlayerInteractions();
    }

    private static void init() {
        playerGhostFeature.registerStatusEffects();
        playerGhostFeature.registerPotions();
    }

    private static void registerStatusEffects() {
        playerGhostFeature.registerGhostStatusEffect();
    }

    private static void registerGhostStatusEffect() {
        class_2960 ghostEffectId = class_2960.method_60655((String)Graveyardsandghosts.MOD_ID, (String)"ghost");
        class_2378.method_10230((class_2378)class_7923.field_41174, (class_2960)ghostEffectId, (Object)GHOST_EFFECT);
        GHOST_EFFECT_REGISTRY = class_7923.field_41174.method_47983((Object)GHOST_EFFECT);
    }

    private static void registerPotions() {
        playerGhostFeature.registerGhostPotion();
    }

    private static void registerGhostPotion() {
        class_1842 potion = new class_1842(new class_1293[]{new class_1293(class_7923.field_41174.method_47983((Object)GHOST_EFFECT), -1, 0, false, false, true)});
        GHOST_POTION = (class_1842)class_2378.method_10230((class_2378)class_7923.field_41179, (class_2960)class_2960.method_60655((String)Graveyardsandghosts.MOD_ID, (String)"ghost"), (Object)potion);
        GHOST_POTION_REGISTRY = class_7923.field_41179.method_47983((Object)GHOST_POTION);
        FabricBrewingRecipeRegistryBuilder.BUILD.register(builder -> builder.method_59705(class_1847.field_8999, class_1802.field_8288, GHOST_POTION_REGISTRY));
    }

    public static void applyGhostEffect(class_3222 serverPlayerEntity) {
        if (serverPlayerEntity.method_37908().method_8608()) {
            return;
        }
        EntityUtil.addStatusEffect((class_1309)serverPlayerEntity, GHOST_EFFECT_REGISTRY, (Integer)-1, (Integer)0, (Boolean)false, (Boolean)false, (Boolean)true);
    }

    public static void clearGhostEffect(class_3222 serverPlayerEntity) {
        if (serverPlayerEntity.method_37908().method_8608()) {
            return;
        }
        EntityUtil.removeStatusEffect((class_1309)serverPlayerEntity, GHOST_EFFECT_REGISTRY);
        serverPlayerEntity.method_6125(0.0f);
    }

    public static void applyGhostAbilities(class_1309 entity, int amplifier) {
        if (entity.method_37908().method_8608()) {
            return;
        }
        class_1656 abilities = ((class_3222)entity).method_31549();
        abilities.field_7478 = true;
        abilities.field_7479 = true;
        ((class_3222)entity).method_7355();
        class_1702 hungerManager = ((class_3222)entity).method_7344();
        hungerManager.method_35218(0.0f);
        if (hungerManager.method_7587()) {
            hungerManager.method_7585(1, 1.0f);
        }
        entity.method_6033(entity.method_6063());
        entity.method_33572(false);
        entity.method_5648(true);
        entity.method_5684(true);
    }

    public static void applyHumanAbilities(class_1309 entity) {
        if (entity.method_37908().method_8608()) {
            return;
        }
        class_1656 abilities = ((class_3222)entity).method_31549();
        abilities.field_7478 = false;
        abilities.field_7479 = false;
        ((class_3222)entity).method_7355();
        if (!entity.method_6059(class_1294.field_5905)) {
            entity.method_5648(false);
        }
        entity.method_6033(entity.method_6063());
        entity.method_5855(entity.method_5748());
        entity.method_33572(false);
        entity.method_5684(false);
    }

    private static void tickGhostEffect() {
        ServerTickEvents.END_WORLD_TICK.register(serverWorld -> {
            if (serverWorld.method_8608()) {
                return;
            }
            soundLoopTimer.tick();
            soundAdditionsTimer.tick();
            for (class_3222 player : serverWorld.method_18456()) {
                if (!player.method_6059(GHOST_EFFECT_REGISTRY)) continue;
                GraveyardsandghostsPersistentPlayerData playerData = GraveyardsandghostsPersistentData.getPlayerState((class_1309)player);
                Optional lastDeathPos = (Optional)gson.fromJson(playerData.lastCorpsePos, new TypeToken<Optional<class_4208>>(){}.getType());
                if (soundLoopTimer.isAlarmActivated()) {
                    player.method_17356((class_3414)class_3417.field_22458.comp_349(), class_3419.field_15256, Graveyardsandghosts.CONFIG.soundVolume, 1.0f);
                    soundLoopTimer.resetAlarmActivation();
                }
                if (soundAdditionsTimer.isAlarmActivated()) {
                    player.method_17356((class_3414)class_3417.field_22457.comp_349(), class_3419.field_15256, Graveyardsandghosts.CONFIG.soundVolume, 1.0f);
                    soundAdditionsTimer.resetAlarmActivation();
                }
                if (null == lastDeathPos || !lastDeathPos.isPresent()) {
                    playerData.lastCorpsePos = gson.toJson((Object)player.method_43122(), new TypeToken<Optional<class_4208>>(){}.getType());
                }
                List players = serverWorld.method_8503().method_3760().method_14571();
                for (class_3222 serverPlayerEntity : players) {
                    if (!serverPlayerEntity.method_6059(GHOST_EFFECT_REGISTRY) || !Graveyardsandghosts.CONFIG.enableParticles) continue;
                    EntityUtil.spawnParticles((class_1297)serverPlayerEntity, (float)1.0f, (class_2394)class_2398.field_23114, (int)1, (double)0.025, (double)0.025, (double)0.025, (double)5.0E-4);
                }
            }
        });
    }

    public static void preventPlayerInteractions() {
        AttackBlockCallback.EVENT.register((playerEntity, world, hand, blockPos, direction) -> {
            if (playerEntity.method_7325()) {
                return class_1269.field_5814;
            }
            if (Graveyardsandghosts.CONFIG.preventGhostBlockAttack && playerEntity.method_6059(GHOST_EFFECT_REGISTRY)) {
                class_2248 block = world.method_8320(blockPos).method_26204();
                if (allowedGhostAttackBlocks.contains(block)) {
                    return class_1269.field_5811;
                }
                return class_1269.field_5814;
            }
            return class_1269.field_5811;
        });
        UseBlockCallback.EVENT.register((playerEntity, world, hand, blockHitResult) -> {
            if (playerEntity.method_7325()) {
                return class_1269.field_5814;
            }
            if (Graveyardsandghosts.CONFIG.preventGhostBlockUse && playerEntity.method_6059(GHOST_EFFECT_REGISTRY)) {
                boolean allowedInteraction;
                if (!playerEntity.method_5998(hand).method_7960()) {
                    return class_1269.field_5814;
                }
                class_2248 block = world.method_8320(blockHitResult.method_17777()).method_26204();
                class_2586 blockEntity = world.method_8321(blockHitResult.method_17777());
                boolean bl = allowedInteraction = null != blockEntity && blockEntity.method_11017().equals(graveyardBlocksFeature.BLOCK_ENTITY_TYPES.get("resurrection_block")) || allowedGhostInteractionBlocks.contains(block);
                if (!allowedInteraction) {
                    return class_1269.field_5814;
                }
            }
            return class_1269.field_5811;
        });
        UseEntityCallback.EVENT.register((playerEntity, world, hand, entity, entityHitResult) -> {
            if (playerEntity.method_7325()) {
                return class_1269.field_5814;
            }
            if (Graveyardsandghosts.CONFIG.preventGhostEntityInteraction && playerEntity.method_6059(GHOST_EFFECT_REGISTRY)) {
                if (allowedGhostInteractionEntities.contains(entity.method_5864())) {
                    return class_1269.field_5811;
                }
                return class_1269.field_5814;
            }
            return class_1269.field_5811;
        });
        UseItemCallback.EVENT.register((playerEntity, world, hand) -> {
            if (playerEntity.method_7325()) {
                return class_1271.method_22430(null);
            }
            if (Graveyardsandghosts.CONFIG.preventGhostItemUse) {
                class_1799 handStack = playerEntity.method_6047();
                if (handStack.method_7960()) {
                    handStack = playerEntity.method_6079();
                }
                if (handStack.method_7960()) {
                    return class_1271.method_22430(null);
                }
                if (playerEntity.method_6059(GHOST_EFFECT_REGISTRY)) {
                    if (allowedGhostUseItems.contains(handStack.method_7909())) {
                        return class_1271.method_22430(null);
                    }
                    return class_1271.method_22431(null);
                }
            }
            return class_1271.method_22430(null);
        });
        PlayerBlockBreakEvents.BEFORE.register((world, playerEntity, blockPos, blockState, blockEntity) -> {
            if (playerEntity.method_7325()) {
                return false;
            }
            if (Graveyardsandghosts.CONFIG.preventGhostBlockBreak && playerEntity.method_6059(GHOST_EFFECT_REGISTRY)) {
                return allowedGhostAttackBlocks.contains(blockState.method_26204());
            }
            return true;
        });
        AttackEntityCallback.EVENT.register((playerEntity, world, hand, entity, entityHitResult) -> {
            if (playerEntity.method_7325()) {
                return class_1269.field_5814;
            }
            if (Graveyardsandghosts.CONFIG.preventGhostEntityAttack && playerEntity.method_6059(GHOST_EFFECT_REGISTRY)) {
                if (allowedGhostAttackEntities.contains(entity.method_5864())) {
                    return class_1269.field_5811;
                }
                return class_1269.field_5814;
            }
            return class_1269.field_5811;
        });
        EntityTrackingEvents.START_TRACKING.register((entity, serverPlayerEntity) -> {
            class_1308 mobEntity;
            if (entity instanceof class_1308 && null != (mobEntity = (class_1308)entity) && serverPlayerEntity.method_6059(GHOST_EFFECT_REGISTRY) && !allowedGhostAttackEntities.contains(entity.method_5864())) {
                mobEntity.method_5980(null);
            }
        });
    }

    static {
        gson = GsonUtil.gsonWithAdapters();
        soundLoopTimer = new TickTimer(0, 30);
        soundAdditionsTimer = new TickTimer(0, 30);
    }
}

