/*
 * Decompiled with CFR 0.152.
 */
package me.villagerunknown.graveyardsandghosts.helper;

import java.util.List;
import java.util.Random;
import me.villagerunknown.graveyardsandghosts.Graveyardsandghosts;
import me.villagerunknown.platform.util.MathUtil;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1420;
import net.minecraft.class_1549;
import net.minecraft.class_1559;
import net.minecraft.class_1560;
import net.minecraft.class_1576;
import net.minecraft.class_1590;
import net.minecraft.class_1613;
import net.minecraft.class_1614;
import net.minecraft.class_1627;
import net.minecraft.class_1628;
import net.minecraft.class_1639;
import net.minecraft.class_1641;
import net.minecraft.class_1642;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_5136;
import net.minecraft.class_6880;
import net.minecraft.class_9254;

public class GraveyardMobHelper {
    private static class_1937 WORLD = null;
    private static class_1309 INSTIGATOR = null;
    private static List<class_1308> OVERWORLD;
    private static List<class_1308> NETHER;
    private static List<class_1308> END;
    private static final Random rand;

    public GraveyardMobHelper(class_1937 world, class_1309 instigator) {
        INSTIGATOR = instigator;
        GraveyardMobHelper.init(world);
    }

    public GraveyardMobHelper(class_1937 world) {
        GraveyardMobHelper.init(world);
    }

    private static void init(class_1937 world) {
        WORLD = world;
        OVERWORLD = List.of(new class_1420(class_1299.field_6108, world), new class_1614(class_1299.field_6125, world), new class_1628(class_1299.field_6079, world), new class_1642(class_1299.field_6051, world), new class_1641(class_1299.field_6054, world), new class_1613(class_1299.field_6137, world), new class_9254(class_1299.field_49148, world), new class_1627(class_1299.field_6098, world), new class_1576(class_1299.field_6071, world), new class_1549(class_1299.field_6084, world));
        NETHER = List.of(new class_1613(class_1299.field_6137, world), new class_1590(class_1299.field_6050, world), new class_5136(class_1299.field_23696, world), new class_1639(class_1299.field_6076, world));
        END = List.of(new class_1559(class_1299.field_6128, world), new class_1560(class_1299.field_6091, world));
    }

    public boolean spawnMobByDimension(class_2338 pos, boolean includePresets) {
        class_1308 entity = this.getMobByDimension(pos, includePresets);
        return WORLD.method_8649((class_1297)entity);
    }

    public class_1308 getMobByDimension(class_2338 pos, boolean includePresets) {
        String dimensionStringID;
        class_6880 dimension = WORLD.method_40134();
        class_1308 mob = switch (dimensionStringID = dimension.method_55840()) {
            case "minecraft:the_end" -> this.getMobForEnd();
            case "minecraft:the_nether" -> this.getMobForNether();
            default -> this.getMobForOverworld();
        };
        if (includePresets) {
            return this.getMobWithPresets(mob, pos);
        }
        return this.getMob(mob, pos);
    }

    public class_1308 getMobForOverworld() {
        return (class_1308)OVERWORLD.get(rand.nextInt(OVERWORLD.size())).method_5864().method_5883(WORLD);
    }

    public class_1308 getMobForNether() {
        return (class_1308)NETHER.get(rand.nextInt(NETHER.size())).method_5864().method_5883(WORLD);
    }

    public class_1308 getMobForEnd() {
        return (class_1308)END.get(rand.nextInt(END.size())).method_5864().method_5883(WORLD);
    }

    public boolean spawnMob(class_1308 mob, class_2338 pos, boolean includePresets) {
        class_1308 entity = includePresets ? this.getMobWithPresets(mob, pos) : mob;
        return WORLD.method_8649((class_1297)entity);
    }

    public class_1308 getMob(class_1308 mob, class_2338 pos) {
        mob.method_23327((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5);
        mob.method_6033((float)((double)mob.method_6063() * 0.5));
        mob.method_16826((int)((double)(Graveyardsandghosts.CONFIG.graveyardBlockMobSpawnDelayInMinutes * 60 * 20) * 0.5));
        if (null != INSTIGATOR) {
            mob.method_5980(INSTIGATOR);
        }
        return mob;
    }

    public class_1308 getMobWithPresets(class_1308 mob, class_2338 pos) {
        mob = this.getMob(mob, pos);
        switch (mob.method_5864().toString().replace("entity.minecraft.", "")) {
            case "zombie": 
            case "zombified_piglin": {
                if (!MathUtil.hasChance((float)0.01f)) break;
                mob.method_7217(true);
                break;
            }
            case "skeleton": 
            case "stray": 
            case "bogged": {
                mob = this.addPresetBasicBow(mob);
                break;
            }
            case "vex": 
            case "wither_skeleton": {
                mob = this.addPresetBasicSword(mob);
            }
        }
        return mob;
    }

    private class_1308 addPresetBasicBow(class_1308 mob) {
        class_1268 hand = mob.method_6058();
        class_1799 itemStack = new class_1799((class_1935)class_1802.field_8102, 1);
        mob.method_6122(hand, itemStack);
        return mob;
    }

    private class_1308 addPresetBasicSword(class_1308 mob) {
        class_1268 hand = mob.method_6058();
        class_1799 itemStack = new class_1799((class_1935)class_1802.field_8528, 1);
        mob.method_6122(hand, itemStack);
        return mob;
    }

    static {
        rand = new Random();
    }
}

