/*
 * Decompiled with CFR 0.152.
 */
package com.simladesign.cursedearth.blocks;

import com.simladesign.cursedearth.CursedEarth;
import com.simladesign.cursedearth.mixins.WeightedPickerMixin;
import com.simladesign.cursedearth.util.BiomeSpawnMap;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.class_1267;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1311;
import net.minecraft.class_1317;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2372;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3730;
import net.minecraft.class_4970;
import net.minecraft.class_5425;
import net.minecraft.class_5483;

public class CursedEarthBlock
extends class_2372 {
    private final HashMap<class_2960, BiomeSpawnMap> biomeCache = new HashMap();

    public CursedEarthBlock(class_4970.class_2251 settings) {
        super(settings);
    }

    public boolean method_9651(class_1922 world, class_2338 pos, class_2680 state, boolean isClient) {
        return false;
    }

    public boolean method_9650(class_1937 world, Random random, class_2338 pos, class_2680 state) {
        return false;
    }

    public void method_9514(class_2680 state, class_3218 world, class_2338 pos, Random random) {
        if (!world.field_9236) {
            if (this.isInDaylight((class_1937)world, pos) || !world.method_8320(pos.method_10084()).method_26215()) {
                world.method_8501(pos, class_2246.field_10566.method_9564());
            } else {
                class_2680 defaultState = this.method_9564();
                for (int x = -1; x <= 1; ++x) {
                    for (int y = -3; y <= 1; ++y) {
                        for (int z = -1; z <= 1; ++z) {
                            class_2338 pos1 = pos.method_10069(x, y, z);
                            if (!world.method_8320(pos1).method_27852(class_2246.field_10566) || !world.method_8320(pos1.method_10084()).method_26215()) continue;
                            world.method_8501(pos1, (class_2680)defaultState.method_11657((class_2769)field_11522, (Comparable)Boolean.valueOf(world.method_8320(pos1.method_10084()).method_27852(class_2246.field_10477))));
                        }
                    }
                }
            }
            if (!this.canSpawnMob(world, pos)) {
                return;
            }
            class_1308 mob = this.findMobToSpawn(world, pos, random);
            if (mob != null) {
                mob.method_5814((double)pos.method_10263() + 0.5, (double)(pos.method_10264() + 1), (double)pos.method_10260() + 0.5);
                if (!world.method_17892((class_1297)mob)) {
                    CursedEarth.LOGGER.debug("Can't spawn {}, space is not empty.", (Object)mob.method_5476());
                    return;
                }
                world.method_8649((class_1297)mob);
            }
        }
    }

    private boolean isInDaylight(class_1937 world, class_2338 pos) {
        return world.method_8314(class_1944.field_9284, pos.method_10084()) - world.method_8594() > world.method_8315() / 2;
    }

    private boolean canSpawnMob(class_3218 world, class_2338 pos) {
        String msg = null;
        if (!world.method_8316(pos.method_10084()).method_15769()) {
            msg = "Not spawning: Fluid above cursed earth.";
        } else if (world.method_8401().method_207() == class_1267.field_5801) {
            msg = "Not spawning: Peaceful difficulty.";
        } else {
            int minLight = world.method_8315() / 2;
            if (world.method_22339(pos.method_10084()) > minLight) {
                msg = String.format("Not spawning: Light level above %d.", minLight);
            }
        }
        if (msg != null) {
            CursedEarth.LOGGER.debug(msg);
            return false;
        }
        return true;
    }

    private class_1308 findMobToSpawn(class_3218 world, class_2338 pos, Random random) {
        BiomeSpawnMap map;
        class_1959 biome = world.method_23753(pos);
        class_2960 biomeId = world.method_30349().method_30530(class_2378.field_25114).method_10221((Object)biome);
        if (!this.biomeCache.containsKey(biomeId)) {
            List spawnOptions = biome.method_30966().method_31004(class_1311.field_6302);
            if (spawnOptions.size() == 0) {
                return null;
            }
            map = new BiomeSpawnMap(biomeId);
            for (class_5483.class_1964 spawnOption : spawnOptions) {
                if (!class_1317.method_20638((class_1299)spawnOption.field_9389, (class_5425)world, (class_3730)class_3730.field_16459, (class_2338)pos, (Random)random)) continue;
                map.addEntity(((WeightedPickerMixin)spawnOption).getWeight(), class_1299.method_5890((class_1299)spawnOption.field_9389));
                CursedEarth.LOGGER.debug("Added mob {} with weight {} to the cache.", (Object)spawnOption.field_9389.method_5897().getString(), (Object)((WeightedPickerMixin)spawnOption).getWeight());
            }
            this.biomeCache.put(biomeId, map);
            CursedEarth.LOGGER.debug("Added biome {} to the cache.", (Object)biomeId);
        } else {
            map = this.biomeCache.get(biomeId);
        }
        class_2960 mobName = map.roll(random);
        class_1299 mobType = (class_1299)class_2378.field_11145.method_10223(mobName);
        class_1297 entity = mobType.method_5883((class_1937)world);
        if (!(entity instanceof class_1308)) {
            return null;
        }
        class_1308 mob = (class_1308)entity;
        mob.method_5943((class_5425)world, world.method_8404(pos), class_3730.field_16459, null, null);
        return mob;
    }
}

