/*
 * Decompiled with CFR 0.152.
 */
package org.gwgs.elytracam;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.client.event.RegisterClientCommandsEvent;
import net.neoforged.neoforge.client.event.ViewportEvent;
import net.neoforged.neoforge.common.NeoForge;

@Mod(value="elytracam")
@OnlyIn(value=Dist.CLIENT)
public class Elytracam {
    public float currentRoll = 0.0f;
    public int flightTicks = 0;
    public static int angleLimit = 150;

    public Elytracam(IEventBus modEventBus, ModContainer modContainer) {
        NeoForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void commandRegister(RegisterClientCommandsEvent event) {
        this.registerClientCommands((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    public void roll(ViewportEvent.ComputeCameraAngles event) {
        assert (Minecraft.getInstance().player != null);
        LocalPlayer player = Minecraft.getInstance().player;
        if (player.isFallFlying() && !player.isUnderWater()) {
            ++this.flightTicks;
            if (this.flightTicks > 20) {
                Vec3 velocity = player.getDeltaMovement();
                float yaw = player.getYRot();
                double rollRadians = Math.atan2(velocity.z, velocity.x) - Math.toRadians(yaw);
                float roll = (float)Math.toDegrees(rollRadians);
                if ((roll %= 360.0f) > 180.0f) {
                    roll -= 360.0f;
                }
                if (roll < -180.0f) {
                    roll += 360.0f;
                }
                roll = (roll - 90.0f) * -1.0f;
                int steps = 10;
                if (this.currentRoll != roll && (Math.abs(roll - this.currentRoll) < 150.0f || roll < 40.0f && roll > -40.0f)) {
                    this.currentRoll += (roll - this.currentRoll) / (float)steps;
                }
                this.currentRoll = Math.clamp(this.currentRoll, (float)(-angleLimit), (float)angleLimit);
                event.setRoll(this.currentRoll);
            }
        } else {
            this.currentRoll = 0.0f;
            this.flightTicks = 0;
        }
    }

    private void registerClientCommands(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"elytracam").then(Commands.literal((String)"setanglelimit").then(Commands.argument((String)"limit", (ArgumentType)IntegerArgumentType.integer((int)0, (int)180)).executes(context -> this.setAngleLimit((CommandContext<CommandSourceStack>)context)))));
    }

    private int setAngleLimit(CommandContext<CommandSourceStack> context) {
        int limit;
        angleLimit = limit = IntegerArgumentType.getInteger(context, (String)"limit");
        Minecraft.getInstance().player.sendSystemMessage((Component)Component.literal((String)("Set angle limit to " + limit)));
        return 1;
    }
}

