/*
 * Decompiled with CFR 0.152.
 */
package net.asian.civiliansmod.entity;

import net.asian.civiliansmod.entity.goal.CustomDoorGoal;
import net.asian.civiliansmod.gui.CustomNPCScreen;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1314;
import net.minecraft.class_1352;
import net.minecraft.class_1394;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_5132;
import net.minecraft.class_5134;

public class NPCEntity
extends class_1314 {
    private static final class_2940<Integer> VARIANT = class_2945.method_12791(NPCEntity.class, (class_2941)class_2943.field_13327);
    private float targetYaw = 0.0f;
    private boolean isTurning = false;
    private int lookAtPlayerTicks = 0;

    public NPCEntity(class_1299<? extends class_1314> entityType, class_1937 world) {
        super(entityType, world);
        if (!this.method_37908().field_9236) {
            int variant = this.field_5974.method_43048(88);
            this.setVariant(variant);
            String[] defaultModelNames = new String[]{"Charles", "Cade", "Henry", "Liam", "Rodney", "Nathaniel", "Elliot", "Julian", "Malcolm", "Tobias", "Wesley", "Felix", "Desmond", "Simon", "Miles", "Everett", "Dorian", "Quentin", "Cedric", "Adrian", "Roman", "Marcus", "Gideon", "Levi", "Jasper"};
            String[] slimModelNames = new String[]{"Evelyn", "Sarah", "Olivia", "Emma", "Alexia", "Amelia", "Celeste", "Lillian", "Joleen", "Rosalie", "Clara", "Vivienne", "Elena", "Margot", "Nora", "Daphne", "Fiona", "Genevieve", "Juliette", "Lucille", "Naomi", "Ivy", "Serena", "Vera", "Adelaide"};
            if (variant >= 0 && variant <= 43) {
                String randomName = defaultModelNames[this.field_5974.method_43048(defaultModelNames.length)];
                this.method_5665((class_2561)class_2561.method_43470((String)randomName));
                System.out.println("Assigned 'default' name: " + randomName + " to variant: " + variant);
            } else if (variant >= 44 && variant <= 87) {
                String randomName = slimModelNames[this.field_5974.method_43048(slimModelNames.length)];
                this.method_5665((class_2561)class_2561.method_43470((String)randomName));
                System.out.println("Assigned 'slim' name: " + randomName + " to variant: " + variant);
            }
            this.method_5880(true);
        }
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(VARIANT, (Object)0);
    }

    public int getVariant() {
        return (Integer)this.field_6011.method_12789(VARIANT);
    }

    public void setVariant(int variant) {
        this.field_6011.method_12778(VARIANT, (Object)variant);
    }

    public void method_5665(class_2561 name) {
        super.method_5665(name);
    }

    public boolean isSlim() {
        return this.getVariant() >= 44 && this.getVariant() <= 87;
    }

    public boolean method_17326() {
        return true;
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10569("Variant", this.getVariant());
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        if (nbt.method_10545("Variant")) {
            this.setVariant(nbt.method_10550("Variant"));
        }
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1314.method_26828().method_26868(class_5134.field_23716, 20.0).method_26868(class_5134.field_23719, 0.3);
    }

    protected void method_5959() {
        super.method_5959();
        this.field_6201.method_6277(2, (class_1352)new CustomDoorGoal(this));
        this.field_6201.method_6277(1, (class_1352)new class_1394((class_1314)this, 0.7));
    }

    public boolean method_5643(class_1282 source, float amount) {
        boolean hurt = super.method_5643(source, amount);
        if (hurt && source.method_5529() != null && !this.method_37908().method_8608()) {
            class_2561 nameText = this.method_5797();
            String npcName = nameText != null ? nameText.getString() : "NPC";
            String[] hitDialogues = new String[]{"Ouch! That hurt!", "Hey, watch it!", "Why would you do that?!", "Stop hitting me!", "What\u2019s wrong with you?", "Please, don\u2019t hurt me!", "What have I done to deserve this?!", "Fight me fair and square!", "Watch it pal, you don't know who you're messing with.", "Ow!", "GET AWAY FROM ME!", ";)", "Why must this world cast unfortunate events upon me!", "Hey...please stop I have already had a long day.", "IF ONLY THERE WAS A HERO WHO COULD SAVE ME!", "Lash your anger out on the sheep, not me!", "I'm so sorry, I'm so sorry!", "The prophecy foretold you would do this.", "Friends shouldn't hurt other friends!"};
            String hitDialogue = hitDialogues[this.field_5974.method_43048(hitDialogues.length)];
            class_1297 class_12972 = source.method_5529();
            if (class_12972 instanceof class_1657) {
                class_1657 player = (class_1657)class_12972;
                player.method_43496((class_2561)class_2561.method_43470((String)(npcName + ": " + hitDialogue)));
            }
            double dx = this.method_23317() - source.method_5529().method_23317();
            double dz = this.method_23321() - source.method_5529().method_23321();
            double fleeDistance = 12.0;
            this.method_5942().method_6337(this.method_23317() + dx * fleeDistance, this.method_23318(), this.method_23321() + dz * fleeDistance, 1.2);
        }
        return hurt;
    }

    protected class_1269 method_5992(class_1657 player, class_1268 hand) {
        if (hand == class_1268.field_5808) {
            class_1799 heldItem = player.method_5998(hand);
            if (heldItem.method_31574(class_1802.field_8719) && !this.method_5782() && !this.method_37908().method_8608() && this.canBeLeashedBy(player)) {
                this.method_60964((class_1297)player, true);
                return class_1269.field_5812;
            }
            if (player.method_5715()) {
                if (!this.method_37908().method_8608()) {
                    this.method_5942().method_6340();
                    double dx = player.method_23317() - this.method_23317();
                    double dz = player.method_23321() - this.method_23321();
                    this.targetYaw = (float)(Math.atan2(dz, dx) * 57.29577951308232) - 90.0f;
                    this.isTurning = true;
                    this.lookAtPlayerTicks = 170;
                    return class_1269.field_5812;
                }
                class_310.method_1551().method_1507((class_437)new CustomNPCScreen(this));
                return class_1269.field_5812;
            }
            if (!this.method_37908().method_8608()) {
                this.method_5942().method_6340();
                double dx = player.method_23317() - this.method_23317();
                double dz = player.method_23321() - this.method_23321();
                this.targetYaw = (float)(Math.atan2(dz, dx) * 57.29577951308232) - 90.0f;
                this.isTurning = true;
                this.lookAtPlayerTicks = 60;
                class_2561 nameText = this.method_5797();
                String npcName = nameText != null ? nameText.getString() : "NPC";
                String[] dialogues = new String[]{"Hello there, traveler! How can I help you?", "I hope you're enjoying the day.", "Stay safe\u2014the world is dangerous.", "There's treasure hidden nearby... or so I've heard.", "Don't forget to stay out of trouble!", "I'm here to help you, traveler.", "What can I do for you?", "I'm so hungry... Got any spare food?", "I need to get my eyes checked, everything looks pixelated!", "Sometimes it feels like I'm in a dream. I'm not sure what to do.", "Hey! Can I help you something traveler?", "Some would say the world is flat... can you believe that?", "I don't have time to talk right now, I'm sorry!", "Wow you look totally awesome, I might copy your look!", "I need to find the hidden treasure, rumors have it that it's somewhere around here.", "I love this place, it's a lot of fun to be here!", "I hope someone got rid of that scary dragon... I'm sure it's not here anymore.", "Want to go hunting with me?", "Have you seen my friend? He's a little bit of a troublemaker.", "Hopefully this place doesn't get too crowded...", "I am surprised to see there are not more people here...", "I'm so happy to see you, traveler!", "When the birds sing, I can't help but sing along too.", "I feel this unforgiving anger built up in my body! MUST... MUST... STOP!", "Oop! Excuse me, let me just squeeze past ya", "Darkness consumes me...", "I AM SO HAPPY TO SEE YOU AGAIN! I LOVE YOU!", "Hey, you're doing great"};
                String dialogue = dialogues[this.field_5974.method_43048(dialogues.length)];
                player.method_43496((class_2561)class_2561.method_43470((String)(npcName + ": " + dialogue)));
            }
            return class_1269.field_5812;
        }
        return super.method_5992(player, hand);
    }

    public class_243 method_29919() {
        return new class_243(0.0, 0.9, 0.0);
    }

    public boolean canBeLeashedBy(class_1657 player) {
        return !this.method_60953() && !player.method_5715();
    }

    public void method_6007() {
        super.method_6007();
        if (this.isTurning) {
            this.smoothTurnToTargetYaw();
        }
        if (this.lookAtPlayerTicks > 0) {
            --this.lookAtPlayerTicks;
            this.method_5942().method_6340();
            this.method_18800(0.0, 0.0, 0.0);
        }
    }

    private void smoothTurnToTargetYaw() {
        float turnRate = 7.5f;
        float yawDifference = this.wrapDegrees(this.targetYaw - this.method_36454());
        if (Math.abs(yawDifference) < 1.0f) {
            this.method_36456(this.targetYaw);
            this.field_6283 = this.targetYaw;
            this.field_6241 = this.targetYaw;
            this.isTurning = false;
        } else {
            float yawAdjustment = Math.min(turnRate, Math.max(-turnRate, yawDifference));
            this.method_36456(this.method_36454() + yawAdjustment);
            this.field_6283 = this.method_36454();
            this.field_6241 = this.method_36454();
        }
    }

    private float wrapDegrees(float degrees) {
        while (degrees >= 180.0f) {
            degrees -= 360.0f;
        }
        while (degrees < -180.0f) {
            degrees += 360.0f;
        }
        return degrees;
    }
}

