/*
 * Decompiled with CFR 0.152.
 */
package net.asian.civiliansmod.gui;

import net.asian.civiliansmod.entity.NPCEntity;
import net.asian.civiliansmod.networking.NPCDataPayload;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1314;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_638;
import net.minecraft.class_7833;
import net.minecraft.class_8710;
import net.minecraft.class_898;

public class CustomNPCScreen
extends class_437 {
    private final NPCEntity npc;
    private static final int ENTITY_PREVIEW_SIZE = 25;
    private static final int ENTITY_SPACING = 60;
    private static final int COLUMN_WIDTH = 130;
    private int selectedVariant = -1;
    private int scrollOffset = 0;
    private int maxScrollOffset;
    private boolean isScrolling = false;
    private int scrollbarHeight = 0;
    private int scrollbarY = 0;
    private class_342 nameInputField;

    public CustomNPCScreen(NPCEntity npc) {
        super((class_2561)class_2561.method_43470((String)"Change NPC Variant"));
        this.npc = npc;
    }

    protected void method_25426() {
        String currentName = this.npc.method_5797() != null ? this.npc.method_5797().getString() : "";
        this.nameInputField = new class_342(this.field_22793, this.field_22789 / 2 - 100, 40, 200, 20, (class_2561)class_2561.method_43470((String)"Enter NPC Name"));
        this.nameInputField.method_1852(currentName);
        this.nameInputField.method_1880(32);
        this.method_25429((class_364)this.nameInputField);
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Set Name"), button -> {
            String inputName = this.nameInputField.method_1882();
            if (!inputName.isEmpty()) {
                this.npc.method_5665((class_2561)class_2561.method_43470((String)inputName));
                this.npc.method_5652(this.npc.method_5647(new class_2487()));
            }
        }).method_46434(this.field_22789 / 2 - 50, 70, 100, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Close"), button -> this.method_25419()).method_46434(this.field_22789 / 2 - 75, this.field_22790 - 40, 150, 20).method_46431());
        int totalRows = 22;
        int visibleRows = (this.field_22790 - 100) / 60;
        this.maxScrollOffset = Math.max(0, (totalRows - visibleRows) * 60);
        this.updateScrollBarDimensions();
    }

    public void method_25419() {
        if (class_310.method_1551().field_1724 != null) {
            NPCDataPayload payload = new NPCDataPayload(this.npc.method_5667(), this.nameInputField.method_1882(), this.npc.getVariant());
            ClientPlayNetworking.send((class_8710)payload);
        }
        super.method_25419();
    }

    private void updateScrollBarDimensions() {
        int scrollBarTotalHeight = this.field_22790 - 100;
        float visiblePercentage = (float)(this.field_22790 - 100) / (float)(this.maxScrollOffset + this.field_22790 - 100);
        this.scrollbarHeight = Math.max((int)(visiblePercentage * (float)scrollBarTotalHeight), 15);
        this.scrollbarY = 50 + (int)((float)this.scrollOffset / (float)this.maxScrollOffset * (float)(scrollBarTotalHeight - this.scrollbarHeight));
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        context.method_25294(0, 0, this.field_22789, this.field_22790, -2013265920);
        super.method_25394(context, mouseX, mouseY, delta);
        context.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)"Enter Custom NPC Name:"), this.field_22789 / 2, 20, 0xFFFFFF);
        int lineX = this.field_22789 / 2;
        context.method_25294(lineX - 1, 0, lineX + 1, this.field_22790, 0xFFFFFF);
        int leftPanelPadding = 100;
        int rightPanelPadding = 120;
        int leftPanelX = lineX - 130 - leftPanelPadding;
        int rightPanelX = lineX + rightPanelPadding;
        this.renderVariants(context, mouseX, mouseY, delta, true, this.scrollOffset, leftPanelX);
        this.renderVariants(context, mouseX, mouseY, delta, false, this.scrollOffset, rightPanelX);
        this.renderVanillaScrollBar(context);
        this.nameInputField.method_25394(context, mouseX, mouseY, delta);
        this.renderCenterPreview(context);
    }

    private void renderVanillaScrollBar(class_332 context) {
        int scrollBarX = 10;
        int scrollBarY = 50;
        int scrollBarHeight = this.field_22790 - 100;
        context.method_25294(scrollBarX, scrollBarY, scrollBarX + 6, scrollBarY + scrollBarHeight, -14671840);
        int handleTop = this.scrollbarY;
        int handleHeight = this.scrollbarHeight;
        context.method_25294(scrollBarX + 1, handleTop, scrollBarX + 5, handleTop + handleHeight, -5592406);
        context.method_25294(scrollBarX, handleTop, scrollBarX + 1, handleTop + handleHeight, -7829368);
        context.method_25294(scrollBarX + 5, handleTop, scrollBarX + 6, handleTop + handleHeight, -7829368);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        int scrollBarX = 10;
        int scrollBarY = 50;
        int scrollBarHeight = this.field_22790 - 100;
        if (mouseX >= (double)scrollBarX && mouseX <= (double)(scrollBarX + 6) && mouseY >= (double)scrollBarY && mouseY <= (double)(scrollBarY + scrollBarHeight)) {
            this.isScrolling = true;
            return true;
        }
        if (button == 0) {
            int lineX = this.field_22789 / 2;
            int leftPanelX = lineX - 130 - 100;
            int rightPanelX = lineX + 122;
            int clickedVariant = this.detectClickedVariant(mouseX, mouseY, leftPanelX, true);
            if (clickedVariant == -1) {
                clickedVariant = this.detectClickedVariant(mouseX, mouseY, rightPanelX, false);
            }
            if (clickedVariant != -1) {
                this.selectedVariant = clickedVariant;
                this.npc.setVariant(clickedVariant);
                this.npc.method_5652(this.npc.method_5647(new class_2487()));
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    private int detectClickedVariant(double mouseX, double mouseY, int panelX, boolean isDefault) {
        int startVariantIndex = isDefault ? 0 : 44;
        int endVariantIndex = isDefault ? 43 : 87;
        int startY = 50;
        mouseY -= -15.0;
        for (int i = startVariantIndex; i <= endVariantIndex; i += 2) {
            int rowIndex = (i - startVariantIndex) / 2;
            int yPosition = startY + rowIndex * 60 - this.scrollOffset;
            if (yPosition + 60 < 0 || yPosition > this.field_22790) continue;
            int columnWidthHalf = 65;
            if (mouseX >= (double)panelX && mouseX <= (double)(panelX + columnWidthHalf) && mouseY >= (double)(yPosition + 9) && mouseY <= (double)(yPosition + 60 + 9)) {
                return i;
            }
            if (!(mouseX >= (double)(panelX + columnWidthHalf)) || !(mouseX <= (double)(panelX + 130)) || !(mouseY >= (double)(yPosition + 9)) || !(mouseY <= (double)(yPosition + 60 + 9))) continue;
            return i + 1;
        }
        return -1;
    }

    private void renderCenterPreview(class_332 context) {
        if (this.selectedVariant != -1) {
            NPCEntity previewNPC = this.createPreviewNPC(this.selectedVariant);
            int centerX = this.field_22789 / 2;
            int centerY = this.field_22790 / 2 + 73;
            this.renderEntity(context.method_51448(), centerX, centerY, 57, previewNPC);
        }
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.isScrolling) {
            int scrollBarY = 50;
            int scrollBarHeight = this.field_22790 - 100;
            float relativeY = (float)(mouseY - (double)scrollBarY);
            float scrollPercent = relativeY / (float)(scrollBarHeight - this.scrollbarHeight);
            this.scrollOffset = Math.max(0, Math.min((int)(scrollPercent * (float)this.maxScrollOffset), this.maxScrollOffset));
            this.updateScrollBarDimensions();
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        this.isScrolling = false;
        return super.method_25406(mouseX, mouseY, button);
    }

    private void renderVariants(class_332 context, int mouseX, int mouseY, float ignoredDelta, boolean isDefault, int scrollOffset, int panelX) {
        String title = isDefault ? "Default Models" : "   Slim Models";
        context.method_25303(this.field_22793, title, panelX + 65 - 50, 20, 0xFFFFFF);
        int startY = 65;
        int startVariantIndex = isDefault ? 0 : 44;
        int endVariantIndex = isDefault ? 43 : 87;
        for (int i = startVariantIndex; i <= endVariantIndex; i += 2) {
            int rowIndex = (i - startVariantIndex) / 2;
            int yPosition = startY + rowIndex * 60 - scrollOffset;
            if (yPosition + 60 < 100 || yPosition > this.field_22790) continue;
            this.renderVariantPreview(context, panelX, yPosition, i, mouseX, mouseY);
            this.renderVariantPreview(context, panelX + 65, yPosition, i + 1, mouseX, mouseY);
        }
    }

    private void renderVariantPreview(class_332 context, int x, int y, int variantIndex, int mouseX, int mouseY) {
        if (variantIndex > 87) {
            return;
        }
        NPCEntity previewNPC = this.createPreviewNPC(variantIndex);
        this.renderEntity(context.method_51448(), x + 25, y + 30, 25, previewNPC);
        int adjustedX = x + 4;
        int adjustedY = y - 22;
        int entityWidth = 42;
        int entityHeight = 57;
        if (mouseX >= adjustedX && mouseX <= adjustedX + entityWidth && mouseY >= adjustedY && mouseY <= adjustedY + entityHeight) {
            int outlineThickness = 1;
            context.method_25294(adjustedX, adjustedY, adjustedX + entityWidth, adjustedY + outlineThickness, -1);
            context.method_25294(adjustedX, adjustedY + entityHeight - outlineThickness, adjustedX + entityWidth, adjustedY + entityHeight, -1);
            context.method_25294(adjustedX, adjustedY, adjustedX + outlineThickness, adjustedY + entityHeight, -1);
            context.method_25294(adjustedX + entityWidth - outlineThickness, adjustedY, adjustedX + entityWidth, adjustedY + entityHeight, -1);
        }
    }

    private NPCEntity createPreviewNPC(int variantIndex) {
        class_638 world = class_310.method_1551().field_1687;
        NPCEntity previewNPC = new NPCEntity((class_1299<? extends class_1314>)this.npc.method_5864(), (class_1937)world);
        previewNPC.setVariant(variantIndex);
        previewNPC.method_5977(true);
        previewNPC.method_5803(true);
        previewNPC.method_5847(0.0f);
        return previewNPC;
    }

    private void renderEntity(class_4587 matrices, int x, int y, int scale, NPCEntity entity) {
        class_898 dispatcher = class_310.method_1551().method_1561();
        matrices.method_22903();
        matrices.method_22904((double)x, (double)y, 10.0);
        matrices.method_22905((float)scale, (float)scale, (float)scale);
        matrices.method_22907(class_7833.field_40716.rotationDegrees(180.0f));
        matrices.method_22907(class_7833.field_40714.rotationDegrees(180.0f));
        dispatcher.method_3954((class_1297)entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, matrices, (class_4597)class_310.method_1551().method_22940().method_23000(), 0xF000F0);
        matrices.method_22909();
    }
}

