/*
 * Decompiled with CFR 0.152.
 */
package org.mangorage.tiab.common.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2196;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.mangorage.tiab.common.api.ICommonTimeInABottleAPI;
import org.mangorage.tiab.common.api.ITiabConfig;
import org.mangorage.tiab.common.core.StoredTimeComponent;
import org.mangorage.tiab.common.items.TiabItem;
import org.mangorage.tiab.common.misc.CommonHelper;

public class TiabCommands {
    private static final String ADD_TIME_COMMAND = "addTime";
    private static final String REMOVE_TIME_COMMAND = "removeTime";
    private static final String TIME_PARAM = "seconds";
    public static LiteralArgumentBuilder<class_2168> addTimeCommand = (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"addTime").requires(commandSource -> commandSource.method_9259(2))).then(class_2170.method_9244((String)"seconds", (ArgumentType)class_2196.method_9340()).executes(ctx -> {
        try {
            return TiabCommands.processTimeCommand((CommandContext<class_2168>)ctx, true);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }));
    public static LiteralArgumentBuilder<class_2168> removeTimeCommand = (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"removeTime").requires(commandSource -> commandSource.method_9259(2))).then(class_2170.method_9244((String)"seconds", (ArgumentType)class_2196.method_9340()).executes(ctx -> {
        try {
            return TiabCommands.processTimeCommand((CommandContext<class_2168>)ctx, false);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }));

    private static int processTimeCommand(CommandContext<class_2168> ctx, boolean isAdd) throws CommandSyntaxException {
        class_2561 messageValue = class_2196.method_9339(ctx, (String)TIME_PARAM);
        class_2168 source = (class_2168)ctx.getSource();
        class_3222 player = source.method_9207();
        ITiabConfig cfg = ICommonTimeInABottleAPI.COMMON_API.get().getConfig();
        if (!messageValue.getString().isEmpty()) {
            try {
                int timeToAdd = Integer.parseInt(messageValue.getString());
                if (timeToAdd < 0) {
                    throw new NumberFormatException();
                }
                if (timeToAdd > cfg.MAX_STORED_TIME() / cfg.TICKS_CONST()) {
                    timeToAdd = cfg.MAX_STORED_TIME() / cfg.TICKS_CONST();
                }
                boolean success = false;
                for (int i = 0; i < player.method_31548().method_5439(); ++i) {
                    int timeToAddFinal;
                    class_1799 invStack = player.method_31548().method_5438(i);
                    class_1792 item = invStack.method_7909();
                    if (!(item instanceof TiabItem)) continue;
                    TiabItem itemTiab = (TiabItem)item;
                    int currentStoredEnergy = itemTiab.getStoredComponent(invStack).stored();
                    if (!isAdd) {
                        if (currentStoredEnergy / cfg.TICKS_CONST() < timeToAdd) {
                            timeToAdd = currentStoredEnergy / cfg.TICKS_CONST();
                        }
                        timeToAdd = -timeToAdd;
                    }
                    if (CommonHelper.isPositive(currentStoredEnergy + (timeToAddFinal = timeToAdd) * cfg.TICKS_CONST())) {
                        CommonHelper.modify(invStack, ICommonTimeInABottleAPI.COMMON_API.get().getRegistration().getStoredTime(), () -> new StoredTimeComponent(0, 0), old -> new StoredTimeComponent(currentStoredEnergy + timeToAddFinal * cfg.TICKS_CONST(), old.total()));
                        CommonHelper.sendStatusMessage(player, String.format("%s %d seconds", isAdd ? "Added" : "Removed ", timeToAdd));
                    }
                    success = true;
                }
                if (!success) {
                    CommonHelper.sendStatusMessage(player, "No Time in a bottle item in inventory");
                }
                return 1;
            }
            catch (NumberFormatException ex) {
                CommonHelper.sendStatusMessage(player, "Invalid time parameter! (is the number too big?)");
            }
        } else {
            CommonHelper.sendStatusMessage(player, "Empty time parameter!");
        }
        return 0;
    }
}

