/*
 * Decompiled with CFR 0.152.
 */
package net.dndats.hackersandslashers.api.combat.critical.logic;

import net.dndats.hackersandslashers.api.interfaces.ICriticalLogic;
import net.dndats.hackersandslashers.utils.EntityHelper;
import net.dndats.hackersandslashers.utils.ItemHelper;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;

public class BackstabLogic
implements ICriticalLogic {
    private final float DAMAGE_MULTIPLIER;

    public BackstabLogic(float damageMultiplier) {
        if (damageMultiplier <= 0.0f) {
            throw new IllegalArgumentException("Damage multiplier must be greater than 0");
        }
        this.DAMAGE_MULTIPLIER = damageMultiplier;
    }

    @Override
    public boolean canBeApplied(Entity source, LivingEntity target) {
        if (!(source instanceof Player)) {
            return false;
        }
        Player player = (Player)source;
        if (target instanceof Player) {
            return EntityHelper.isBehind(player, target) && !EntityHelper.isAwareOf(player, target);
        }
        return !EntityHelper.isBeingTargeted(player, target);
    }

    @Override
    public float getAdditionalModifiers(LivingIncomingDamageEvent event) {
        ItemStack usedItem = event.getSource().getWeaponItem();
        if (usedItem == null) {
            return 0.0f;
        }
        Entity entity = event.getSource().getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            float baseDamage = ItemHelper.getAttackDamage(usedItem, player);
            float attackSpeed = ItemHelper.getAttackSpeed(usedItem, player);
            float alpha = 2.0f;
            float beta = 0.5f;
            float adjustmentFactor = 1.5f;
            float additionalDamage = (float)(Math.pow(attackSpeed, alpha) * (double)adjustmentFactor - (double)(baseDamage * beta));
            return Math.max(additionalDamage, 0.0f);
        }
        return 0.0f;
    }

    @Override
    public void applyOnHitFunction(LivingIncomingDamageEvent event) {
        Player player = (Player)event.getSource().getEntity();
        if (player == null) {
            return;
        }
        LivingEntity target = event.getEntity();
        if (EntityHelper.isBehind(player, target)) {
            target.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 20, 1, false, false));
        }
    }

    @Override
    public float getDamageMultiplier() {
        return this.DAMAGE_MULTIPLIER;
    }
}

