/*
 * Decompiled with CFR 0.152.
 */
package net.dndats.hackersandslashers.api.combat.critical.logic;

import net.dndats.hackersandslashers.api.interfaces.ICriticalLogic;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;

public class HeadshotLogic
implements ICriticalLogic {
    private final float DAMAGE_MULTIPLIER;

    public HeadshotLogic(float damageMultiplier) {
        if (damageMultiplier <= 0.0f) {
            throw new IllegalArgumentException("Damage multiplier must be greater than 0");
        }
        this.DAMAGE_MULTIPLIER = damageMultiplier;
    }

    @Override
    public boolean canBeApplied(Entity directSourceEntity, LivingEntity target) {
        if (directSourceEntity instanceof Projectile) {
            double tolerance;
            Projectile projectile = (Projectile)directSourceEntity;
            double targetEyeHeight = target.getEyeHeight();
            double targetEyeYCenter = target.getY() + targetEyeHeight;
            return projectile.position().y >= targetEyeYCenter - (tolerance = 0.5) && projectile.position().y <= targetEyeYCenter + tolerance;
        }
        return false;
    }

    @Override
    public float getAdditionalModifiers(LivingIncomingDamageEvent event) {
        return 0.0f;
    }

    @Override
    public void applyOnHitFunction(LivingIncomingDamageEvent event) {
    }

    @Override
    public float getDamageMultiplier() {
        return this.DAMAGE_MULTIPLIER;
    }
}

