/*
 * Decompiled with CFR 0.152.
 */
package net.dndats.hackersandslashers.api.combat.critical.logic;

import net.dndats.hackersandslashers.api.interfaces.ICriticalLogic;
import net.dndats.hackersandslashers.common.setup.ModMobEffects;
import net.dndats.hackersandslashers.utils.ItemHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;

public class RiposteLogic
implements ICriticalLogic {
    private final float DAMAGE_MULTIPLIER;

    public RiposteLogic(float damageMultiplier) {
        if (damageMultiplier <= 0.0f) {
            throw new IllegalArgumentException("Damage multiplier must be greater than 0");
        }
        this.DAMAGE_MULTIPLIER = damageMultiplier;
    }

    @Override
    public boolean canBeApplied(Entity source, LivingEntity target) {
        return target.hasEffect(ModMobEffects.STUN);
    }

    @Override
    public float getAdditionalModifiers(LivingIncomingDamageEvent event) {
        ItemStack usedItem = event.getSource().getWeaponItem();
        if (usedItem == null) {
            return 0.0f;
        }
        Entity entity = event.getSource().getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            float baseDamage = ItemHelper.getAttackDamage(usedItem, player);
            float attackSpeed = ItemHelper.getAttackSpeed(usedItem, player);
            float alpha = 0.125f;
            float beta = 0.75f;
            float adjustmentFactor = 0.25f;
            float additionalDamage = (float)(Math.pow(baseDamage, beta) * (double)adjustmentFactor - (double)(attackSpeed * alpha));
            return Math.max(additionalDamage, 0.0f);
        }
        return 0.0f;
    }

    @Override
    public void applyOnHitFunction(LivingIncomingDamageEvent event) {
        if (event.getEntity().hasEffect(ModMobEffects.STUN)) {
            event.getEntity().removeEffect(ModMobEffects.STUN);
            event.setAmount(event.getAmount() + event.getEntity().getMaxHealth() * 0.05f);
        }
    }

    @Override
    public float getDamageMultiplier() {
        return this.DAMAGE_MULTIPLIER;
    }
}

