/*
 * Decompiled with CFR 0.152.
 */
package net.dndats.hackersandslashers.api.combat.mechanics.ai;

import java.util.EnumSet;
import net.dndats.hackersandslashers.utils.EntityHelper;
import net.dndats.hackersandslashers.utils.PlayerHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;

public class SearchLostPlayerGoal
extends Goal {
    private static final Double SEARCH_SPEED = 1.0;
    private final Mob mob;
    private BlockPos targetPos;
    private Player target;

    public SearchLostPlayerGoal(Mob mob) {
        this.mob = mob;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean canUse() {
        return EntityHelper.getMobAlertLevel(this.mob) == 50 && this.mob.getRandom().nextBoolean();
    }

    public void start() {
        Player mostProbableTarget = this.mob.level().getNearestPlayer((Entity)this.mob, 20.0);
        if (PlayerHelper.getVisibilityLevel(mostProbableTarget) == 50.0 && mostProbableTarget != null) {
            this.target = mostProbableTarget;
        }
        if (this.target != null) {
            RandomSource random = this.mob.getRandom();
            this.targetPos = this.target.blockPosition().offset(this.mob.getRandom().nextInt(10) - 5, 0, this.mob.getRandom().nextInt(10) - 5);
        }
    }

    public void tick() {
        if (this.targetPos != null) {
            this.mob.getNavigation().moveTo((double)this.targetPos.getX() + 0.5, (double)this.targetPos.getY() + 0.5, (double)this.targetPos.getZ() + 0.5, SEARCH_SPEED.doubleValue());
        }
    }

    public boolean canContinueToUse() {
        return this.targetPos != null && !this.mob.getNavigation().isDone();
    }
}

