/*
 * Decompiled with CFR 0.152.
 */
package net.dndats.hackersandslashers.api.combat.mechanics.parry;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Random;
import net.dndats.hackersandslashers.client.effects.SoundEffects;
import net.dndats.hackersandslashers.common.data.IsParryingData;
import net.dndats.hackersandslashers.common.network.packets.PacketTriggerPlayerParry;
import net.dndats.hackersandslashers.common.setup.ModPlayerData;
import net.dndats.hackersandslashers.utils.AnimationHelper;
import net.dndats.hackersandslashers.utils.CombatHelper;
import net.dndats.hackersandslashers.utils.EntityHelper;
import net.dndats.hackersandslashers.utils.ItemHelper;
import net.dndats.hackersandslashers.utils.PlayerHelper;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.network.PacketDistributor;

public class Parry {
    private static final Random lostHealthComparator = new Random();
    private static final int MAX_COOLDOWN = 20;
    private static final HashSet<ResourceKey<DamageType>> damageSourcesAccepted = new HashSet<ResourceKey>(Arrays.asList(DamageTypes.PLAYER_ATTACK, DamageTypes.MOB_ATTACK, DamageTypes.ARROW, DamageTypes.MOB_ATTACK_NO_AGGRO, DamageTypes.EXPLOSION, DamageTypes.SONIC_BOOM));

    public static int getMaxCooldown() {
        return 20;
    }

    public static void parryBehavior(float damageReduction, LivingIncomingDamageEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (damageSourcesAccepted.stream().noneMatch(arg_0 -> ((DamageSource)event.getSource()).is(arg_0))) {
            return;
        }
        if (!PlayerHelper.isBlocking(player)) {
            return;
        }
        Parry.handleParryEffects(player, event, damageReduction);
    }

    private static void handleParryEffects(Player player, LivingIncomingDamageEvent event, float damageReduction) {
        SoundEffects.playParrySound((LivingEntity)player);
        ItemHelper.damageBlockWeapon((LivingEntity)player, (int)event.getAmount());
        event.setAmount(Parry.calculateReducedDamage(event.getAmount(), damageReduction));
        if (Parry.shouldStunAttacker(event)) {
            CombatHelper.stunAttackingEntity(event);
        }
    }

    private static float calculateReducedDamage(float originalDamage, float reductionPercentage) {
        return originalDamage * (reductionPercentage / 100.0f);
    }

    private static boolean shouldStunAttacker(LivingIncomingDamageEvent event) {
        Entity entity;
        if (!event.getSource().isDirect() || !((entity = event.getSource().getEntity()) instanceof LivingEntity)) {
            return false;
        }
        LivingEntity source = (LivingEntity)entity;
        int chance = lostHealthComparator.nextInt(100);
        return EntityHelper.getMobLostHealth(source) >= chance;
    }

    public static void triggerDefensive(int duration, Player player) {
        if (player == null) {
            return;
        }
        if (Parry.canParry(player)) {
            AnimationHelper.playBlockAnimation(player);
            IsParryingData playerData = (IsParryingData)player.getData(ModPlayerData.IS_PARRYING);
            playerData.setIsParrying(true);
            PacketDistributor.sendToServer((CustomPacketPayload)new PacketTriggerPlayerParry(playerData, duration), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    private static boolean canParry(Player player) {
        return !player.isCrouching() && !PlayerHelper.isBlocking(player) && !PlayerHelper.isPointingAtBlockEntity(player) && !player.swinging;
    }
}

