/*
 * Decompiled with CFR 0.152.
 */
package net.dndats.hackersandslashers.api.combat.mechanics.stealth;

import net.dndats.hackersandslashers.api.combat.mechanics.ai.SearchLostPlayerGoal;
import net.dndats.hackersandslashers.common.data.VisibilityLevelData;
import net.dndats.hackersandslashers.common.setup.ModPlayerData;
import net.dndats.hackersandslashers.utils.EntityHelper;
import net.dndats.hackersandslashers.utils.PlayerHelper;
import net.dndats.hackersandslashers.utils.TickScheduler;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.entity.living.LivingChangeTargetEvent;

public class Stealth {
    private static final int DETECTION_WAIT_TIME = 60;

    public static void stealthBehavior(LivingChangeTargetEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Mob) {
            Mob mob = (Mob)livingEntity;
            livingEntity = event.getNewAboutToBeSetTarget();
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                if (EntityHelper.getMobAlertLevel(mob) == 50) {
                    event.setNewAboutToBeSetTarget(null);
                }
                Stealth.makeMobSearch(mob, player);
                if (!EntityHelper.hasAlertTag(mob)) {
                    if (PlayerHelper.isAtDarkPlace(player) && !Stealth.isStealthy(player) && !EntityHelper.isAwareOf(player, (LivingEntity)mob)) {
                        EntityHelper.addAlertTag(mob, 50);
                        TickScheduler.schedule(() -> {
                            if (Stealth.isStealthy(player) && !EntityHelper.isAwareOf(player, (LivingEntity)mob)) {
                                EntityHelper.removeAlertTag(mob);
                                event.setNewAboutToBeSetTarget(null);
                            } else {
                                EntityHelper.addAlertTag(mob, 100);
                                mob.setTarget((LivingEntity)player);
                            }
                        }, 60 - Math.max(player.getArmorValue(), 0));
                    } else if (Stealth.isStealthy(player) && !EntityHelper.isAwareOf(player, (LivingEntity)mob)) {
                        EntityHelper.removeAlertTag(mob);
                        event.setNewAboutToBeSetTarget(null);
                    } else {
                        EntityHelper.addAlertTag(mob, 100);
                        mob.setTarget((LivingEntity)player);
                    }
                }
            }
        }
    }

    private static void makeMobSearch(Mob mob, Player player) {
        if (mob.goalSelector.getAvailableGoals().stream().noneMatch(goal -> goal.getGoal() instanceof SearchLostPlayerGoal) && !(mob instanceof Warden)) {
            mob.playAmbientSound();
            mob.lookAt(EntityAnchorArgument.Anchor.EYES, player.position());
            mob.goalSelector.addGoal(5, (Goal)new SearchLostPlayerGoal(mob));
        }
    }

    public static void detectBeingTargeted(Player player) {
        if (player == null) {
            return;
        }
        VisibilityLevelData playerData = (VisibilityLevelData)player.getData(ModPlayerData.VISIBILITY_LEVEL);
        if (Stealth.mobAlertChecker(player) || Stealth.mobLastAttackerChecker(player) || Stealth.mobSightChecker(player)) {
            if (Stealth.mobTargetChecker(player) || Stealth.mobLastAttackerChecker(player)) {
                if (PlayerHelper.getVisibilityLevel(player) != 100.0) {
                    playerData.setVisibilityLevel(100);
                    playerData.syncData((Entity)player);
                }
            } else if (Stealth.mobSightChecker(player)) {
                if (PlayerHelper.getVisibilityLevel(player) != 50.0) {
                    playerData.setVisibilityLevel(50);
                    playerData.syncData((Entity)player);
                }
            } else if (PlayerHelper.getVisibilityLevel(player) != 50.0) {
                playerData.setVisibilityLevel(50);
                playerData.syncData((Entity)player);
            }
        } else if (PlayerHelper.getVisibilityLevel(player) != 0.0) {
            playerData.setVisibilityLevel(0);
            playerData.syncData((Entity)player);
        }
    }

    private static boolean mobTargetChecker(Player player) {
        if (player == null) {
            return false;
        }
        Vec3 surroundings = new Vec3(player.getX(), player.getY(), player.getZ());
        return player.level().getEntitiesOfClass(Mob.class, new AABB(surroundings, surroundings).inflate(64.0)).stream().anyMatch(mob -> mob.getTarget() == player);
    }

    private static boolean mobAlertChecker(Player player) {
        if (player == null) {
            return false;
        }
        Vec3 surroundings = new Vec3(player.getX(), player.getY(), player.getZ());
        return player.level().getEntitiesOfClass(Mob.class, new AABB(surroundings, surroundings).inflate(64.0)).stream().anyMatch(EntityHelper::hasAlertTag);
    }

    private static boolean mobLastAttackerChecker(Player player) {
        if (player == null) {
            return false;
        }
        Vec3 surroundings = new Vec3(player.getX(), player.getY(), player.getZ());
        return player.level().getEntitiesOfClass(LivingEntity.class, new AABB(surroundings, surroundings).inflate(64.0)).stream().anyMatch(mob -> mob.getLastAttacker() == player && mob.getHealth() > 0.0f);
    }

    private static boolean mobSightChecker(Player player) {
        if (player == null) {
            return false;
        }
        Vec3 surroundings = new Vec3(player.getX(), player.getY(), player.getZ());
        return player.level().getEntitiesOfClass(LivingEntity.class, new AABB(surroundings, surroundings).inflate(64.0)).stream().anyMatch(entity -> {
            if (!PlayerHelper.isOnBush(player) || !PlayerHelper.isAtDarkPlace(player)) {
                return entity.hasLineOfSight((Entity)player) && entity != player;
            }
            return false;
        });
    }

    private static boolean isStealthy(Player player) {
        return !(!PlayerHelper.isOnBush(player) && !PlayerHelper.isAtDarkPlace(player) || !player.isCrouching() && !player.isInvisible());
    }
}

