/*
 * Decompiled with CFR 0.152.
 */
package net.dndats.hackersandslashers.api.manager;

import java.util.ArrayList;
import java.util.List;
import net.dndats.hackersandslashers.HackersAndSlashers;
import net.dndats.hackersandslashers.api.interfaces.ICritical;
import net.dndats.hackersandslashers.api.manager.RangedCritical;
import net.dndats.hackersandslashers.utils.CombatHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;

public class CriticalManager {
    private static final List<ICritical> criticalTypes = new ArrayList<ICritical>();

    public static void registerCritical(ICritical critical) {
        criticalTypes.add(critical);
    }

    public static boolean applyCriticalHit(LivingIncomingDamageEvent event) {
        try {
            Entity entity = event.getSource().getEntity();
            if (entity instanceof Player) {
                Player player = (Player)entity;
                float totalDamageMultiplier = CriticalManager.processCriticalHit(event, player);
                if (totalDamageMultiplier > 0.0f) {
                    float finalAmount = CombatHelper.dealCriticalDamage(totalDamageMultiplier, event);
                    HackersAndSlashers.LOGGER.info("Dealt {} damage with a total multiplier of {}", (Object)Float.valueOf(finalAmount), (Object)Float.valueOf(totalDamageMultiplier));
                    return true;
                }
                return false;
            }
        }
        catch (Exception e) {
            HackersAndSlashers.LOGGER.error("Error while trying to process critical: {}", (Object)e.getMessage());
        }
        return false;
    }

    private static float processCriticalHit(LivingIncomingDamageEvent event, Player player) {
        float totalDamageMultiplier = 0.0f;
        for (ICritical critical : criticalTypes) {
            RangedCritical rangedCritical;
            if (critical instanceof RangedCritical && (rangedCritical = (RangedCritical)critical).getLogic().canBeApplied(event.getSource().getDirectEntity(), event.getEntity())) {
                totalDamageMultiplier += rangedCritical.getLogic().getDamageMultiplier();
            }
            if (!critical.getLogic().canBeApplied((Entity)player, event.getEntity())) continue;
            totalDamageMultiplier += critical.getLogic().getDamageMultiplier();
            totalDamageMultiplier += critical.getLogic().getAdditionalModifiers(event);
            critical.getLogic().applyOnHitFunction(event);
        }
        return totalDamageMultiplier;
    }
}

