/*
 * Decompiled with CFR 0.152.
 */
package net.dndats.hackersandslashers.assets.effects.behavior;

import net.dndats.hackersandslashers.common.setup.ModMobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import net.neoforged.neoforge.event.entity.player.AttackEntityEvent;

@EventBusSubscriber(modid="hackersandslashers")
public class StunBehavior {
    @SubscribeEvent
    public static void disablePlayerActions(AttackEntityEvent event) {
        if (event.getEntity().hasEffect(ModMobEffects.STUN)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onEffectEnd(MobEffectEvent.Expired event) {
        LivingEntity livingEntity;
        if (event.getEffectInstance() == null) {
            return;
        }
        if (event.getEffectInstance().getEffect().equals(ModMobEffects.STUN) && (livingEntity = event.getEntity()) instanceof Mob) {
            Mob mob = (Mob)livingEntity;
            mob.setNoAi(false);
        }
    }

    @SubscribeEvent
    public static void onEffectRemoved(MobEffectEvent.Remove event) {
        LivingEntity livingEntity;
        if (event.getEffectInstance() == null) {
            return;
        }
        if (event.getEffectInstance().getEffect().equals(ModMobEffects.STUN) && (livingEntity = event.getEntity()) instanceof Mob) {
            Mob mob = (Mob)livingEntity;
            mob.setNoAi(false);
        }
    }
}

