/*
 * Decompiled with CFR 0.152.
 */
package net.dndats.hackersandslashers.assets.particles.critical.type.instance;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class CritMagic
extends TextureSheetParticle {
    private final SpriteSet spriteSet;

    public CritMagic(ClientLevel world, double x, double y, double z, double vx, double vy, double vz, SpriteSet spriteSet) {
        super(world, x, y, z);
        this.spriteSet = spriteSet;
        this.setSize(2.0f, 2.0f);
        this.quadSize *= 2.0f;
        this.lifetime = 40;
        this.gravity = -0.1f;
        this.hasPhysics = false;
        this.xd = vx * 1.0;
        this.yd = vy * 1.0;
        this.zd = vz * 1.0;
        this.rCol = 1.0f;
        this.gCol = 0.5f;
        this.bCol = 1.0f;
        this.pickSprite(spriteSet);
    }

    public int getLightColor(float partialTick) {
        int baseLight = 0xF000F0;
        float fadeFactor = 1.0f - (float)this.age / (float)this.lifetime;
        int fadedLight = (int)((float)baseLight * fadeFactor);
        return fadedLight;
    }

    @NotNull
    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_LIT;
    }

    public void tick() {
        super.tick();
        if (this.age < this.lifetime) {
            this.quadSize *= 1.0f - (float)this.age / (float)this.lifetime;
        }
    }
}

