/*
 * Decompiled with CFR 0.152.
 */
package net.dndats.hackersandslashers.assets.particles.effects.attack.instance;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class AttackSpark
extends TextureSheetParticle {
    private final SpriteSet spriteSet;

    public AttackSpark(ClientLevel world, double x, double y, double z, double vx, double vy, double vz, SpriteSet spriteSet) {
        super(world, x, y, z);
        this.spriteSet = spriteSet;
        this.setSize(0.1f, 0.1f);
        this.quadSize = 0.2f;
        this.lifetime = 15;
        this.gravity = 0.1f;
        this.hasPhysics = false;
        double spread = 0.5;
        this.xd = (this.random.nextDouble() - 0.5) * spread;
        this.yd = (this.random.nextDouble() - 0.5) * spread;
        this.zd = (this.random.nextDouble() - 0.5) * spread;
        this.rCol = 1.0f;
        this.gCol = 1.0f;
        this.bCol = 0.25f;
        this.pickSprite(spriteSet);
    }

    public int getLightColor(float partialTick) {
        int baseLight = 0xF000F0;
        float fadeFactor = 1.0f - (float)this.age / (float)this.lifetime;
        int fadedLight = (int)((float)baseLight * fadeFactor);
        return fadedLight;
    }

    @NotNull
    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_LIT;
    }

    public void tick() {
        super.tick();
        if (this.age < this.lifetime) {
            this.quadSize *= 1.0f - (float)this.age / (float)this.lifetime;
            float progress = (float)this.age / (float)this.lifetime;
            float initialRollSpeed = 10.0f;
            float finalRollSpeed = 5.0f;
            float currentRollSpeed = initialRollSpeed + (finalRollSpeed - initialRollSpeed) * progress;
            this.roll += (float)Math.toRadians(currentRollSpeed);
        }
    }
}

