/*
 * Decompiled with CFR 0.152.
 */
package net.dndats.hackersandslashers.client.animations;

import dev.kosmx.playerAnim.api.firstPerson.FirstPersonConfiguration;
import dev.kosmx.playerAnim.api.firstPerson.FirstPersonMode;
import dev.kosmx.playerAnim.api.layered.IAnimation;
import dev.kosmx.playerAnim.api.layered.ModifierLayer;
import dev.kosmx.playerAnim.api.layered.modifier.AbstractFadeModifier;
import dev.kosmx.playerAnim.minecraftApi.PlayerAnimationAccess;
import dev.kosmx.playerAnim.minecraftApi.PlayerAnimationFactory;
import dev.kosmx.playerAnim.minecraftApi.PlayerAnimationRegistry;
import java.util.Objects;
import net.dndats.hackersandslashers.HackersAndSlashers;
import net.dndats.hackersandslashers.common.network.packets.PacketPlayAnimationAtPlayer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.network.PacketDistributor;

@EventBusSubscriber(modid="hackersandslashers", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class PlayerAnimator {
    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        PlayerAnimationFactory.ANIMATION_DATA_FACTORY.registerFactory(ResourceLocation.fromNamespaceAndPath((String)"hackersandslashers", (String)"player_animations"), 42, PlayerAnimator::registerPlayerAnimation);
    }

    private static IAnimation registerPlayerAnimation(AbstractClientPlayer player) {
        return new ModifierLayer();
    }

    public static void playAnimation(LevelAccessor world, Entity entity, String animationName) {
        try {
            if (entity == null) {
                return;
            }
            if (world.isClientSide()) {
                if (Minecraft.getInstance().player == null) {
                    return;
                }
                if (entity instanceof AbstractClientPlayer) {
                    ModifierLayer modifierLayer;
                    ModifierLayer animation;
                    AbstractClientPlayer clientPlayer = (AbstractClientPlayer)entity;
                    IAnimation associatedData = PlayerAnimationAccess.getPlayerAssociatedData((AbstractClientPlayer)Minecraft.getInstance().player).get(ResourceLocation.fromNamespaceAndPath((String)"hackersandslashers", (String)"player_animations"));
                    if (associatedData instanceof ModifierLayer && !(animation = (modifierLayer = (ModifierLayer)associatedData)).isActive()) {
                        animation.replaceAnimationWithFade(AbstractFadeModifier.functionalFadeIn((int)20, (modelName, type, value) -> value), (IAnimation)Objects.requireNonNull(PlayerAnimationRegistry.getAnimation((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"hackersandslashers", (String)animationName))).playAnimation().setFirstPersonMode(FirstPersonMode.THIRD_PERSON_MODEL).setFirstPersonConfiguration(new FirstPersonConfiguration().setShowRightArm(false).setShowLeftItem(true)));
                        HackersAndSlashers.LOGGER.info("Animation '{}' played at client side for clientPlayer '{}'.", (Object)animationName, (Object)clientPlayer.getName().getString());
                    }
                }
            }
            if (!world.isClientSide() && entity instanceof Player) {
                PacketDistributor.sendToPlayersTrackingEntity((Entity)entity, (CustomPacketPayload)new PacketPlayAnimationAtPlayer(animationName, entity.getId(), false), (CustomPacketPayload[])new CustomPacketPayload[0]);
                HackersAndSlashers.LOGGER.info("The server sent a message to all clients in the ServerLevel");
            }
        }
        catch (Exception e) {
            HackersAndSlashers.LOGGER.error("Error in PlayerAnimator::playAnimation: {}", (Object)e.getMessage(), (Object)e);
        }
    }
}

