/*
 * Decompiled with CFR 0.152.
 */
package net.dndats.hackersandslashers.common.network.packets;

import dev.kosmx.playerAnim.api.firstPerson.FirstPersonConfiguration;
import dev.kosmx.playerAnim.api.firstPerson.FirstPersonMode;
import dev.kosmx.playerAnim.api.layered.IAnimation;
import dev.kosmx.playerAnim.api.layered.ModifierLayer;
import dev.kosmx.playerAnim.api.layered.modifier.AbstractFadeModifier;
import dev.kosmx.playerAnim.minecraftApi.PlayerAnimationAccess;
import dev.kosmx.playerAnim.minecraftApi.PlayerAnimationRegistry;
import java.util.Objects;
import net.dndats.hackersandslashers.HackersAndSlashers;
import net.dndats.hackersandslashers.common.network.NetworkHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;

@EventBusSubscriber(modid="hackersandslashers", bus=EventBusSubscriber.Bus.MOD)
public record PacketPlayAnimationAtPlayer(String animationName, Integer entityId, boolean override) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<PacketPlayAnimationAtPlayer> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"hackersandslashers", (String)"sync_clients_animation"));
    public static final StreamCodec<RegistryFriendlyByteBuf, PacketPlayAnimationAtPlayer> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
        buffer.writeUtf(message.animationName);
        buffer.writeInt(message.entityId.intValue());
        buffer.writeBoolean(message.override);
    }, buffer -> new PacketPlayAnimationAtPlayer(buffer.readUtf(), buffer.readInt(), buffer.readBoolean()));

    public static void handleData(PacketPlayAnimationAtPlayer message, IPayloadContext context) {
        if (context.flow().isClientbound()) {
            context.enqueueWork(() -> {
                ClientLevel level = Minecraft.getInstance().level;
                if (Minecraft.getInstance().player == null || level == null) {
                    return;
                }
                if (level.getEntity(message.entityId().intValue()) != null) {
                    AbstractClientPlayer clientPlayer;
                    IAnimation associatedData;
                    Player player = (Player)level.getEntity(message.entityId().intValue());
                    if (player == Minecraft.getInstance().player) {
                        return;
                    }
                    if (player instanceof AbstractClientPlayer && (associatedData = PlayerAnimationAccess.getPlayerAssociatedData((AbstractClientPlayer)(clientPlayer = (AbstractClientPlayer)player)).get(ResourceLocation.fromNamespaceAndPath((String)"hackersandslashers", (String)"player_animations"))) instanceof ModifierLayer) {
                        ModifierLayer modifierLayer;
                        ModifierLayer animation = modifierLayer = (ModifierLayer)associatedData;
                        animation.replaceAnimationWithFade(AbstractFadeModifier.functionalFadeIn((int)20, (modelName, type, value) -> value), (IAnimation)Objects.requireNonNull(PlayerAnimationRegistry.getAnimation((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"hackersandslashers", (String)message.animationName()))).playAnimation().setFirstPersonMode(FirstPersonMode.THIRD_PERSON_MODEL).setFirstPersonConfiguration(new FirstPersonConfiguration().setShowRightArm(false).setShowLeftItem(true)));
                        HackersAndSlashers.LOGGER.info("Animation '{}' played for all clients at player '{}'.", (Object)message.animationName(), (Object)clientPlayer.getName().getString());
                    }
                }
            }).exceptionally(e -> {
                context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                return null;
            });
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        NetworkHandler.addNetworkMessage(TYPE, STREAM_CODEC, PacketPlayAnimationAtPlayer::handleData);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

