/*
 * Decompiled with CFR 0.152.
 */
package net.dndats.hackersandslashers.common.network.packets;

import net.dndats.hackersandslashers.HackersAndSlashers;
import net.dndats.hackersandslashers.client.animations.PlayerAnimator;
import net.dndats.hackersandslashers.common.network.NetworkHandler;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;

@EventBusSubscriber(modid="hackersandslashers", bus=EventBusSubscriber.Bus.MOD)
public record PacketServerPlayAnimation(String animationName) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<PacketServerPlayAnimation> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"hackersandslashers", (String)"sync_server_animation"));
    public static final StreamCodec<RegistryFriendlyByteBuf, PacketServerPlayAnimation> STREAM_CODEC = StreamCodec.of((buffer, message) -> buffer.writeUtf(message.animationName()), buffer -> new PacketServerPlayAnimation(buffer.readUtf()));

    public static void handleData(PacketServerPlayAnimation message, IPayloadContext context) {
        if (context.flow().isServerbound()) {
            context.enqueueWork(() -> {
                if (!context.player().level().isClientSide()) {
                    PlayerAnimator.playAnimation((LevelAccessor)context.player().level(), (Entity)context.player(), message.animationName());
                    HackersAndSlashers.LOGGER.info("Now the server knows player {} played a animation.", (Object)context.player().getName().getString());
                }
            }).exceptionally(e -> {
                context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                return null;
            });
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        NetworkHandler.addNetworkMessage(TYPE, STREAM_CODEC, PacketServerPlayAnimation::handleData);
    }

    public CustomPacketPayload.Type<PacketServerPlayAnimation> type() {
        return TYPE;
    }
}

