/*
 * Decompiled with CFR 0.152.
 */
package net.dndats.hackersandslashers.common.network.packets;

import net.dndats.hackersandslashers.HackersAndSlashers;
import net.dndats.hackersandslashers.common.data.VisibilityLevelData;
import net.dndats.hackersandslashers.common.network.NetworkHandler;
import net.dndats.hackersandslashers.common.setup.ModPlayerData;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;

@EventBusSubscriber(modid="hackersandslashers", bus=EventBusSubscriber.Bus.MOD)
public record PacketSetPlayerVisibility(VisibilityLevelData data) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<PacketSetPlayerVisibility> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"hackersandslashers", (String)"player_visibility_sync"));
    public static final StreamCodec<RegistryFriendlyByteBuf, PacketSetPlayerVisibility> STREAM_CODEC = StreamCodec.of((buffer, packet) -> buffer.writeNbt((Tag)packet.data().serializeNBT((HolderLookup.Provider)buffer.registryAccess())), buffer -> {
        PacketSetPlayerVisibility message = new PacketSetPlayerVisibility(new VisibilityLevelData());
        message.data().deserializeNBT((HolderLookup.Provider)buffer.registryAccess(), buffer.readNbt());
        return message;
    });

    public static void handleData(PacketSetPlayerVisibility message, IPayloadContext context) {
        if (context.flow().isClientbound() && message.data() != null) {
            context.enqueueWork(() -> {
                ((VisibilityLevelData)context.player().getData(ModPlayerData.VISIBILITY_LEVEL)).deserializeNBT((HolderLookup.Provider)context.player().registryAccess(), message.data().serializeNBT((HolderLookup.Provider)context.player().registryAccess()));
                context.player().setData(ModPlayerData.VISIBILITY_LEVEL, (Object)message.data());
                HackersAndSlashers.LOGGER.info("Player data VISIBILITY LEVEL set to {} at {}", (Object)((VisibilityLevelData)context.player().getData(ModPlayerData.VISIBILITY_LEVEL)).getVisibilityLevel(), (Object)context.flow().getReceptionSide());
            }).exceptionally(e -> {
                context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                return null;
            });
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        NetworkHandler.addNetworkMessage(TYPE, STREAM_CODEC, PacketSetPlayerVisibility::handleData);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

