/*
 * Decompiled with CFR 0.152.
 */
package net.dndats.hackersandslashers.common.network.packets;

import java.util.Objects;
import net.dndats.hackersandslashers.client.effects.SoundEffects;
import net.dndats.hackersandslashers.common.data.IsParryingData;
import net.dndats.hackersandslashers.common.network.NetworkHandler;
import net.dndats.hackersandslashers.common.setup.ModPlayerData;
import net.dndats.hackersandslashers.utils.PlayerHelper;
import net.dndats.hackersandslashers.utils.TickScheduler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

@EventBusSubscriber(modid="hackersandslashers", bus=EventBusSubscriber.Bus.MOD)
public record PacketTriggerPlayerParry(IsParryingData data, int duration) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<PacketTriggerPlayerParry> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"hackersandslashers", (String)"player_parry_sync"));
    public static final StreamCodec<RegistryFriendlyByteBuf, PacketTriggerPlayerParry> STREAM_CODEC = StreamCodec.of((buffer, packet) -> {
        buffer.writeNbt((Tag)packet.data().serializeNBT((HolderLookup.Provider)buffer.registryAccess()));
        buffer.writeInt(packet.duration());
    }, buffer -> {
        IsParryingData data = new IsParryingData();
        data.deserializeNBT((HolderLookup.Provider)buffer.registryAccess(), Objects.requireNonNull(buffer.readNbt()));
        int duration = buffer.readInt();
        return new PacketTriggerPlayerParry(data, duration);
    });

    public static void handleData(PacketTriggerPlayerParry message, IPayloadContext context) {
        if (context.flow().isServerbound() && message.data() != null) {
            context.enqueueWork(() -> {
                ((IsParryingData)context.player().getData(ModPlayerData.IS_PARRYING)).deserializeNBT((HolderLookup.Provider)context.player().registryAccess(), message.data().serializeNBT((HolderLookup.Provider)context.player().registryAccess()));
                context.player().setData(ModPlayerData.IS_PARRYING, (Object)message.data());
                if (message.data.getIsParrying()) {
                    SoundEffects.playParrySwingSound((LivingEntity)context.player());
                    PlayerHelper.addSpeedModifier(context.player(), context.player().getMainHandItem());
                    TickScheduler.schedule(() -> {
                        PlayerHelper.removeSpeedModifier(context.player());
                        Objects.requireNonNull((IsParryingData)context.player().setData(ModPlayerData.IS_PARRYING, (Object)message.data())).setIsParrying(false);
                        ((IsParryingData)context.player().getData(ModPlayerData.IS_PARRYING)).syncData((Entity)context.player());
                    }, message.duration());
                }
            }).exceptionally(e -> {
                context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                return null;
            });
        }
        if (context.flow().isClientbound() && message.data() != null) {
            context.enqueueWork(() -> {
                LocalPlayer player = Minecraft.getInstance().player;
                if (player != null) {
                    IsParryingData parryingData = (IsParryingData)player.getData(ModPlayerData.IS_PARRYING);
                    parryingData.deserializeNBT((HolderLookup.Provider)player.registryAccess(), message.data().serializeNBT((HolderLookup.Provider)player.registryAccess()));
                    player.setData(ModPlayerData.IS_PARRYING, (Object)parryingData);
                }
            }).exceptionally(e -> {
                context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                return null;
            });
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        NetworkHandler.addNetworkMessage(TYPE, STREAM_CODEC, PacketTriggerPlayerParry::handleData);
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

