/*
 * Decompiled with CFR 0.152.
 */
package net.dndats.hackersandslashers.events;

import net.dndats.hackersandslashers.HackersAndSlashers;
import net.dndats.hackersandslashers.api.manager.CriticalManager;
import net.dndats.hackersandslashers.client.effects.SoundEffects;
import net.dndats.hackersandslashers.client.effects.VisualEffects;
import net.dndats.hackersandslashers.utils.CombatHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;

@EventBusSubscriber(modid="hackersandslashers")
public class CriticalHandler {
    @SubscribeEvent
    public static void dealCriticalHit(LivingIncomingDamageEvent event) {
        try {
            boolean isCritical = false;
            Entity entity = event.getSource().getEntity();
            if (entity instanceof Player) {
                Player player = (Player)entity;
                isCritical = CriticalManager.applyCriticalHit(event);
                if (isCritical) {
                    SoundEffects.playCriticalSound(event.getEntity());
                    VisualEffects.spawnCriticalParticle(event.getEntity().level(), event.getEntity().getX(), event.getEntity().getEyeY() + 1.0, event.getEntity().getZ(), event.getSource());
                }
            }
            CombatHelper.spawnCombatParticles(event, isCritical);
        }
        catch (Exception e) {
            HackersAndSlashers.LOGGER.error("Error while trying to apply a critical hit: {}", (Object)e.getMessage());
        }
    }
}

