/*
 * Decompiled with CFR 0.152.
 */
package net.dndats.hackersandslashers.events;

import net.dndats.hackersandslashers.HackersAndSlashers;
import net.dndats.hackersandslashers.api.combat.mechanics.parry.Parry;
import net.dndats.hackersandslashers.common.data.IsParryingData;
import net.dndats.hackersandslashers.common.setup.ModPlayerData;
import net.dndats.hackersandslashers.utils.EntityHelper;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.player.AttackEntityEvent;

@EventBusSubscriber(modid="hackersandslashers")
public class ParryHandler {
    @SubscribeEvent
    public static void updateLostHealth(LivingIncomingDamageEvent event) {
        try {
            LivingEntity livingEntity = event.getEntity();
            if (livingEntity instanceof Mob) {
                Mob mob = (Mob)livingEntity;
                if (event.getSource().getEntity() instanceof Player) {
                    EntityHelper.updateLostHealth((LivingEntity)mob);
                }
            }
        }
        catch (Exception e) {
            HackersAndSlashers.LOGGER.error("Error while trying to update entity lost health data: {}", (Object)e.getMessage());
        }
    }

    @SubscribeEvent
    public static void handleBlockBehavior(LivingIncomingDamageEvent event) {
        try {
            Parry.parryBehavior(25.0f, event);
        }
        catch (Exception e) {
            HackersAndSlashers.LOGGER.error("Error while trying to block damage: {}", (Object)e.getMessage());
        }
    }

    @SubscribeEvent
    public static void attackCancelDefensiveState(AttackEntityEvent event) {
        Player player = event.getEntity();
        IsParryingData playerData = (IsParryingData)player.getData(ModPlayerData.IS_PARRYING);
        if (playerData.getIsParrying()) {
            event.setCanceled(true);
        }
    }
}

