/*
 * Decompiled with CFR 0.152.
 */
package net.dndats.hackersandslashers.events;

import net.dndats.hackersandslashers.HackersAndSlashers;
import net.dndats.hackersandslashers.api.combat.mechanics.stealth.Stealth;
import net.dndats.hackersandslashers.utils.EntityHelper;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingChangeTargetEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

@EventBusSubscriber(modid="hackersandslashers")
public class StealthHandler {
    private static int scheduledTracker = 0;

    @SubscribeEvent
    public static void handleStealthBehavior(LivingChangeTargetEvent event) {
        try {
            Stealth.stealthBehavior(event);
        }
        catch (Exception e) {
            HackersAndSlashers.LOGGER.error("Error while trying to cancel entity target: {}", (Object)e.getMessage());
        }
    }

    @SubscribeEvent
    public static void resetMobAlert(EntityTickEvent.Pre event) {
        try {
            EntityHelper.resetMobTarget((EntityTickEvent)event);
        }
        catch (Exception e) {
            HackersAndSlashers.LOGGER.error("Error while trying to reset entity data (IS_ALERT): {}", (Object)e.getMessage());
        }
    }

    @SubscribeEvent
    public static void mobTargetTracker(PlayerTickEvent.Pre event) {
        try {
            if (!event.getEntity().level().isClientSide && ++scheduledTracker >= 20) {
                scheduledTracker = 0;
                for (Player player : event.getEntity().level().players()) {
                    Stealth.detectBeingTargeted(player);
                }
            }
        }
        catch (Exception e) {
            HackersAndSlashers.LOGGER.error("Error while trying to change player data: {}", (Object)e.getMessage());
        }
    }
}

