/*
 * Decompiled with CFR 0.152.
 */
package net.dndats.hackersandslashers.utils;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import net.dndats.hackersandslashers.client.animations.PlayerAnimator;
import net.dndats.hackersandslashers.common.network.packets.PacketServerPlayAnimation;
import net.dndats.hackersandslashers.utils.ItemHelper;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.network.PacketDistributor;

public class AnimationHelper {
    private static final Set<String> lightSwordWeapons = new HashSet<String>(Arrays.asList("dagger", "knife", "sa\u00ef", "sai"));
    private static final Set<String> mediumSwordWeapons = new HashSet<String>(Arrays.asList("sword", "cutlass", "blade"));
    private static final Set<String> heavySwordWeapons = new HashSet<String>(Arrays.asList("claymore", "longsword"));
    private static final Set<String> slimSwordWeapons = new HashSet<String>(Arrays.asList("rapier", "saber"));
    private static final Set<String> cuttingSwordWeapons = new HashSet<String>(Arrays.asList("katana", "uchigatana", "scythe"));
    private static final Set<String> smasherSwordWeapons = new HashSet<String>(Arrays.asList("hammer", "axe", "mace"));

    private static void playAnimation(Player player, String animationKey) {
        PlayerAnimator.playAnimation((LevelAccessor)player.level(), (Entity)player, animationKey);
        PacketDistributor.sendToServer((CustomPacketPayload)new PacketServerPlayAnimation(animationKey), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private static String getWeaponCategory(String mainHandName) {
        if (lightSwordWeapons.stream().anyMatch(mainHandName::contains)) {
            return "parry_light";
        }
        if (mediumSwordWeapons.stream().anyMatch(mainHandName::contains)) {
            return "parry_generic";
        }
        if (heavySwordWeapons.stream().anyMatch(mainHandName::contains)) {
            return "parry_heavy";
        }
        if (slimSwordWeapons.stream().anyMatch(mainHandName::contains)) {
            return "parry_slim";
        }
        if (cuttingSwordWeapons.stream().anyMatch(mainHandName::contains)) {
            return "parry_cutting";
        }
        if (smasherSwordWeapons.stream().anyMatch(mainHandName::contains)) {
            return "parry_smasher";
        }
        return "parry_generic";
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void playBlockAnimation(Player player) {
        if (ModList.get().isLoaded("bettercombat")) {
            String mainHandName = ItemHelper.getRegistryName(player.getMainHandItem());
            String weaponCategory = AnimationHelper.getWeaponCategory(mainHandName);
            if (player.getMainHandItem().getItem() instanceof SwordItem && player.getOffhandItem().getItem() instanceof SwordItem) {
                AnimationHelper.playAnimation(player, weaponCategory + "_dh");
            } else if (player.getMainHandItem().getItem() instanceof SwordItem) {
                AnimationHelper.playAnimation(player, weaponCategory + "_oh");
            } else {
                AnimationHelper.playAnimation(player, weaponCategory + "_oh");
            }
        } else {
            AnimationHelper.playAnimation(player, "parry_generic_oh");
        }
    }
}

