/*
 * Decompiled with CFR 0.152.
 */
package net.dndats.hackersandslashers.utils;

import net.dndats.hackersandslashers.HackersAndSlashers;
import net.dndats.hackersandslashers.client.effects.VisualEffects;
import net.dndats.hackersandslashers.utils.EntityHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.SwordItem;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;

public class CombatHelper {
    public static float dealCriticalDamage(float multiplier, LivingIncomingDamageEvent event) {
        try {
            float finalAmount = event.getOriginalAmount() * multiplier;
            event.setAmount(finalAmount);
            return finalAmount;
        }
        catch (Exception e) {
            HackersAndSlashers.LOGGER.error("Error while trying to apply a critical damage: {}", (Object)e.getMessage());
            return 0.0f;
        }
    }

    public static void stunAttackingEntity(LivingIncomingDamageEvent event) {
        try {
            Entity entity = event.getSource().getEntity();
            if (entity instanceof LivingEntity) {
                LivingEntity target = (LivingEntity)entity;
                entity = event.getEntity();
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    EntityHelper.stunTarget(target);
                }
            }
        }
        catch (Exception e) {
            HackersAndSlashers.LOGGER.error("Error while trying to stun a target: {}", (Object)e.getMessage());
        }
    }

    public static void spawnCombatParticles(LivingIncomingDamageEvent event, Boolean isCritical) {
        LivingEntity target = event.getEntity();
        Entity source = event.getSource().getEntity();
        if (!isCritical.booleanValue()) {
            if (event.getSource().getWeaponItem().getItem() instanceof SwordItem) {
                VisualEffects.spawnAttackParticles(target.level(), target.getX(), target.getY() + 0.25 + (double)(target.getBbHeight() / 2.0f), target.getZ(), (int)event.getAmount());
            } else {
                Entity entity = event.getSource().getDirectEntity();
                if (entity instanceof Projectile) {
                    Projectile projectile = (Projectile)entity;
                    VisualEffects.spawnAttackParticles(projectile.level(), projectile.getX(), projectile.getY(), projectile.getZ(), (int)event.getAmount());
                }
            }
        } else if (event.getSource().getWeaponItem().getItem() instanceof SwordItem) {
            VisualEffects.spawnAttackCritParticles(target.level(), target.getX(), target.getY() + 0.25 + (double)(target.getBbHeight() / 2.0f), target.getZ(), (int)event.getAmount());
        } else {
            Entity entity = event.getSource().getDirectEntity();
            if (entity instanceof Projectile) {
                Projectile projectile = (Projectile)entity;
                VisualEffects.spawnAttackCritParticles(projectile.level(), projectile.getX(), projectile.getY(), projectile.getZ(), (int)event.getAmount());
            }
        }
    }
}

