/*
 * Decompiled with CFR 0.152.
 */
package net.dndats.hackersandslashers.utils;

import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.dndats.hackersandslashers.HackersAndSlashers;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.util.thread.SidedThreadGroups;
import net.neoforged.neoforge.event.tick.ServerTickEvent;

@EventBusSubscriber(modid="hackersandslashers")
public class TickScheduler {
    private static final Queue<ScheduledTask> workQueue = new ConcurrentLinkedQueue<ScheduledTask>();

    public static void schedule(Runnable action, int ticks) {
        if (Thread.currentThread().getThreadGroup() == SidedThreadGroups.SERVER) {
            workQueue.add(new ScheduledTask(action, ticks));
        }
    }

    @SubscribeEvent
    public static void tick(ServerTickEvent.Post event) {
        Iterator iterator = workQueue.iterator();
        while (iterator.hasNext()) {
            ScheduledTask task = (ScheduledTask)iterator.next();
            task.decrementTicks();
            if (!task.isReady()) continue;
            HackersAndSlashers.LOGGER.debug("Executing scheduled task.");
            task.run();
            iterator.remove();
        }
    }

    private static class ScheduledTask {
        private final Runnable action;
        private int ticksRemaining;

        public ScheduledTask(Runnable action, int ticks) {
            this.action = action;
            this.ticksRemaining = ticks;
        }

        public void decrementTicks() {
            --this.ticksRemaining;
        }

        public boolean isReady() {
            return this.ticksRemaining <= 0;
        }

        public void run() {
            this.action.run();
        }
    }
}

