/*
 * Decompiled with CFR 0.152.
 */
package net.hatDealer.portalgunmod.datagen.event;

import net.hatDealer.portalgunmod.entity.ModEntities;
import net.hatDealer.portalgunmod.entity.client.ModModelLayers;
import net.hatDealer.portalgunmod.entity.client.PortalModel;
import net.hatDealer.portalgunmod.entity.client.PortalProjectileModel;
import net.hatDealer.portalgunmod.entity.client.PortalProjectileRenderer;
import net.hatDealer.portalgunmod.entity.client.PortalRenderer;
import net.hatDealer.portalgunmod.entity.client.StabilizedPortalLiquidRenderer;
import net.hatDealer.portalgunmod.entity.client.UnstablePortalLiquidRender;
import net.hatDealer.portalgunmod.items.ModItems;
import net.hatDealer.portalgunmod.items.custom.PortalgunItem;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@Mod.EventBusSubscriber(modid="portalgunmod", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ModEventBusClientEvents {
    @SubscribeEvent
    public static void registerLayer(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(ModModelLayers.PORTAL_PROJECTILE_LAYER, PortalProjectileModel::createBodyLayer);
        event.registerLayerDefinition(ModModelLayers.PORTAL_LAYER, PortalModel::createBodyLayer);
    }

    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        EntityRenderers.m_174036_((EntityType)((EntityType)ModEntities.PORTAL_PROJECTILE.get()), PortalProjectileRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)ModEntities.UNSTABLE_PORTAL_PROJECTILE.get()), UnstablePortalLiquidRender::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)ModEntities.STABLE_PORTAL_PROJECTILE.get()), StabilizedPortalLiquidRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)ModEntities.PORTAL_ENTITY.get()), PortalRenderer::new);
    }

    @SubscribeEvent
    public static void onFMLClientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            ItemProperties.register((Item)((Item)ModItems.PortalGun.get()), (ResourceLocation)new ResourceLocation("charged"), (itemStack, clientLevel, livingEntity, numberArg) -> PortalgunItem.getChargeLevel(itemStack, livingEntity, numberArg));
            ItemProperties.register((Item)((Item)ModItems.TravelPortalGun.get()), (ResourceLocation)new ResourceLocation("charged"), (itemStack, clientLevel, livingEntity, numberArg) -> PortalgunItem.getChargeLevel(itemStack, livingEntity, numberArg));
        });
    }
}

