/*
 * Decompiled with CFR 0.152.
 */
package net.hatDealer.portalgunmod.entity.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.hatDealer.portalgunmod.entity.client.ModModelLayers;
import net.hatDealer.portalgunmod.entity.client.PortalModel;
import net.hatDealer.portalgunmod.entity.custom.PortalEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Quaternionf;

@OnlyIn(value=Dist.CLIENT)
public class PortalRenderer
extends EntityRenderer<PortalEntity> {
    private final PortalModel model;
    private float size = 1.0f;
    private static final int PortalAnimSpeed = 3;
    private static final ResourceLocation PortalTexture = new ResourceLocation("portalgunmod", "textures/entity/portal-backup.png");

    public PortalRenderer(EntityRendererProvider.Context pContext) {
        super(pContext);
        this.model = new PortalModel(pContext.m_174023_(ModModelLayers.PORTAL_LAYER));
    }

    public void render(PortalEntity pEntity, float pEntityYaw, float pPartialTicks, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight) {
        if (!pEntity.isInitialised()) {
            return;
        }
        pPoseStack.m_85836_();
        this.size = 1.0f;
        if (pEntity.GetLifeTime() <= 3.0f) {
            this.size = (pEntity.GetLifeTime() + pPartialTicks) / 3.0f;
        } else if (pEntity.getRemainingTime() <= 3.0f) {
            this.size = Math.max((pEntity.getRemainingTime() - pPartialTicks) / 3.0f, 0.0f);
        }
        Quaternionf rotation = new Quaternionf();
        if (pEntity.get3dDirection().m_122411_() <= 0) {
            rotation.rotateX(4.712389f);
            pPoseStack.m_85841_(1.0f * this.size, 1.0f * this.size, 0.5f * this.size);
            pPoseStack.m_252880_(0.0f, 1.0f, 0.5f);
        } else if (pEntity.get3dDirection().m_122411_() == 1) {
            rotation.rotateX(1.5707964f);
            pPoseStack.m_85841_(1.0f * this.size, 1.0f, 0.5f * this.size);
            pPoseStack.m_252880_(0.0f, 1.0f, -0.5f);
        } else {
            pPoseStack.m_85837_(0.0, 0.5 + (0.5 - (double)(this.size / 2.0f)), 0.0);
            pPoseStack.m_85841_(1.0f * this.size, 1.0f * this.size, 1.0f * this.size);
        }
        if (pEntity.get3dDirection().m_122411_() > 1) {
            rotation.rotateY(this.degToRads(pEntityYaw));
        }
        pPackedLight = 255;
        this.f_114478_ = 0.0f;
        pPoseStack.m_252781_(rotation);
        VertexConsumer vertexconsumerUniversal = pBuffer.m_6299_(this.getRenderType(false));
        this.model.m_7695_(pPoseStack, vertexconsumerUniversal, pPackedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        pPoseStack.m_85836_();
        pPoseStack.m_85841_(0.98f, 0.98f, 0.98f);
        vertexconsumerUniversal = pBuffer.m_6299_(this.getRenderType(true));
        this.model.m_7695_(pPoseStack, vertexconsumerUniversal, pPackedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        pPoseStack.m_85849_();
        pPoseStack.m_85849_();
        super.m_7392_((Entity)pEntity, pEntityYaw, pPartialTicks, pPoseStack, pBuffer, pPackedLight);
    }

    public ResourceLocation getTextureLocation(PortalEntity pEntity) {
        return PortalTexture;
    }

    protected RenderType getRenderType(boolean universalRendering) {
        if (universalRendering) {
            return RenderType.m_110446_((ResourceLocation)PortalTexture);
        }
        return RenderType.m_173239_();
    }

    public float degToRads(float deg) {
        return (float)((double)deg * Math.PI) / 180.0f;
    }

    protected boolean shouldShowName(PortalEntity pEntity) {
        return false;
    }

    protected int getBlockLightLevel(PortalEntity pEntity, BlockPos pPos) {
        return 15;
    }
}

