/*
 * Decompiled with CFR 0.152.
 */
package net.hatDealer.portalgunmod.entity.custom;

import java.util.List;
import java.util.Objects;
import net.hatDealer.portalgunmod.entity.ModEntities;
import net.hatDealer.portalgunmod.entity.custom.PortalEntityData;
import net.hatDealer.portalgunmod.entity.custom.PortalProjectileEntity;
import net.hatDealer.portalgunmod.util.TeleportLogic;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class PortalEntity
extends Entity {
    private static final EntityDataAccessor<Direction> DIRECTION = SynchedEntityData.m_135353_(PortalEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135040_);
    private static final EntityDataAccessor<Boolean> INITIALISED = SynchedEntityData.m_135353_(PortalEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Float> SIZE = SynchedEntityData.m_135353_(PortalEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> lifeTimeLength = SynchedEntityData.m_135353_(PortalEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private int lifeTime;
    private String DestinationDimKey;
    private Vec3i DestinationPos;
    private boolean disappearAfterUse;
    private boolean canTeleport;

    public PortalEntity(EntityType<? extends Entity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_19804_.m_135381_(INITIALISED, (Object)false);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DIRECTION, (Object)Direction.SOUTH);
        this.f_19804_.m_135372_(INITIALISED, (Object)false);
        this.f_19804_.m_135372_(SIZE, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(lifeTimeLength, (Object)200);
    }

    public void init(PortalEntityData pData) {
        if (!this.m_9236_().f_46443_) {
            this.m_146884_(pData.pos);
            this.setLifeTimeLength(pData.lifeTimeLength);
            this.setDirection(pData.dir);
            this.DestinationDimKey = pData.DestinationDimKey;
            this.DestinationPos = pData.DestinationPos;
            this.disappearAfterUse = pData.disappearAfterUse;
            this.f_19804_.m_135381_(INITIALISED, (Object)true);
            this.f_19804_.m_135381_(SIZE, (Object)Float.valueOf(0.0f));
            this.canTeleport = true;
            LocalPlayer localPlayer = Minecraft.m_91087_().f_91074_;
            String DimKey = localPlayer.m_9236_().m_46472_().m_135782_().toString();
            this.checkPortalPosition(pData.DestinationPos, DimKey, pData.DestinationDimKey);
        }
    }

    public void init(PortalEntityData pData, float yRot) {
        if (!this.m_9236_().f_46443_) {
            this.m_146884_(pData.pos);
            this.setLifeTimeLength(pData.lifeTimeLength);
            this.setYRotAndDir(yRot);
            this.DestinationDimKey = pData.DestinationDimKey;
            this.DestinationPos = pData.DestinationPos;
            this.disappearAfterUse = pData.disappearAfterUse;
            this.f_19804_.m_135381_(INITIALISED, (Object)true);
            this.f_19804_.m_135381_(SIZE, (Object)Float.valueOf(1.0f));
            this.canTeleport = true;
            LocalPlayer localPlayer = Minecraft.m_91087_().f_91074_;
            String DimKey = localPlayer.m_9236_().m_46472_().m_135782_().toString();
            this.checkPortalPosition(pData.DestinationPos, DimKey, pData.DestinationDimKey);
        }
    }

    public void init(float yRot) {
        if (!this.m_9236_().f_46443_) {
            this.setYRotAndDir(yRot);
            this.setLifeTimeLength(40);
            this.DestinationDimKey = this.m_9236_().m_46472_().toString();
            this.DestinationPos = new Vec3i((int)this.m_20182_().f_82479_, (int)this.m_20182_().f_82480_, (int)this.m_20182_().f_82481_);
            this.disappearAfterUse = true;
            this.f_19804_.m_135381_(INITIALISED, (Object)true);
            this.f_19804_.m_135381_(SIZE, (Object)Float.valueOf(1.0f));
            this.canTeleport = false;
        }
    }

    public boolean isInitialised() {
        return (Boolean)this.f_19804_.m_135370_(INITIALISED);
    }

    public void m_8119_() {
        super.m_8119_();
        this.m_146871_();
        if (!this.m_9236_().f_46443_) {
            if (this.lifeTime == this.getLifeTimeLength()) {
                this.despawnPortal();
            }
            this.checkCollisions();
        }
        if (this.m_9236_().f_46443_ && this.f_19796_.m_188503_(5) == 1) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123789_, this.m_20185_() + (double)(this.f_19796_.m_188501_() * 2.0f) - 1.0, this.m_20186_() + (double)(this.f_19796_.m_188501_() * 4.0f) - 2.0, this.m_20189_() + (double)(this.f_19796_.m_188501_() * 2.0f) - 1.0, (double)this.f_19796_.m_188501_() * 0.4 - 0.2, (double)this.f_19796_.m_188501_() * 0.4 - 0.2, (double)this.f_19796_.m_188501_() * 0.4 - 0.2);
        }
        ++this.lifeTime;
    }

    public float GetLifeTime() {
        return this.lifeTime;
    }

    public float getRemainingTime() {
        return this.getLifeTimeLength() - this.lifeTime;
    }

    public float getSize() {
        return PortalEntity.unlinearyInterpolate(0.001f, 1.0f, ((Float)this.f_19804_.m_135370_(SIZE)).floatValue());
    }

    public float getRawSize() {
        return ((Float)this.f_19804_.m_135370_(SIZE)).floatValue();
    }

    public static float unlinearyInterpolate(float a, float b, float t) {
        double logA = Math.log(a);
        double logB = Math.log(b);
        return (float)Math.exp(logA + (logB - logA) * (double)t);
    }

    public void IncrementSize(float value) {
        this.f_19804_.m_135381_(SIZE, (Object)Float.valueOf(Math.min(this.getRawSize() + value, 1.0f)));
    }

    public void DecrementSize(float value) {
        this.f_19804_.m_135381_(SIZE, (Object)Float.valueOf(Math.max(this.getRawSize() - value, 0.0f)));
    }

    public int getLifeTimeLength() {
        return (Integer)this.f_19804_.m_135370_(lifeTimeLength);
    }

    public void setLifeTimeLength(int time) {
        this.f_19804_.m_135381_(lifeTimeLength, (Object)time);
    }

    public void m_7822_(byte pId) {
        if (pId == 32) {
            if (this.m_9236_().f_46443_) {
                // empty if block
            }
        } else {
            super.m_7822_(pId);
        }
    }

    public boolean m_6087_() {
        return true;
    }

    protected void setDirection(Direction pFacingDirection) {
        if (!this.m_9236_().f_46443_) {
            this.f_19804_.m_135381_(DIRECTION, (Object)pFacingDirection);
            this.m_146922_(pFacingDirection.m_122435_());
        }
    }

    protected void setYRotAndDir(float yRot) {
        if (!this.m_9236_().f_46443_) {
            this.m_146922_(yRot);
            this.f_19804_.m_135381_(DIRECTION, (Object)Direction.m_122364_((double)yRot));
        }
    }

    public Direction get3dDirection() {
        return (Direction)this.f_19804_.m_135370_(DIRECTION);
    }

    @NotNull
    public EntityDimensions m_6972_(Pose pPose) {
        return EntityDimensions.m_20398_((float)1.0f, (float)2.0f);
    }

    public void m_7378_(CompoundTag pCompound) {
        Vec3 pos = new Vec3((double)pCompound.m_128457_("TileX"), (double)pCompound.m_128457_("TileY"), (double)pCompound.m_128457_("TileZ"));
        this.m_146884_(pos);
        this.setDirection(Direction.m_122364_((double)this.m_146908_()));
        this.f_19804_.m_135381_(INITIALISED, (Object)pCompound.m_128471_("INITIALISED"));
        this.f_19804_.m_135381_(SIZE, (Object)Float.valueOf(pCompound.m_128457_("SIZE")));
        this.DestinationDimKey = pCompound.m_128461_("DestinationDimKey");
        int x = pCompound.m_128451_("DestinationPosX");
        int y = pCompound.m_128451_("DestinationPosY");
        int z = pCompound.m_128451_("DestinationPosZ");
        this.DestinationPos = new Vec3i(x, y, z);
        this.lifeTime = pCompound.m_128451_("lifeTime");
        this.setLifeTimeLength(pCompound.m_128451_("lifeTimeLength"));
        this.canTeleport = pCompound.m_128471_("canTeleport");
        this.disappearAfterUse = pCompound.m_128471_("disappearAfterUse");
    }

    public void m_7380_(CompoundTag pCompound) {
        Vec3 pos = this.m_20182_();
        pCompound.m_128347_("TileX", pos.m_7096_());
        pCompound.m_128347_("TileY", pos.m_7098_());
        pCompound.m_128347_("TileZ", pos.m_7094_());
        pCompound.m_128379_("INITIALISED", ((Boolean)this.m_20088_().m_135370_(INITIALISED)).booleanValue());
        pCompound.m_128350_("SIZE", ((Float)this.m_20088_().m_135370_(SIZE)).floatValue());
        pCompound.m_128359_("DestinationDimKey", this.DestinationDimKey);
        pCompound.m_128405_("DestinationPosX", this.DestinationPos.m_123341_());
        pCompound.m_128405_("DestinationPosY", this.DestinationPos.m_123342_());
        pCompound.m_128405_("DestinationPosZ", this.DestinationPos.m_123343_());
        pCompound.m_128405_("lifeTime", this.lifeTime);
        pCompound.m_128405_("lifeTimeLength", this.getLifeTimeLength());
        pCompound.m_128379_("canTeleport", this.canTeleport);
        pCompound.m_128379_("disappearAfterUse", this.disappearAfterUse);
    }

    public void playPlacementSound() {
        this.m_9236_().m_6263_((Player)null, (double)this.m_146903_(), (double)this.m_146904_(), (double)this.m_146907_(), SoundEvents.f_11739_, SoundSource.PLAYERS, 0.1f, 0.7f);
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        this.m_9236_().m_6263_((Player)null, (double)this.m_146903_(), (double)this.m_146904_(), (double)this.m_146907_(), SoundEvents.f_11859_, SoundSource.PLAYERS, 1.0f, 0.87f);
        return true;
    }

    public boolean m_7337_(Entity pEntity) {
        return false;
    }

    public boolean m_5829_() {
        return false;
    }

    public boolean isPortalOnSide() {
        int side = this.get3dDirection().m_122411_();
        return side > 1;
    }

    protected void checkCollisions() {
        if (!this.m_9236_().f_46443_ && this.canTeleport) {
            List collisionList = this.m_9236_().m_6249_((Entity)this, this.m_20191_(), EntitySelector.f_20403_);
            MinecraftServer server = this.m_20194_();
            assert (server != null);
            ResourceKey dimensionKey = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(this.DestinationDimKey));
            ServerLevel dim = server.m_129880_(dimensionKey);
            for (Entity entity : collisionList) {
                if (entity.getClass() == PortalEntity.class || entity.getClass() == PortalProjectileEntity.class || !entity.m_6072_()) continue;
                if (dim == null) {
                    this.despawnPortal();
                    return;
                }
                Vec3 pos = this.m_20182_();
                BlockPos teleportPos = new BlockPos(this.DestinationPos);
                teleportPos = TeleportLogic.FindViablePositionFor(dim, teleportPos);
                entity.m_183634_();
                TeleportLogic.TeleportEntity(entity, dim, teleportPos);
                PortalEntity portal = (PortalEntity)((EntityType)ModEntities.PORTAL_ENTITY.get()).m_262496_(this.m_20194_().m_129880_(entity.m_9236_().m_46472_()), entity.m_20183_(), MobSpawnType.TRIGGERED);
                portal.init(this.m_146908_());
                this.m_9236_().m_220400_((Entity)this, GameEvent.f_157810_, portal.m_20182_());
                if (!this.disappearAfterUse) continue;
                this.despawnPortal();
            }
        }
    }

    public void spawnPortalOnOtherSide(PortalEntityData pData) {
        if (!this.m_9236_().f_46443_) {
            PortalEntity otherPortalEntity = (PortalEntity)((EntityType)ModEntities.PORTAL_ENTITY.get()).m_262496_(this.m_20194_().m_129880_(this.m_9236_().m_46472_()), BlockPos.f_121853_, MobSpawnType.TRIGGERED);
            otherPortalEntity.init(pData);
            otherPortalEntity.playPlacementSound();
            float f = 0.5f;
            float f1 = 1.0f;
            otherPortalEntity.m_20011_(new AABB(pData.pos.f_82479_ - (double)f, pData.pos.f_82480_ - (double)f1, pData.pos.f_82481_ - (double)f, pData.pos.f_82479_ + (double)f, pData.pos.f_82480_ + (double)f1, pData.pos.f_82481_ + (double)f));
            this.m_9236_().m_220400_((Entity)otherPortalEntity, GameEvent.f_157810_, otherPortalEntity.m_20182_());
        }
    }

    public void despawnPortal() {
        this.m_9236_().m_6263_((Player)null, (double)this.m_146903_(), (double)this.m_146904_(), (double)this.m_146907_(), SoundEvents.f_11852_, SoundSource.PLAYERS, 0.5f, 0.6f);
        this.m_146870_();
    }

    public void despawnPortalViolent() {
        this.m_9236_().m_6263_((Player)null, (double)this.m_146903_(), (double)this.m_146904_(), (double)this.m_146907_(), SoundEvents.f_11852_, SoundSource.PLAYERS, 0.5f, 0.6f);
        this.m_9236_().m_6263_((Player)null, (double)this.m_146903_(), (double)this.m_146904_(), (double)this.m_146907_(), SoundEvents.f_215672_, SoundSource.PLAYERS, 0.5f, 0.3f);
        this.m_146870_();
    }

    private void checkPortalPosition(Vec3i OutPos, String dimIn, String dimOut) {
        if (!Objects.equals(dimIn, dimOut)) {
            return;
        }
        if (OutPos.m_203193_((Position)this.m_20182_()) < 4.0) {
            this.despawnPortalViolent();
        }
    }
}

