/*
 * Decompiled with CFR 0.152.
 */
package net.hatDealer.portalgunmod.entity.custom;

import net.hatDealer.portalgunmod.entity.ModEntities;
import net.hatDealer.portalgunmod.entity.custom.PortalEntity;
import net.hatDealer.portalgunmod.entity.custom.PortalEntityData;
import net.hatDealer.portalgunmod.items.ModItems;
import net.hatDealer.portalgunmod.util.TeleportLogic;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class PortalProjectileEntity
extends AbstractArrow {
    private int portalHeight = 2;
    private int portalWidth = 1;
    private int portalTime = 200;
    private String DestinationDimKey = "minecraft:overworld";
    private Vec3i DestinationPos = new Vec3i(150, 150, 150);
    private int ProjectileLifeLength = 300;
    private boolean disappearAfterUse = false;
    Vec3 SpawnPos;
    private int maxDistance = 7;

    public PortalProjectileEntity(EntityType<PortalProjectileEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public PortalProjectileEntity(double x, double y, double z, Level pLevel) {
        super((EntityType)ModEntities.PORTAL_PROJECTILE.get(), x, y, z, pLevel);
    }

    public PortalProjectileEntity(LivingEntity shooter, Level pLevel, String DestinationDimKey, Vec3i DestinationPos, int portalTime, boolean disappearAfterUse) {
        super((EntityType)ModEntities.PORTAL_PROJECTILE.get(), shooter, pLevel);
        this.DestinationDimKey = DestinationDimKey;
        this.DestinationPos = DestinationPos;
        this.portalTime = portalTime;
        this.disappearAfterUse = disappearAfterUse;
        this.SpawnPos = this.m_20182_();
    }

    protected void m_8060_(BlockHitResult pResult) {
        if (!this.m_9236_().f_46443_) {
            this.spawnPortal(pResult.m_82450_(), pResult.m_82434_(), pResult.m_82434_().m_122435_());
        }
    }

    public void spawnPortal(Vec3 pPos, Direction pDirection, float yRot) {
        if (!this.m_9236_().f_46443_) {
            Vec3 hitPos = new Vec3(pPos.f_82479_, pPos.f_82480_ - 1.0, pPos.f_82481_);
            Vec3 inFrontOfPortal = hitPos.m_82549_(Vec3.m_82512_((Vec3i)pDirection.m_122436_()).m_82490_(0.25));
            BlockPos portalFeetPos = new BlockPos((int)inFrontOfPortal.f_82479_, (int)inFrontOfPortal.f_82480_, (int)inFrontOfPortal.f_82481_);
            if (!this.m_9236_().m_8055_(portalFeetPos).m_60795_() && !this.m_9236_().m_8055_(portalFeetPos.m_7494_()).m_280296_()) {
                hitPos = pDirection.m_122411_() <= 1 ? new Vec3(hitPos.f_82479_, (double)portalFeetPos.m_123342_(), hitPos.f_82481_) : new Vec3(hitPos.f_82479_, (double)(portalFeetPos.m_123342_() + 1), hitPos.f_82481_);
            }
            PortalEntityData pData = new PortalEntityData(hitPos, this.portalTime, pDirection, this.disappearAfterUse, this.DestinationDimKey, this.DestinationPos);
            PortalEntity portalentity = (PortalEntity)((EntityType)ModEntities.PORTAL_ENTITY.get()).m_262496_(this.m_20194_().m_129880_(this.m_9236_().m_46472_()), BlockPos.f_121853_, MobSpawnType.TRIGGERED);
            if (pDirection == Direction.DOWN || pDirection == Direction.UP) {
                portalentity.init(pData);
            } else {
                portalentity.init(pData, yRot);
            }
            this.m_9236_().m_7605_((Entity)this, (byte)0);
            portalentity.playPlacementSound();
            this.m_9236_().m_220400_(this.m_19749_(), GameEvent.f_157810_, portalentity.m_20182_());
            this.m_146870_();
        }
    }

    protected ItemStack m_7941_() {
        return new ItemStack((ItemLike)ModItems.PortalProjectileItem.get());
    }

    protected float m_6882_() {
        return 1.0f;
    }

    public boolean m_20068_() {
        return true;
    }

    protected void m_5790_(EntityHitResult pResult) {
        if (pResult.m_82443_().getClass() == PortalEntity.class || pResult.m_82443_().getClass() == ((Object)((Object)this)).getClass() || !pResult.m_82443_().m_6072_()) {
            return;
        }
        if (this.m_9236_().f_46443_) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123746_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
            return;
        }
        ServerLevel dim = pResult.m_82443_().m_20194_().m_129880_(pResult.m_82443_().m_9236_().m_46472_());
        BlockPos pos = TeleportLogic.FindViablePositionFor(dim, this.m_20097_());
        TeleportLogic.TeleportEntity(pResult.m_82443_(), dim, pos);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().f_46443_ && !this.f_36703_) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123760_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
        }
        if (!this.m_9236_().f_46443_) {
            --this.ProjectileLifeLength;
            if (this.ProjectileLifeLength <= 0) {
                this.m_146870_();
            }
            if (this.SpawnPos.m_82554_(this.m_20182_()) >= (double)this.maxDistance) {
                this.spawnPortal(this.m_20182_(), Direction.m_122366_((double)this.m_20182_().m_82546_((Vec3)this.SpawnPos).f_82479_, (double)this.m_20182_().m_82546_((Vec3)this.SpawnPos).f_82480_, (double)this.m_20182_().m_82546_((Vec3)this.SpawnPos).f_82481_), this.m_146908_() + 180.0f);
            }
        }
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.portalHeight = pCompound.m_128451_("portalHeight");
        this.portalWidth = pCompound.m_128451_("portalWidth");
        this.portalTime = pCompound.m_128451_("portalTime");
        this.DestinationDimKey = pCompound.m_128461_("DestinationDimKey");
        int x = pCompound.m_128451_("DestinationPosX");
        int y = pCompound.m_128451_("DestinationPosY");
        int z = pCompound.m_128451_("DestinationPosZ");
        this.DestinationPos = new Vec3i(x, y, z);
        this.ProjectileLifeLength = pCompound.m_128451_("portalLife");
        this.disappearAfterUse = pCompound.m_128471_("pDisappear");
        this.SpawnPos = new Vec3(pCompound.m_128459_("sPosX"), pCompound.m_128459_("sPosY"), pCompound.m_128459_("sPosZ"));
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("portalHeight", this.portalHeight);
        pCompound.m_128405_("portalWidth", this.portalWidth);
        pCompound.m_128405_("portalTime", this.portalTime);
        pCompound.m_128359_("DestinationDimKey", this.DestinationDimKey);
        pCompound.m_128405_("DestinationPosX", this.DestinationPos.m_123341_());
        pCompound.m_128405_("DestinationPosY", this.DestinationPos.m_123342_());
        pCompound.m_128405_("DestinationPosZ", this.DestinationPos.m_123343_());
        pCompound.m_128405_("portalLife", this.ProjectileLifeLength);
        pCompound.m_128379_("pDisappear", this.disappearAfterUse);
        pCompound.m_128347_("sPosX", this.SpawnPos.f_82479_);
        pCompound.m_128347_("sPosY", this.SpawnPos.f_82480_);
        pCompound.m_128347_("sPosZ", this.SpawnPos.f_82481_);
    }

    public boolean m_6000_(double pX, double pY, double pZ) {
        return true;
    }
}

