/*
 * Decompiled with CFR 0.152.
 */
package net.hatDealer.portalgunmod.items.custom;

import java.util.function.Predicate;
import net.hatDealer.portalgunmod.items.ModItems;
import net.hatDealer.portalgunmod.util.ModTags;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeHooks;
import org.jetbrains.annotations.NotNull;

public abstract class PortalgunItem
extends ProjectileWeaponItem {
    public static final Predicate<ItemStack> PORTAL_ONLY = itemStack -> itemStack.m_204117_(ModTags.Items.PORTAL_AMMO);
    public static final Predicate<ItemStack> STABLE_ONLY = itemStack -> itemStack.m_150930_((Item)ModItems.PortalProjectileItem.get());

    public PortalgunItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public int getPortalLifetime() {
        return 180;
    }

    public boolean getPortalDisappear() {
        return true;
    }

    public int m_6615_() {
        return 40;
    }

    public static float getChargeLevel(ItemStack pStack, LivingEntity pEntity, int speed) {
        if (!(pEntity instanceof Player)) {
            return 0.0f;
        }
        Player player = (Player)pEntity;
        ItemStack ammo = PortalgunItem.getPortalGunProjectile(pStack, player);
        if (ammo.m_41619_()) {
            return 0.0f;
        }
        if (ammo.m_41720_() == ModItems.PortalProjectileItem.get()) {
            return 1.0f;
        }
        if (ammo.m_41720_() == ModItems.PortalProjectileUnstableItem.get()) {
            return 2.0f;
        }
        return 0.0f;
    }

    public void m_5551_(ItemStack pStack, Level pLevel, LivingEntity pEntityLiving, int pTimeLeft) {
    }

    public void m_6883_(ItemStack pStack, Level pLevel, Entity pEntity, int pSlotId, boolean pIsSelected) {
        super.m_6883_(pStack, pLevel, pEntity, pSlotId, pIsSelected);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pHand) {
        ItemStack PortalGun = pPlayer.m_21120_(pHand);
        boolean infinite_ammo = pPlayer.m_150110_().f_35937_;
        ItemStack itemProjectile = PortalgunItem.getPortalGunProjectile(PortalGun, pPlayer);
        if (!itemProjectile.m_41619_() || infinite_ammo) {
            if (itemProjectile.m_41619_()) {
                itemProjectile = new ItemStack((ItemLike)ModItems.PortalProjectileItem.get());
            }
            if (!pLevel.f_46443_) {
                ArrowItem arrowitem = (ArrowItem)itemProjectile.m_41720_();
                this.Shoot(arrowitem, pPlayer, pLevel, itemProjectile, PortalGun);
            }
            pLevel.m_6263_((Player)null, pPlayer.m_20185_(), pPlayer.m_20186_(), pPlayer.m_20189_(), SoundEvents.f_11824_, SoundSource.PLAYERS, 1.0f, 1.0f / (pLevel.m_213780_().m_188501_() * 0.4f + 1.2f) + 1.0f);
            if (!infinite_ammo) {
                itemProjectile.m_41774_(1);
                if (itemProjectile.m_41619_()) {
                    pPlayer.m_150109_().m_36057_(itemProjectile);
                }
            }
            return InteractionResultHolder.m_19090_((Object)pPlayer.m_21120_(pHand));
        }
        return InteractionResultHolder.m_19100_((Object)pPlayer.m_21120_(pHand));
    }

    protected abstract void Shoot(ArrowItem var1, Player var2, Level var3, ItemStack var4, ItemStack var5);

    @NotNull
    public Predicate<ItemStack> m_6437_() {
        return PORTAL_ONLY;
    }

    public static ItemStack getPortalGunProjectile(ItemStack pShootable, Player pPlayer) {
        ItemStack itemstack1;
        int i;
        if (!(pShootable.m_41720_() instanceof PortalgunItem)) {
            return ItemStack.f_41583_;
        }
        CompoundTag PortalGunNBT = pShootable.m_41784_();
        boolean preferStableAmmo = PortalGunNBT.m_128441_("stableAmmo") ? PortalGunNBT.m_128471_("stableAmmo") : true;
        Item PreferredAmmo = preferStableAmmo ? (Item)ModItems.PortalProjectileItem.get() : (Item)ModItems.PortalProjectileUnstableItem.get();
        Predicate predicate = ((ProjectileWeaponItem)pShootable.m_41720_()).m_6442_();
        ItemStack itemstack = ProjectileWeaponItem.m_43010_((LivingEntity)pPlayer, (Predicate)predicate);
        if (!itemstack.m_41619_()) {
            return ForgeHooks.getProjectile((LivingEntity)pPlayer, (ItemStack)pShootable, (ItemStack)itemstack);
        }
        predicate = ((ProjectileWeaponItem)pShootable.m_41720_()).m_6437_();
        for (i = 0; i < pPlayer.m_150109_().m_6643_(); ++i) {
            itemstack1 = pPlayer.m_150109_().m_8020_(i);
            if (PreferredAmmo != itemstack1.m_41720_()) continue;
            return ForgeHooks.getProjectile((LivingEntity)pPlayer, (ItemStack)pShootable, (ItemStack)itemstack1);
        }
        for (i = 0; i < pPlayer.m_150109_().m_6643_(); ++i) {
            itemstack1 = pPlayer.m_150109_().m_8020_(i);
            if (!predicate.test(itemstack1)) continue;
            return ForgeHooks.getProjectile((LivingEntity)pPlayer, (ItemStack)pShootable, (ItemStack)itemstack1);
        }
        return ForgeHooks.getProjectile((LivingEntity)pPlayer, (ItemStack)pShootable, (ItemStack)(pPlayer.m_150110_().f_35937_ ? new ItemStack((ItemLike)ModItems.PortalProjectileItem.get()) : ItemStack.f_41583_));
    }

    public boolean m_5812_(ItemStack stack) {
        return false;
    }

    public boolean m_41463_(ItemStack stack) {
        return true;
    }

    @NotNull
    public UseAnim m_6164_(ItemStack pStack) {
        return UseAnim.CROSSBOW;
    }

    public int m_8105_(ItemStack pStack) {
        return 100;
    }
}

