/*
 * Decompiled with CFR 0.152.
 */
package net.hatDealer.portalgunmod.networking;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import net.hatDealer.portalgunmod.screens.TravelPortalGunScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;

public class DimensionIDsResponsePacket {
    private final Set<ResourceKey<Level>> dimensions;

    public DimensionIDsResponsePacket(Set<ResourceKey<Level>> dimensions) {
        this.dimensions = dimensions;
    }

    public DimensionIDsResponsePacket(FriendlyByteBuf buffer) {
        this.dimensions = new HashSet<ResourceKey<Level>>();
        int size = buffer.m_130242_();
        for (int i = 0; i < size; ++i) {
            ResourceLocation dimensionId = buffer.m_130281_();
            ResourceKey dimensionKey = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)dimensionId);
            this.dimensions.add((ResourceKey<Level>)dimensionKey);
        }
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130130_(this.dimensions.size());
        for (ResourceKey<Level> dimension : this.dimensions) {
            buffer.m_130085_(dimension.m_135782_());
        }
    }

    public static DimensionIDsResponsePacket decode(FriendlyByteBuf buffer) {
        return new DimensionIDsResponsePacket(buffer);
    }

    public static void handle(DimensionIDsResponsePacket packet, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            Screen patt1834$temp = Minecraft.m_91087_().f_91080_;
            if (patt1834$temp instanceof TravelPortalGunScreen) {
                TravelPortalGunScreen s = (TravelPortalGunScreen)patt1834$temp;
                for (ResourceKey<Level> dimensionKey : packet.dimensions) {
                    s.DimIDs.add(dimensionKey.m_135782_().toString());
                }
            }
        });
        context.setPacketHandled(true);
    }
}

