/*
 * Decompiled with CFR 0.152.
 */
package net.hatDealer.portalgunmod.util;

import java.util.Random;
import java.util.function.Function;
import net.hatDealer.portalgunmod.entity.ModEntities;
import net.hatDealer.portalgunmod.entity.custom.PortalEntity;
import net.hatDealer.portalgunmod.entity.custom.PortalEntityData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.portal.PortalInfo;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.ITeleporter;

public class TeleportLogic {
    private TeleportLogic() {
    }

    public static BlockPos FindViablePositionFor(ServerLevel dim, BlockPos OriginalPos) {
        BlockPos bPosFirst = new BlockPos((Vec3i)OriginalPos);
        do {
            if (dim.m_8055_(bPosFirst.m_7495_()).m_60795_() || !dim.m_8055_(bPosFirst).m_60795_() || !dim.m_8055_(bPosFirst.m_7494_()).m_60795_()) continue;
            return bPosFirst;
        } while ((dim.m_8055_(bPosFirst.m_7495_()).m_60795_() || dim.m_8055_(bPosFirst).m_60795_() || dim.m_8055_(bPosFirst.m_7494_()).m_60795_()) && (bPosFirst = bPosFirst.m_7495_()).m_123342_() > -64);
        for (BlockPos bPos : BlockPos.m_121935_((BlockPos)OriginalPos, (int)16, (Direction)Direction.EAST, (Direction)Direction.SOUTH)) {
            bPos = bPos.m_175288_(127);
            while (bPos.m_123342_() > 32) {
                if (!dim.m_8055_(bPos.m_7495_()).m_60795_() && dim.m_8055_(bPos).m_60795_() && dim.m_8055_(bPos.m_7494_()).m_60795_()) {
                    return bPos;
                }
                bPos = bPos.m_7495_();
            }
        }
        System.out.println("No valid position found for the portal gun!");
        return OriginalPos;
    }

    public static void TeleportEntity(Entity entity, ServerLevel dim, final BlockPos pos) {
        entity.changeDimension(dim, new ITeleporter(){

            public PortalInfo getPortalInfo(Entity entity, ServerLevel destWorld, Function<ServerLevel, PortalInfo> defaultPortalInfo) {
                return new PortalInfo(pos.m_252807_(), entity.m_20184_(), entity.m_146908_() - 180.0f, entity.m_146909_());
            }

            public boolean playTeleportSound(ServerPlayer player, ServerLevel sourceWorld, ServerLevel destWorld) {
                return false;
            }
        });
        entity.m_6034_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
    }

    public static void ChaoticExplosion(Vec3 pos, Level level, Direction pDirection, float yRot, Entity entity) {
        if (!level.f_46443_) {
            Random random = new Random();
            int randomResult = random.nextInt(0, 10);
            switch (randomResult) {
                case 0: {
                    String DimToken = TeleportLogic.GetRandomVanillaDimToken();
                    TeleportLogic.CreateRandomPortal(pos, DimToken, level, pDirection, yRot, entity, 8000);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    level.m_255391_(entity, pos.m_7096_(), pos.m_7098_(), pos.m_7094_(), (float)random.nextInt(3, 10), true, Level.ExplosionInteraction.BLOCK);
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    TeleportLogic.PlaceCubeOfBlocks(level, new BlockPos((int)pos.f_82479_, (int)pos.f_82480_, (int)pos.f_82481_), random.nextInt(4, 8), TeleportLogic.GetRandomCommonBlock().m_49966_(), true);
                    break;
                }
                case 7: 
                case 8: {
                    Block liquidBlock = random.nextBoolean() ? Blocks.f_49990_ : Blocks.f_49991_;
                    TeleportLogic.PlaceCubeOfBlocks(level, new BlockPos((int)pos.f_82479_, (int)pos.f_82480_, (int)pos.f_82481_), random.nextInt(3, 5), liquidBlock.m_49966_(), false);
                    break;
                }
                case 9: {
                    level.m_7731_(new BlockPos((int)pos.f_82479_, (int)pos.f_82480_, (int)pos.f_82481_), TeleportLogic.GetRandomRareBlock().m_49966_(), 3);
                }
            }
        }
    }

    public static void CreateRandomPortal(Vec3 pos, String DimToken, Level level, Direction pDirection, float yRot, Entity entity, int teleportSpread) {
        if (!level.f_46443_) {
            Random random = new Random();
            pos = pos.m_82492_(0.0, 1.0, 0.0);
            BlockPos portalFeetPos = new BlockPos((int)pos.f_82479_, (int)pos.f_82480_, (int)pos.f_82481_);
            if (!level.m_8055_(portalFeetPos).m_60795_() && !level.m_8055_(portalFeetPos.m_7494_()).m_280296_()) {
                pos = pDirection.m_122411_() <= 1 ? new Vec3(pos.f_82479_, (double)portalFeetPos.m_123342_(), pos.f_82481_) : new Vec3(pos.f_82479_, (double)(portalFeetPos.m_123342_() + 1), pos.f_82481_);
            }
            Vec3 NewRandomPos = pos.m_82549_(new Vec3((double)random.nextInt(-teleportSpread / 2, teleportSpread / 2), 0.0, (double)random.nextInt(-teleportSpread / 2, teleportSpread / 2)));
            PortalEntityData pData = new PortalEntityData(pos, random.nextInt(100, 200), pDirection, random.nextBoolean(), DimToken, new Vec3i((int)NewRandomPos.f_82479_, (int)NewRandomPos.f_82480_, (int)NewRandomPos.f_82481_));
            PortalEntity portalentity = (PortalEntity)((EntityType)ModEntities.PORTAL_ENTITY.get()).m_262496_(level.m_7654_().m_129880_(level.m_46472_()), BlockPos.f_121853_, MobSpawnType.TRIGGERED);
            if (pDirection == Direction.DOWN || pDirection == Direction.UP) {
                portalentity.init(pData);
            } else {
                portalentity.init(pData, yRot);
            }
            portalentity.playPlacementSound();
            level.m_220400_(entity, GameEvent.f_157810_, portalentity.m_20182_());
        }
    }

    public static String GetRandomVanillaDimToken() {
        Random random = new Random();
        int dimIndex = random.nextInt(3);
        String[] DimTokens = new String[]{"minecraft:overworld", "minecraft:the_nether", "minecraft:the_end"};
        return DimTokens[dimIndex];
    }

    public static Block GetRandomRareBlock() {
        Random random = new Random();
        Block[] BlockList = new Block[]{Blocks.f_50268_, Blocks.f_50080_, Blocks.f_50322_, Blocks.f_50721_, Blocks.f_50090_, Blocks.f_50056_, Blocks.f_50273_, Blocks.f_50491_, Blocks.f_50312_, Blocks.f_50259_, Blocks.f_50722_, Blocks.f_50333_, Blocks.f_50569_, Blocks.f_50228_, Blocks.f_50334_, Blocks.f_50122_, Blocks.f_50074_, Blocks.f_50264_, Blocks.f_260630_, Blocks.f_152504_, Blocks.f_50039_, Blocks.f_152477_, Blocks.f_152478_};
        int blockIndex = random.nextInt(BlockList.length);
        return BlockList[blockIndex];
    }

    public static Block GetRandomCommonBlock() {
        Random random = new Random();
        Block[] BlockList = new Block[]{Blocks.f_50493_, Blocks.f_50228_, Blocks.f_50334_, Blocks.f_50122_, Blocks.f_49992_, Blocks.f_49994_, Blocks.f_50050_, Blocks.f_50259_, Blocks.f_50134_, Blocks.f_49993_, Blocks.f_50352_, Blocks.f_50058_, Blocks.f_50137_, Blocks.f_50652_, Blocks.f_50069_, Blocks.f_152550_, Blocks.f_152551_};
        int blockIndex = random.nextInt(BlockList.length);
        return BlockList[blockIndex];
    }

    public static void PlaceCubeOfBlocks(Level level, BlockPos middlePos, int size, BlockState blockState, boolean destroyBlocks) {
        for (int x = -size / 2; x < size / 2; ++x) {
            for (int y = -size / 2; y < size / 2; ++y) {
                for (int z = -size / 2; z < size / 2; ++z) {
                    BlockPos currentPos = middlePos.m_7918_(x, y, z);
                    if (destroyBlocks) {
                        level.m_7731_(currentPos, blockState, 3);
                        continue;
                    }
                    if (!level.m_8055_(currentPos).m_60795_()) continue;
                    level.m_7731_(currentPos, blockState, 3);
                }
            }
        }
    }
}

