/*
 * Decompiled with CFR 0.152.
 */
package com.dreu.traversableleaves.config;

import com.dreu.traversableleaves.TraversableLeaves;
import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.toml.TomlParser;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class TLConfig {
    public static boolean configNeedsRepair = false;
    static final String fileName = "config/traversable_leaves/general.toml";
    static final String defaultConfig = "#To reset this config to default, delete this file and rerun the game.\n#Movement Speed penalty while traversing leaves, 0 = no penalty (Range : 0 - 100)\nSpeedPenalty = 27 #Default: 27\n\n#Whether Armor value reduces movement penalty\nArmorBonus = true #Defualt: true\n\n#List of leaves (false = Blacklist)\nLeavesWhitelist = false #Default: true\nTraversable=[\n\n]\n\n#List of Entities that can/cannot traverse leaves (false = Blacklist)\nEntityWhitelist = false #Default: false\nEntities=[\n \"minecraft:sheep\",\n \"minecraft:pig\",\n \"minecraft:cow\",\n \"minecraft:chicken\",\n \"minecraft:donkey\",\n \"minecraft:llama\",\n \"minecraft:trader_llama\",\n \"minecraft:mule\",\n \"minecraft:frog\",\n \"minecraft:goat\",\n \"minecraft:mooshroom\",\n \"minecraft:turtle\"\n]\n";
    private static final Config CONFIG = TLConfig.parseFileOrDefault();
    private static final Config DEFAULT_CONFIG = new TomlParser().parse("#To reset this config to default, delete this file and rerun the game.\n#Movement Speed penalty while traversing leaves, 0 = no penalty (Range : 0 - 100)\nSpeedPenalty = 27 #Default: 27\n\n#Whether Armor value reduces movement penalty\nArmorBonus = true #Defualt: true\n\n#List of leaves (false = Blacklist)\nLeavesWhitelist = false #Default: true\nTraversable=[\n\n]\n\n#List of Entities that can/cannot traverse leaves (false = Blacklist)\nEntityWhitelist = false #Default: false\nEntities=[\n \"minecraft:sheep\",\n \"minecraft:pig\",\n \"minecraft:cow\",\n \"minecraft:chicken\",\n \"minecraft:donkey\",\n \"minecraft:llama\",\n \"minecraft:trader_llama\",\n \"minecraft:mule\",\n \"minecraft:frog\",\n \"minecraft:goat\",\n \"minecraft:mooshroom\",\n \"minecraft:turtle\"\n]\n");
    public static final Set<ResourceLocation> LEAVES = new HashSet<ResourceLocation>();
    public static final Set<ResourceLocation> ENTITIES = new HashSet<ResourceLocation>();
    private static final int CACHED_SPEED_PENALTY = Mth.m_14045_((int)TLConfig.getOrDefault("SpeedPenalty", Integer.class), (int)0, (int)100);
    public static final float MOVEMENT_PENALTY = (float)CACHED_SPEED_PENALTY * 0.02f;
    public static final float ARMOR_SCALE_FACTOR = (2.0f - MOVEMENT_PENALTY) * 0.05f;
    public static final boolean ARMOR_HELPS = TLConfig.getOrDefault("ArmorBonus", Boolean.class);
    public static final boolean IS_LEAVES_WHITELIST = TLConfig.getOrDefault("LeavesWhitelist", Boolean.class);
    public static final boolean IS_ENTITIES_WHITELIST = TLConfig.getOrDefault("EntityWhitelist", Boolean.class);

    static <T> T getOrDefault(String key, Class<T> clazz) {
        try {
            if (CONFIG.get(key) == null) {
                TraversableLeaves.LOGGER.error("Key [{}] is missing from Config: [{}] | Marking config file for repair...", (Object)key, (Object)fileName);
                configNeedsRepair = true;
                return clazz.cast(DEFAULT_CONFIG.get(key));
            }
            return clazz.cast(CONFIG.get(key));
        }
        catch (Exception e) {
            TraversableLeaves.LOGGER.error("Value: [{}] for [{}] is an invalid type in Config: {} | Expected: [{}] but got: [{}] | Marking config file for repair...", new Object[]{CONFIG.get(key), key, fileName, clazz.getTypeName(), CONFIG.get(key).getClass().getTypeName()});
            configNeedsRepair = true;
            return clazz.cast(DEFAULT_CONFIG.get(key));
        }
    }

    static Config parseFileOrDefault() {
        try {
            Files.createDirectories(Path.of("config/traversable_leaves", new String[0]), new FileAttribute[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new TomlParser().parse(Path.of(fileName, new String[0]).toAbsolutePath(), (path, configFormat) -> {
            FileWriter writer = new FileWriter(path.toFile().getAbsolutePath());
            writer.write(defaultConfig);
            writer.close();
            return true;
        });
    }

    public static void repairConfig() {
        TraversableLeaves.LOGGER.info("An issue was found with config: {} | You can find a copy of faulty config at: {} | Repairing...", (Object)fileName, (Object)fileName.replace(".toml", "_faulty.toml"));
        Path sourcePath = Paths.get(fileName, new String[0]);
        Path destinationPath = Paths.get(fileName.replace(".toml", "_faulty.toml"), new String[0]);
        try {
            Files.copy(sourcePath, destinationPath, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            TraversableLeaves.LOGGER.warn("Exception during faulty config caching: {}", (Object)e.getMessage());
        }
        try (FileWriter writer = new FileWriter(new File(fileName).getAbsolutePath());){
            StringBuilder contents = new StringBuilder("#Movement Speed penalty while traversing leaves, 0 = no penalty (Range : 0 - 100)\n");
            contents.append("SpeedPenalty = ").append(CACHED_SPEED_PENALTY).append(" #Default: 27\n").append("\n").append("#Whether Armor value reduces movement penalty\n").append("ArmorBonus = ").append(ARMOR_HELPS).append(" #Defualt: true\n").append("\n").append("#List of leaves (false = Blacklist)\n").append("LeavesWhitelist = ").append(IS_LEAVES_WHITELIST).append(" #Default: true\n").append("Traversable=[\n");
            for (ResourceLocation rL : LEAVES) {
                contents.append("   \"").append(rL.toString()).append("\",\n");
            }
            contents.append("]\n\n#List of Entities that can/cannot traverse leaves (false = Blacklist)\nEntityWhitelist = ").append(IS_ENTITIES_WHITELIST).append(" #Default: false\n").append("Entities=[\n");
            for (ResourceLocation rL : ENTITIES) {
                contents.append("   \"").append(rL.toString()).append("\",\n");
            }
            contents.append("]\n");
            writer.write(contents.toString());
        }
        catch (IOException e) {
            TraversableLeaves.LOGGER.warn("Exception during config repair: {}", (Object)e.getMessage());
        }
    }

    static {
        List leafStrings = TLConfig.getOrDefault("Traversable", List.class);
        leafStrings.forEach(leaf -> LEAVES.add(new ResourceLocation(leaf)));
        List entityStrings = TLConfig.getOrDefault("Entities", List.class);
        entityStrings.forEach(entity -> ENTITIES.add(new ResourceLocation(entity)));
    }
}

