/*
 * Decompiled with CFR 0.152.
 */
package com.dreu.traversableleaves.mixin;

import com.dreu.traversableleaves.config.TLConfig;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;

@Mixin(value={LeavesBlock.class})
public abstract class LeavesBlockMixin
extends Block {
    public LeavesBlockMixin(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(7))).m_61124_((Property)LeavesBlock.f_54419_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LeavesBlock.f_221367_, (Comparable)Boolean.valueOf(false)));
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public VoxelShape m_5939_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext context) {
        EntityCollisionContext entityContext;
        if (context instanceof EntityCollisionContext && (entityContext = (EntityCollisionContext)context).m_193113_() != null) {
            return this.isTraversable() && TLConfig.IS_ENTITIES_WHITELIST == TLConfig.ENTITIES.contains(ForgeRegistries.ENTITY_TYPES.getKey((Object)entityContext.m_193113_().m_6095_())) && (!context.m_6513_(Shapes.m_83144_(), blockPos, true) || context.m_6226_()) ? Shapes.m_83040_() : Shapes.m_83144_();
        }
        return Shapes.m_83144_();
    }

    @ParametersAreNonnullByDefault
    public void m_7892_(BlockState blockState, Level level, BlockPos blockPos, Entity entity) {
        if (!this.isTraversable()) {
            return;
        }
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            this.createAmbience(entity, blockPos);
            livingEntity.m_183634_();
            entity.m_20256_(entity.m_20184_().m_82542_((double)((TLConfig.MOVEMENT_PENALTY + this.getArmorBonus(livingEntity)) * 0.5f), livingEntity.m_6047_() ? 0.5 : 1.0, (double)((TLConfig.MOVEMENT_PENALTY + this.getArmorBonus(livingEntity)) * 0.5f)));
        }
    }

    private float getArmorBonus(LivingEntity livingEntity) {
        return TLConfig.ARMOR_HELPS ? TLConfig.ARMOR_SCALE_FACTOR * (float)Mth.m_14045_((int)livingEntity.m_21230_(), (int)0, (int)20) : 0.0f;
    }

    private void createAmbience(Entity entity, BlockPos blockPos) {
        if (!entity.m_20182_().equals((Object)new Vec3(entity.f_19790_, entity.f_19791_, entity.f_19792_))) {
            if (entity.f_19853_.m_46467_() % 15L == 1L) {
                entity.m_5496_(SoundEvents.f_11988_, 0.1f, 0.6f);
            }
            if (entity.f_19853_.m_46467_() % 4L == 1L) {
                double d0 = (double)blockPos.m_123341_() + entity.f_19853_.f_46441_.m_188500_();
                double d1 = (double)blockPos.m_123342_() + 1.0;
                double d2 = (double)blockPos.m_123343_() + entity.f_19853_.f_46441_.m_188500_();
                entity.f_19853_.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, this.m_49966_()), d0, d1, d2, 0.0, 0.0, 0.0);
            }
        }
    }

    public boolean isLadder(BlockState state, LevelReader level, BlockPos pos, LivingEntity entity) {
        Player player;
        return this.isTraversable() && entity instanceof Player && !(player = (Player)entity).m_6047_() && player.f_20899_;
    }

    public boolean isTraversable() {
        return TLConfig.IS_LEAVES_WHITELIST == TLConfig.LEAVES.contains(ForgeRegistries.BLOCKS.getKey((Object)this));
    }
}

