/*
 * Decompiled with CFR 0.152.
 */
package com.github.platymemo.alaskanativecraft;

import com.github.platymemo.alaskanativecraft.block.AlaskaBlocks;
import com.github.platymemo.alaskanativecraft.client.model.entity.AlaskaModels;
import com.github.platymemo.alaskanativecraft.client.renderer.block.entity.DryingRackBlockEntityRenderer;
import com.github.platymemo.alaskanativecraft.client.renderer.entity.DogsledEntityRenderer;
import com.github.platymemo.alaskanativecraft.client.renderer.entity.HarpoonEntityRenderer;
import com.github.platymemo.alaskanativecraft.client.renderer.entity.MooseEntityRenderer;
import com.github.platymemo.alaskanativecraft.client.renderer.entity.PtarmiganEntityRenderer;
import com.github.platymemo.alaskanativecraft.client.renderer.entity.SealEntityRenderer;
import com.github.platymemo.alaskanativecraft.client.renderer.entity.feature.KuspukSkirtFeatureRenderer;
import com.github.platymemo.alaskanativecraft.client.renderer.entity.feature.ShoulderPtarmiganFeatureRenderer;
import com.github.platymemo.alaskanativecraft.client.renderer.entity.feature.SnowshoeFeatureRenderer;
import com.github.platymemo.alaskanativecraft.entity.AlaskaEntities;
import com.github.platymemo.alaskanativecraft.entity.HarpoonEntity;
import com.github.platymemo.alaskanativecraft.item.AlaskaItems;
import java.util.UUID;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.blockrenderlayer.v1.BlockRenderLayerMap;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.rendereregistry.v1.BlockEntityRendererRegistry;
import net.fabricmc.fabric.api.client.rendereregistry.v1.EntityRendererRegistry;
import net.fabricmc.fabric.api.client.rendereregistry.v1.LivingEntityFeatureRendererRegistrationCallback;
import net.fabricmc.fabric.api.client.rendering.v1.ColorProviderRegistry;
import net.minecraft.class_1007;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1768;
import net.minecraft.class_1921;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_638;
import net.minecraft.class_877;
import net.minecraft.class_909;

@Environment(value=EnvType.CLIENT)
public class AlaskaNativeCraftClient
implements ClientModInitializer {
    @Environment(value=EnvType.CLIENT)
    public static void registerEntityRenderers() {
        EntityRendererRegistry.INSTANCE.register(AlaskaEntities.WOODEN_HARPOON, HarpoonEntityRenderer::new);
        EntityRendererRegistry.INSTANCE.register(AlaskaEntities.STONE_HARPOON, HarpoonEntityRenderer::new);
        EntityRendererRegistry.INSTANCE.register(AlaskaEntities.IRON_HARPOON, HarpoonEntityRenderer::new);
        EntityRendererRegistry.INSTANCE.register(AlaskaEntities.GOLDEN_HARPOON, HarpoonEntityRenderer::new);
        EntityRendererRegistry.INSTANCE.register(AlaskaEntities.DIAMOND_HARPOON, HarpoonEntityRenderer::new);
        EntityRendererRegistry.INSTANCE.register(AlaskaEntities.NETHERITE_HARPOON, HarpoonEntityRenderer::new);
        EntityRendererRegistry.INSTANCE.register(AlaskaEntities.HARP_SEAL, SealEntityRenderer::new);
        EntityRendererRegistry.INSTANCE.register(AlaskaEntities.PTARMIGAN, PtarmiganEntityRenderer::new);
        EntityRendererRegistry.INSTANCE.register(AlaskaEntities.MOOSE, MooseEntityRenderer::new);
        EntityRendererRegistry.INSTANCE.register(AlaskaEntities.DOGSLED, DogsledEntityRenderer::new);
        LivingEntityFeatureRendererRegistrationCallback.EVENT.register((entityType, entityRenderer, registrationHelper, context) -> {
            if (entityRenderer instanceof class_909 || entityRenderer instanceof class_877) {
                registrationHelper.register(new KuspukSkirtFeatureRenderer(entityRenderer, context.method_32170()));
                registrationHelper.register(new SnowshoeFeatureRenderer(entityRenderer, context.method_32170()));
            } else if (entityRenderer instanceof class_1007) {
                class_1007 playerEntityRenderer = (class_1007)entityRenderer;
                registrationHelper.register(new KuspukSkirtFeatureRenderer(playerEntityRenderer, context.method_32170()));
                registrationHelper.register(new SnowshoeFeatureRenderer(playerEntityRenderer, context.method_32170()));
                registrationHelper.register(new ShoulderPtarmiganFeatureRenderer(playerEntityRenderer, context.method_32170()));
            }
        });
    }

    @Environment(value=EnvType.CLIENT)
    public static void registerHarpoonPacket() {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)HarpoonEntity.SPAWN_PACKET, (client, handler, packet, responseSender) -> {
            class_1299 type = (class_1299)class_2378.field_11145.method_10200(packet.method_10816());
            UUID entityUUID = packet.method_10790();
            int entityID = packet.method_10816();
            double x = packet.readDouble();
            double y = packet.readDouble();
            double z = packet.readDouble();
            float pitch = (float)(packet.readByte() * 360) / 256.0f;
            float yaw = (float)(packet.readByte() * 360) / 256.0f;
            class_638 world = class_310.method_1551().field_1687;
            class_1297 entity = type.method_5883((class_1937)world);
            client.execute(() -> {
                if (entity != null) {
                    entity.method_5759(x, y, z, yaw, pitch, 0, false);
                    entity.method_18003(x, y, z);
                    entity.method_5838(entityID);
                    entity.method_5826(entityUUID);
                    assert (world != null);
                    world.method_2942(entityID, entity);
                }
            });
        });
    }

    @Environment(value=EnvType.CLIENT)
    public static void registerBlockEntityRenderers() {
        BlockEntityRendererRegistry.INSTANCE.register(AlaskaBlocks.DRYING_RACK_BLOCK_ENTITY, DryingRackBlockEntityRenderer::new);
    }

    @Environment(value=EnvType.CLIENT)
    public static void registerBlockRenderLayers() {
        class_1921 cutout = class_1921.method_23581();
        BlockRenderLayerMap.INSTANCE.putBlock((class_2248)AlaskaBlocks.BLUEBERRY_BUSH, cutout);
        BlockRenderLayerMap.INSTANCE.putBlock((class_2248)AlaskaBlocks.CLOUDBERRY_BUSH, cutout);
        BlockRenderLayerMap.INSTANCE.putBlock((class_2248)AlaskaBlocks.RASPBERRY_BUSH, cutout);
        BlockRenderLayerMap.INSTANCE.putBlock((class_2248)AlaskaBlocks.SALMONBERRY_BUSH, cutout);
    }

    @Environment(value=EnvType.CLIENT)
    public static void registerItemColors() {
        ColorProviderRegistry.ITEM.register((stack, tintIndex) -> tintIndex > 0 ? -1 : ((class_1768)stack.method_7909()).method_7800(stack), (Object[])new class_1935[]{AlaskaItems.KUSPUK_HOOD, AlaskaItems.KUSPUK_BODY, AlaskaItems.MUKLUKS});
    }

    public void onInitializeClient() {
        AlaskaNativeCraftClient.registerBlockEntityRenderers();
        AlaskaNativeCraftClient.registerBlockRenderLayers();
        AlaskaNativeCraftClient.registerItemColors();
        AlaskaModels.registerEntityModels();
        AlaskaNativeCraftClient.registerEntityRenderers();
        AlaskaNativeCraftClient.registerHarpoonPacket();
    }
}

