/*
 * Decompiled with CFR 0.152.
 */
package com.github.platymemo.alaskanativecraft.block;

import com.github.platymemo.alaskanativecraft.block.AlaskaBlocks;
import com.github.platymemo.alaskanativecraft.block.entity.DryingRackBlockEntity;
import com.github.platymemo.alaskanativecraft.recipe.DryingRecipe;
import java.util.Optional;
import net.minecraft.class_10;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2464;
import net.minecraft.class_2470;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3481;
import net.minecraft.class_3494;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DryingRackBlock
extends class_2237
implements class_3737 {
    public static final class_2746 WATERLOGGED;
    public static final class_2746 CONNECTED_POS;
    public static final class_2746 CONNECTED_NEG;
    public static final class_2754<class_2350.class_2351> AXIS;
    private static final class_265 X_SHAPE;
    private static final class_265 Z_SHAPE;

    public DryingRackBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)this.method_9595().method_11664()).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)CONNECTED_POS, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)CONNECTED_NEG, (Comparable)Boolean.valueOf(false))).method_11657(AXIS, (Comparable)class_2350.class_2351.field_11051));
    }

    public class_1269 method_9534(class_2680 state, @NotNull class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_2586 blockEntity = world.method_8321(pos);
        if (!world.field_9236 && blockEntity instanceof DryingRackBlockEntity) {
            DryingRackBlockEntity dryingRackBlockEntity = (DryingRackBlockEntity)blockEntity;
            class_1799 itemStack = player.method_5998(hand);
            Optional<DryingRecipe> optional = dryingRackBlockEntity.getRecipeFor(itemStack);
            if (optional.isPresent()) {
                if (dryingRackBlockEntity.addItem(player.method_31549().field_7477 ? itemStack.method_7972() : itemStack, optional.get().method_8167())) {
                    return class_1269.field_5812;
                }
                return class_1269.field_21466;
            }
            class_1799 dryingRackItem = dryingRackBlockEntity.getDriedItem();
            class_1264.method_5449((class_1937)world, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), (class_1799)dryingRackItem);
            return class_1269.field_5812;
        }
        return class_1269.field_5812;
    }

    public void method_9536(@NotNull class_2680 state, class_1937 world, class_2338 pos, @NotNull class_2680 newState, boolean moved) {
        if (!state.method_27852(newState.method_26204())) {
            class_2586 blockEntity = world.method_8321(pos);
            if (blockEntity instanceof DryingRackBlockEntity) {
                class_1264.method_17349((class_1937)world, (class_2338)pos, ((DryingRackBlockEntity)blockEntity).getItemsBeingDried());
            }
            super.method_9536(state, world, pos, newState, moved);
        }
    }

    public class_265 method_9530(@NotNull class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        if (state.method_11654(AXIS) == class_2350.class_2351.field_11048) {
            return X_SHAPE;
        }
        return Z_SHAPE;
    }

    @Nullable
    public class_2680 method_9605(@NotNull class_1750 ctx) {
        boolean bl = ctx.method_8045().method_8316(ctx.method_8037()).method_15772() == class_3612.field_15910;
        class_1937 world = ctx.method_8045();
        class_2338 blockPos = ctx.method_8037();
        class_2680 state = this.method_9564();
        class_2350 direction = ctx.method_8042();
        class_2350.class_2351 axis = direction.method_10166() == class_2350.class_2351.field_11048 ? class_2350.class_2351.field_11051 : class_2350.class_2351.field_11048;
        class_2350 left = class_2350.method_10156((class_2350.class_2352)class_2350.class_2352.field_11060, (class_2350.class_2351)axis);
        class_2350 right = class_2350.method_10156((class_2350.class_2352)class_2350.class_2352.field_11056, (class_2350.class_2351)axis);
        return (class_2680)((class_2680)((class_2680)((class_2680)state.method_11657(AXIS, (Comparable)axis)).method_11657((class_2769)CONNECTED_NEG, (Comparable)Boolean.valueOf(this.canConnect(left, world.method_8320(blockPos.method_10093(left)))))).method_11657((class_2769)CONNECTED_POS, (Comparable)Boolean.valueOf(this.canConnect(right, world.method_8320(blockPos.method_10093(right)))))).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(bl));
    }

    public class_2680 method_9598(@NotNull class_2680 state, class_2470 rotation) {
        return switch (rotation) {
            case class_2470.field_11465, class_2470.field_11463 -> {
                switch ((class_2350.class_2351)state.method_11654(AXIS)) {
                    case field_11048: {
                        yield (class_2680)state.method_11657(AXIS, (Comparable)class_2350.class_2351.field_11051);
                    }
                    case field_11051: {
                        yield (class_2680)state.method_11657(AXIS, (Comparable)class_2350.class_2351.field_11048);
                    }
                }
                yield state;
            }
            default -> state;
        };
    }

    private boolean canConnect(class_2350 direction, @NotNull class_2680 otherState) {
        if (otherState.method_26164((class_3494)class_3481.field_15475) || otherState.method_26164((class_3494)class_3481.field_15504) || otherState.method_26164((class_3494)class_3481.field_16584) || otherState.method_26164((class_3494)class_3481.field_25147)) {
            return true;
        }
        if (otherState.method_27852((class_2248)this)) {
            return otherState.method_11654(AXIS) == direction.method_10166();
        }
        return false;
    }

    public class_2680 method_9559(@NotNull class_2680 state, class_2350 direction, class_2680 newState, class_1936 world, class_2338 pos, class_2338 posFrom) {
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            world.method_39281(pos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789((class_4538)world));
        }
        return state.method_11654(AXIS) == direction.method_10166() ? (class_2680)state.method_11657((class_2769)(direction.method_10171() == class_2350.class_2352.field_11056 ? CONNECTED_POS : CONNECTED_NEG), (Comparable)Boolean.valueOf(this.canConnect(direction, newState))) : super.method_9559(state, direction, newState, world, pos, posFrom);
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    public boolean method_10311(class_1936 world, class_2338 pos, @NotNull class_2680 state, class_3610 fluidState) {
        if (!((Boolean)state.method_11654((class_2769)class_2741.field_12508)).booleanValue() && fluidState.method_15772() == class_3612.field_15910) {
            class_2586 blockEntity = world.method_8321(pos);
            if (blockEntity instanceof DryingRackBlockEntity) {
                ((DryingRackBlockEntity)blockEntity).spawnItemsBeingDried();
            }
            world.method_8652(pos, (class_2680)state.method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(true)), 3);
            world.method_39281(pos, fluidState.method_15772(), fluidState.method_15772().method_15789((class_4538)world));
            return true;
        }
        return false;
    }

    public class_3610 method_9545(@NotNull class_2680 state) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    public boolean method_9516(class_2680 state, class_1922 world, class_2338 pos, class_10 type) {
        return false;
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(@NotNull class_1937 world, class_2680 state, class_2591<T> type) {
        if (!world.field_9236) {
            if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue() || world.method_8419()) {
                return DryingRackBlock.method_31618(type, AlaskaBlocks.DRYING_RACK_BLOCK_ENTITY, DryingRackBlockEntity::possiblyWetTick);
            }
            return DryingRackBlock.method_31618(type, AlaskaBlocks.DRYING_RACK_BLOCK_ENTITY, DryingRackBlockEntity::updateItemsBeingDried);
        }
        return null;
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new DryingRackBlockEntity(pos, state);
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{WATERLOGGED}).method_11667(new class_2769[]{CONNECTED_POS}).method_11667(new class_2769[]{CONNECTED_NEG}).method_11667(new class_2769[]{AXIS});
    }

    static {
        X_SHAPE = class_2248.method_9541((double)0.0, (double)0.0, (double)6.0, (double)16.0, (double)8.0, (double)10.0);
        Z_SHAPE = class_2248.method_9541((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)8.0, (double)16.0);
        WATERLOGGED = class_2741.field_12508;
        CONNECTED_POS = class_2746.method_11825((String)"positive");
        CONNECTED_NEG = class_2746.method_11825((String)"negative");
        AXIS = class_2754.method_11848((String)"axis", class_2350.class_2351.class, class_2350.class_2351::method_10179);
    }
}

