/*
 * Decompiled with CFR 0.152.
 */
package com.github.platymemo.alaskanativecraft.block.entity;

import com.github.platymemo.alaskanativecraft.block.AlaskaBlocks;
import com.github.platymemo.alaskanativecraft.recipe.AlaskaRecipes;
import com.github.platymemo.alaskanativecraft.recipe.DryingRecipe;
import java.util.Optional;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1277;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_3829;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DryingRackBlockEntity
extends class_2586
implements class_3829 {
    private final class_2371<class_1799> itemsBeingDried = class_2371.method_10213((int)4, (Object)class_1799.field_8037);
    private final int[] dryingTimes = new int[4];
    private final int[] dryingTotalTimes = new int[4];

    public DryingRackBlockEntity(class_2338 pos, class_2680 state) {
        super(AlaskaBlocks.DRYING_RACK_BLOCK_ENTITY, pos, state);
    }

    public static void possiblyWetTick(@NotNull class_1937 world, class_2338 pos, class_2680 state, DryingRackBlockEntity dryingRackBlockEntity) {
        if (world.method_8311(pos)) {
            for (int i = 0; i < dryingRackBlockEntity.itemsBeingDried.size(); ++i) {
                if (dryingRackBlockEntity.dryingTimes[i] <= 0) continue;
                dryingRackBlockEntity.dryingTimes[i] = class_3532.method_15340((int)(dryingRackBlockEntity.dryingTimes[i] - 2), (int)0, (int)dryingRackBlockEntity.dryingTotalTimes[i]);
            }
        } else {
            DryingRackBlockEntity.updateItemsBeingDried(world, pos, state, dryingRackBlockEntity);
        }
    }

    public static void updateItemsBeingDried(class_1937 world, class_2338 pos, class_2680 state, @NotNull DryingRackBlockEntity dryingRackBlockEntity) {
        for (int i = 0; i < dryingRackBlockEntity.itemsBeingDried.size(); ++i) {
            class_1799 itemStack = (class_1799)dryingRackBlockEntity.itemsBeingDried.get(i);
            if (itemStack.method_7960()) continue;
            int n = i;
            dryingRackBlockEntity.dryingTimes[n] = dryingRackBlockEntity.dryingTimes[n] + 1;
            if (dryingRackBlockEntity.dryingTimes[i] < dryingRackBlockEntity.dryingTotalTimes[i]) continue;
            dryingRackBlockEntity.dryingTimes[i] = dryingRackBlockEntity.dryingTotalTimes[i];
            class_1277 inventory = new class_1277(new class_1799[]{itemStack});
            class_1799 itemStack2 = world.method_8433().method_8132(AlaskaRecipes.DRYING, (class_1263)inventory, world).map(arg_0 -> DryingRackBlockEntity.lambda$updateItemsBeingDried$0((class_1263)inventory, arg_0)).orElse(itemStack);
            dryingRackBlockEntity.itemsBeingDried.set(i, (Object)itemStack2);
            dryingRackBlockEntity.updateListeners();
        }
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2371<class_1799> getItemsBeingDried() {
        return this.itemsBeingDried;
    }

    public class_1799 getDriedItem() {
        class_1799 stack;
        int i;
        for (i = 0; i < this.itemsBeingDried.size(); ++i) {
            if (this.dryingTimes[i] < this.dryingTotalTimes[i] || (stack = (class_1799)this.itemsBeingDried.get(i)).method_7960()) continue;
            this.itemsBeingDried.set(i, (Object)class_1799.field_8037);
            this.updateListeners();
            return stack;
        }
        for (i = 0; i < this.itemsBeingDried.size(); ++i) {
            stack = (class_1799)this.itemsBeingDried.get(i);
            if (stack.method_7960()) continue;
            this.itemsBeingDried.set(i, (Object)class_1799.field_8037);
            this.updateListeners();
            return stack;
        }
        return class_1799.field_8037;
    }

    public void method_11014(class_2487 nbt) {
        this.itemsBeingDried.clear();
        class_1262.method_5429((class_2487)nbt, this.itemsBeingDried);
        if (nbt.method_10573("DryingTimes", 11)) {
            int[] js = nbt.method_10561("DryingTimes");
            System.arraycopy(js, 0, this.dryingTimes, 0, Math.min(this.dryingTotalTimes.length, js.length));
        }
    }

    public void method_11007(class_2487 nbt) {
        this.saveInitialChunkData(nbt);
        nbt.method_10539("DryingTimes", this.dryingTimes);
        nbt.method_10539("DryingTotalTimes", this.dryingTotalTimes);
    }

    private class_2487 saveInitialChunkData(class_2487 tag) {
        class_1262.method_5427((class_2487)tag, this.itemsBeingDried, (boolean)true);
        return tag;
    }

    public class_2487 method_16887() {
        return this.saveInitialChunkData(new class_2487());
    }

    public Optional<DryingRecipe> getRecipeFor(class_1799 item) {
        return this.itemsBeingDried.stream().noneMatch(class_1799::method_7960) ? Optional.empty() : this.field_11863.method_8433().method_8132(AlaskaRecipes.DRYING, (class_1263)new class_1277(new class_1799[]{item}), this.field_11863);
    }

    public boolean addItem(class_1799 item, int integer) {
        for (int i = 0; i < this.itemsBeingDried.size(); ++i) {
            class_1799 itemStack = (class_1799)this.itemsBeingDried.get(i);
            if (!itemStack.method_7960()) continue;
            this.dryingTotalTimes[i] = integer;
            this.dryingTimes[i] = 0;
            this.itemsBeingDried.set(i, (Object)item.method_7971(1));
            this.updateListeners();
            return true;
        }
        return false;
    }

    private void updateListeners() {
        this.method_5431();
        this.method_10997().method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 3);
    }

    public void method_5448() {
        this.itemsBeingDried.clear();
    }

    public void spawnItemsBeingDried() {
        if (this.field_11863 != null) {
            if (!this.field_11863.field_9236) {
                class_1264.method_17349((class_1937)this.field_11863, (class_2338)this.method_11016(), this.getItemsBeingDried());
            }
            this.updateListeners();
        }
    }

    private static /* synthetic */ class_1799 lambda$updateItemsBeingDried$0(class_1263 inventory, DryingRecipe dryingRecipe) {
        return dryingRecipe.method_8116(inventory);
    }
}

