/*
 * Decompiled with CFR 0.152.
 */
package com.github.platymemo.alaskanativecraft.client.model.entity;

import com.github.platymemo.alaskanativecraft.entity.PtarmiganEntity;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5597;
import net.minecraft.class_5603;
import net.minecraft.class_5606;
import net.minecraft.class_5607;
import net.minecraft.class_5609;
import net.minecraft.class_5610;
import net.minecraft.class_630;
import org.jetbrains.annotations.NotNull;

@Environment(value=EnvType.CLIENT)
public class PtarmiganEntityModel
extends class_5597<PtarmiganEntity> {
    private final class_630 root;
    private final class_630 body;
    private final class_630 tail;
    private final class_630 leftWing;
    private final class_630 rightWing;
    private final class_630 head;
    private final class_630 leftLeg;
    private final class_630 rightLeg;

    public PtarmiganEntityModel(@NotNull class_630 root) {
        this.root = root;
        this.body = root.method_32086("body");
        this.tail = root.method_32086("tail");
        this.leftWing = root.method_32086("left_wing");
        this.rightWing = root.method_32086("right_wing");
        this.head = root.method_32086("head");
        this.leftLeg = root.method_32086("left_leg");
        this.rightLeg = root.method_32086("right_leg");
    }

    @NotNull
    public static class_5607 getTexturedModelData() {
        class_5609 modelData = new class_5609();
        class_5610 root = modelData.method_32111();
        root.method_32117("body", class_5606.method_32108().method_32101(0, 7).method_32097(-2.5f, 0.0f, -2.5f, 5.0f, 6.0f, 5.0f), class_5603.method_32090((float)0.0f, (float)16.5f, (float)-3.0f));
        root.method_32117("tail", class_5606.method_32108().method_32101(24, 0).method_32097(-1.5f, -1.0f, 0.0f, 3.0f, 4.0f, 1.0f), class_5603.method_32090((float)0.0f, (float)21.07f, (float)1.16f));
        root.method_32117("left_wing", class_5606.method_32108().method_32101(2, 22).method_32097(-2.0f, 0.0f, -1.5f, 1.0f, 5.0f, 3.0f), class_5603.method_32090((float)2.5f, (float)16.94f, (float)-2.76f));
        root.method_32117("right_wing", class_5606.method_32108().method_32101(2, 22).method_32097(1.0f, 0.0f, -1.5f, 1.0f, 5.0f, 3.0f), class_5603.method_32090((float)-2.5f, (float)16.94f, (float)-2.76f));
        class_5610 head = root.method_32117("head", class_5606.method_32108().method_32101(0, 0).method_32097(-1.0f, -1.5f, -1.0f, 2.0f, 3.0f, 2.0f), class_5603.method_32090((float)0.0f, (float)15.69f, (float)-2.76f));
        head.method_32117("beak", class_5606.method_32108().method_32101(9, 0).method_32097(-0.5f, -1.0f, -0.5f, 1.0f, 2.0f, 1.0f), class_5603.method_32090((float)0.0f, (float)-0.5f, (float)-1.5f));
        class_5606 legBuilder = class_5606.method_32108().method_32101(14, 24).method_32097(-0.5f, 0.0f, -0.5f, 1.0f, 2.0f, 1.0f);
        root.method_32117("left_leg", legBuilder, class_5603.method_32090((float)1.0f, (float)22.0f, (float)-1.05f));
        root.method_32117("right_leg", legBuilder, class_5603.method_32090((float)-1.0f, (float)22.0f, (float)-1.05f));
        return class_5607.method_32110((class_5609)modelData, (int)32, (int)32);
    }

    private static Pose getPose(@NotNull PtarmiganEntity ptarmigan) {
        if (ptarmigan.method_6582()) {
            return Pose.PARTY;
        }
        if (ptarmigan.method_6172()) {
            return Pose.SITTING;
        }
        return ptarmigan.method_6581() ? Pose.FLYING : Pose.STANDING;
    }

    public class_630 method_32008() {
        return this.root;
    }

    public void setAngles(PtarmiganEntity ptarmiganEntity, float f, float g, float h, float i, float j) {
        this.setAngles(PtarmiganEntityModel.getPose(ptarmiganEntity), ptarmiganEntity.field_6012, f, g, h, i, j);
    }

    public void animateModel(PtarmiganEntity ptarmiganEntity, float f, float g, float h) {
        this.animateModel(PtarmiganEntityModel.getPose(ptarmiganEntity));
    }

    public void poseOnShoulder(class_4587 matrices, class_4588 vertexConsumer, int light, int overlay, float limbAngle, float limbDistance, float headYaw, float headPitch, int danceAngle) {
        this.animateModel(Pose.ON_SHOULDER);
        this.setAngles(Pose.ON_SHOULDER, danceAngle, limbAngle, limbDistance, 0.0f, headYaw, headPitch);
        this.root.method_22698(matrices, vertexConsumer, light, overlay);
    }

    private void setAngles(@NotNull Pose pose, int danceAngle, float limbAngle, float limbDistance, float age, float headYaw, float headPitch) {
        this.head.field_3654 = headPitch * ((float)Math.PI / 180);
        this.head.field_3675 = headYaw * ((float)Math.PI / 180);
        this.head.field_3674 = 0.0f;
        this.head.field_3657 = 0.0f;
        this.body.field_3657 = 0.0f;
        this.tail.field_3657 = 0.0f;
        this.rightWing.field_3657 = -1.5f;
        this.leftWing.field_3657 = 1.5f;
        switch (pose) {
            case SITTING: {
                break;
            }
            case PARTY: {
                float cosDanceAngle = class_3532.method_15362((float)danceAngle);
                float sinDanceAngle = class_3532.method_15374((float)danceAngle);
                this.head.field_3657 = cosDanceAngle;
                this.head.field_3656 = 15.69f + sinDanceAngle;
                this.head.field_3654 = 0.0f;
                this.head.field_3675 = 0.0f;
                this.head.field_3674 = class_3532.method_15374((float)danceAngle) * 0.4f;
                this.body.field_3657 = cosDanceAngle;
                this.body.field_3656 = 16.5f + sinDanceAngle;
                this.leftWing.field_3674 = -0.0873f - age;
                this.leftWing.field_3657 = 1.5f + cosDanceAngle;
                this.leftWing.field_3656 = 16.94f + sinDanceAngle;
                this.rightWing.field_3674 = 0.0873f + age;
                this.rightWing.field_3657 = -1.5f + cosDanceAngle;
                this.rightWing.field_3656 = 16.94f + sinDanceAngle;
                this.tail.field_3657 = cosDanceAngle;
                this.tail.field_3656 = 21.07f + sinDanceAngle;
                break;
            }
            case STANDING: {
                this.leftLeg.field_3654 += class_3532.method_15362((float)(limbAngle * 0.6662f)) * 1.4f * limbDistance;
                this.rightLeg.field_3654 += class_3532.method_15362((float)(limbAngle * 0.6662f + (float)Math.PI)) * 1.4f * limbDistance;
            }
            default: {
                float thirdOfAge = age * 0.3f;
                this.head.field_3656 = 15.69f + thirdOfAge;
                this.tail.field_3654 = 1.015f + class_3532.method_15362((float)(limbAngle * 0.6662f)) * 0.3f * limbDistance;
                this.tail.field_3656 = 21.07f + thirdOfAge;
                this.body.field_3656 = 16.5f + thirdOfAge;
                this.leftWing.field_3674 = -0.0873f - age;
                this.leftWing.field_3656 = 16.94f + thirdOfAge;
                this.rightWing.field_3674 = 0.0873f + age;
                this.rightWing.field_3656 = 16.94f + thirdOfAge;
                this.leftLeg.field_3656 = 22.0f + thirdOfAge;
                this.rightLeg.field_3656 = 22.0f + thirdOfAge;
            }
        }
    }

    private void animateModel(@NotNull Pose pose) {
        this.body.field_3654 = 0.4937f;
        this.leftWing.field_3654 = -0.6981f;
        this.leftWing.field_3675 = (float)(-Math.PI);
        this.rightWing.field_3654 = -0.6981f;
        this.rightWing.field_3675 = (float)(-Math.PI);
        this.leftLeg.field_3654 = -0.0299f;
        this.rightLeg.field_3654 = -0.0299f;
        this.leftLeg.field_3656 = 22.0f;
        this.rightLeg.field_3656 = 22.0f;
        this.leftLeg.field_3674 = 0.0f;
        this.rightLeg.field_3674 = 0.0f;
        switch (pose) {
            case SITTING: {
                this.head.field_3656 = 17.59f;
                this.tail.field_3654 = 1.5388988f;
                this.tail.field_3656 = 22.97f;
                this.body.field_3656 = 18.4f;
                this.leftWing.field_3674 = -0.0873f;
                this.leftWing.field_3656 = 18.84f;
                this.rightWing.field_3674 = 0.0873f;
                this.rightWing.field_3656 = 18.84f;
                this.leftLeg.field_3656 += 1.0f;
                this.rightLeg.field_3656 += 1.0f;
                this.leftLeg.field_3654 += 1.0f;
                this.rightLeg.field_3654 += 1.0f;
                break;
            }
            case PARTY: {
                this.leftLeg.field_3674 = -0.34906584f;
                this.rightLeg.field_3674 = 0.34906584f;
            }
            default: {
                break;
            }
            case FLYING: {
                this.leftLeg.field_3654 += 0.6981317f;
                this.rightLeg.field_3654 += 0.6981317f;
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static enum Pose {
        FLYING,
        STANDING,
        SITTING,
        PARTY,
        ON_SHOULDER;

    }
}

